/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.ArrayList;
import java.util.Map;
import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionTimer;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionTimerXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ActionTimer p = (ActionTimer)o;
        Element element = new Element("ActionTimer");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("StartSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getStartExpressionSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getStartExpressionSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        e2 = new Element("StopSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(1).getName()));
        socket = p.getStopExpressionSocket().getConnectedSocket();
        socketSystemName = socket != null ? socket.getSystemName() : p.getStopExpressionSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        Element e = new Element("Actions");
        int i = 0;
        while (i < p.getNumActions()) {
            e2 = new Element("Socket");
            e2.addContent((Content)new Element("delay").addContent(Integer.toString(p.getDelay(i))));
            e2.addContent((Content)new Element("socketName").addContent(p.getActionSocket(i).getName()));
            socket = p.getActionSocket(i).getConnectedSocket();
            socketSystemName = socket != null ? socket.getSystemName() : p.getActionSocketSystemName(i);
            if (socketSystemName != null) {
                e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
            }
            e.addContent((Content)e2);
            ++i;
        }
        element.addContent((Content)e);
        element.addContent((Content)new Element("startImmediately").addContent(p.getStartImmediately() ? "yes" : "no"));
        element.addContent((Content)new Element("runContinuously").addContent(p.getRunContinuously() ? "yes" : "no"));
        element.addContent((Content)new Element("unit").addContent(p.getUnit().name()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        ArrayList<Map.Entry<String, String>> expressionSystemNames = new ArrayList<Map.Entry<String, String>>();
        Element socketNameElement = shared.getChild("StartSocket").getChild("socketName");
        String startSocketName = socketNameElement.getTextTrim();
        Element socketSystemNameElement = shared.getChild("StartSocket").getChild("systemName");
        String startSocketSystemName = null;
        if (socketSystemNameElement != null) {
            startSocketSystemName = socketSystemNameElement.getTextTrim();
        }
        socketNameElement = shared.getChild("StopSocket").getChild("socketName");
        String stopSocketName = socketNameElement.getTextTrim();
        socketSystemNameElement = shared.getChild("StopSocket").getChild("systemName");
        String stopSocketSystemName = null;
        if (socketSystemNameElement != null) {
            stopSocketSystemName = socketSystemNameElement.getTextTrim();
        }
        ArrayList<ActionTimer.ActionData> actionDataList = new ArrayList<ActionTimer.ActionData>();
        Element actionElement = shared.getChild("Actions");
        for (Element socketElement : actionElement.getChildren()) {
            String socketName = socketElement.getChild("socketName").getTextTrim();
            Element systemNameElement = socketElement.getChild("systemName");
            String systemName = null;
            if (systemNameElement != null) {
                systemName = systemNameElement.getTextTrim();
            }
            Element delayElement = socketElement.getChild("delay");
            int delay = 0;
            if (delayElement != null) {
                delay = Integer.parseInt(delayElement.getText());
            }
            actionDataList.add(new ActionTimer.ActionData(delay, socketName, systemName));
        }
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionTimer h = new ActionTimer(sys, uname, expressionSystemNames, actionDataList);
        this.loadCommon(h, shared);
        h.getChild(0).setName(startSocketName);
        h.setStartExpressionSocketSystemName(startSocketSystemName);
        h.getChild(1).setName(stopSocketName);
        h.setStopExpressionSocketSystemName(stopSocketSystemName);
        Element startImmediately = shared.getChild("startImmediately");
        if (startImmediately != null) {
            h.setStartImmediately("yes".equals(startImmediately.getTextTrim()));
        } else {
            h.setStartImmediately(false);
        }
        Element runContinuously = shared.getChild("runContinuously");
        if (runContinuously != null) {
            h.setRunContinuously("yes".equals(runContinuously.getTextTrim()));
        } else {
            h.setRunContinuously(false);
        }
        Element unit = shared.getChild("unit");
        if (unit != null) {
            h.setUnit(TimerUnit.valueOf(unit.getTextTrim()));
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

