/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionSound;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSoundXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionSoundXml.class);

    @Override
    public Element store(Object o) {
        ActionSound p = (ActionSound)o;
        Element element = new Element("ActionSound");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationType").addContent(p.getOperation().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("soundAddressing").addContent(p.getSoundAddressing().name()));
        element.addContent((Content)new Element("sound").addContent(p.getSound()));
        element.addContent((Content)new Element("soundReference").addContent(p.getSoundReference()));
        element.addContent((Content)new Element("soundLocalVariable").addContent(p.getSoundLocalVariable()));
        element.addContent((Content)new Element("soundFormula").addContent(p.getSoundFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionSound h = new ActionSound(sys, uname);
        this.loadCommon(h, shared);
        try {
            Element soundElement;
            Element queryType;
            Element elem = shared.getChild("operationAddressing");
            if (elem != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((queryType = shared.getChild("operationType")) != null) {
                h.setOperation(ActionSound.Operation.valueOf(queryType.getTextTrim()));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("soundAddressing")) != null) {
                h.setSoundAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((soundElement = shared.getChild("sound")) != null) {
                try {
                    h.setSound(soundElement.getText());
                }
                catch (NumberFormatException e) {
                    log.error("cannot parse sound: " + soundElement.getTextTrim(), (Throwable)e);
                }
            }
            if ((elem = shared.getChild("soundReference")) != null) {
                h.setSoundReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("soundLocalVariable")) != null) {
                h.setSoundLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("soundFormula")) != null) {
                h.setSoundFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

