/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionSignalHead;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        ActionSignalHead p = (ActionSignalHead)o;
        Element element = new Element("ActionSignalHead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<SignalHead> signalHead = p.getSignalHead();
        if (signalHead != null) {
            element.addContent((Content)new Element("signalHead").addContent(signalHead.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationType").addContent(p.getOperationType().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("appearanceAddressing").addContent(p.getAppearanceAddressing().name()));
        element.addContent((Content)new Element("appearance").addContent(Integer.toString(p.getAppearance())));
        element.addContent((Content)new Element("appearanceReference").addContent(p.getAppearanceReference()));
        element.addContent((Content)new Element("appearanceLocalVariable").addContent(p.getAppearanceLocalVariable()));
        element.addContent((Content)new Element("appearanceFormula").addContent(p.getAppearanceFormula()));
        signalHead = p.getExampleSignalHead();
        if (signalHead != null) {
            element.addContent((Content)new Element("exampleSignalHead").addContent(signalHead.getName()));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        SignalHead signalHead;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionSignalHead h = new ActionSignalHead(sys, uname);
        this.loadCommon(h, shared);
        Element signalHeadName = shared.getChild("signalHead");
        if (signalHeadName != null) {
            signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName.getTextTrim());
            if (signalHead != null) {
                h.setSignalHead(signalHead);
            } else {
                h.removeSignalHead();
            }
        }
        try {
            Element appearanceElement;
            Element queryType;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationAddressing")) != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((queryType = shared.getChild("operationType")) != null) {
                h.setOperationType(ActionSignalHead.OperationType.valueOf(queryType.getTextTrim()));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceAddressing")) != null) {
                h.setAppearanceAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((appearanceElement = shared.getChild("appearance")) != null) {
                try {
                    int appearance = Integer.parseInt(appearanceElement.getTextTrim());
                    h.setAppearance(appearance);
                }
                catch (NumberFormatException e) {
                    log.error("cannot parse apperance: " + appearanceElement.getTextTrim(), (Throwable)e);
                }
            }
            if ((elem = shared.getChild("appearanceReference")) != null) {
                h.setAppearanceReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceLocalVariable")) != null) {
                h.setAppearanceLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("appearanceFormula")) != null) {
                h.setAppearanceFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        signalHeadName = shared.getChild("exampleSignalHead");
        if (signalHeadName != null) {
            signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName.getTextTrim());
            if (signalHead != null) {
                h.setExampleSignalHead(signalHead);
            } else {
                h.removeSignalHead();
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

