/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionScript;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionScriptXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionScriptXml.class);

    @Override
    public Element store(Object o) {
        ActionScript p = (ActionScript)o;
        Element element = new Element("ActionScript");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationType").addContent(p.getOperationType().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("scriptAddressing").addContent(p.getScriptAddressing().name()));
        element.addContent((Content)new Element("script").addContent(p.getScript()));
        element.addContent((Content)new Element("scriptReference").addContent(p.getScriptReference()));
        element.addContent((Content)new Element("scriptLocalVariable").addContent(p.getScriptLocalVariable()));
        element.addContent((Content)new Element("scriptFormula").addContent(p.getScriptFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionScript h = new ActionScript(sys, uname);
        this.loadCommon(h, shared);
        try {
            Element scriptElement;
            Element queryType;
            Element elem = shared.getChild("operationAddressing");
            if (elem != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((queryType = shared.getChild("operationType")) != null) {
                h.setOperationType(ActionScript.OperationType.valueOf(queryType.getTextTrim()));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptAddressing")) != null) {
                h.setScriptAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((scriptElement = shared.getChild("script")) != null) {
                try {
                    h.setScript(scriptElement.getText());
                }
                catch (NumberFormatException e) {
                    log.error("cannot parse script: " + scriptElement.getTextTrim(), (Throwable)e);
                }
            }
            if ((elem = shared.getChild("scriptReference")) != null) {
                h.setScriptReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptLocalVariable")) != null) {
                h.setScriptLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("scriptFormula")) != null) {
                h.setScriptFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

