/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionReporter;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionReporterXml
extends AbstractNamedBeanManagerConfigXML {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.logixng.actions.ActionBundle");

    @Override
    public Element store(Object o) {
        ActionReporter p = (ActionReporter)o;
        Element element = new Element("ActionReporter");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Reporter> reporter = p.getReporter();
        if (reporter != null) {
            element.addContent((Content)new Element("reporter").addContent(reporter.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("reporterValue").addContent(p.getReporterValue().name()));
        element.addContent((Content)new Element("dataAddressing").addContent(p.getDataAddressing().name()));
        element.addContent((Content)new Element("dataReference").addContent(p.getDataReference()));
        element.addContent((Content)new Element("dataLocalVariable").addContent(p.getDataLocalVariable()));
        element.addContent((Content)new Element("dataFormula").addContent(p.getDataFormula()));
        NamedBeanHandle<Memory> memory = p.getMemory();
        if (memory != null) {
            element.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionReporter h = new ActionReporter(sys, uname);
        this.loadCommon(h, shared);
        Element reporterName = shared.getChild("reporter");
        if (reporterName != null) {
            Reporter t = (Reporter)InstanceManager.getDefault(ReporterManager.class).getNamedBean(reporterName.getTextTrim());
            if (t != null) {
                h.setReporter(t);
            } else {
                h.removeReporter();
            }
        }
        try {
            Element memoryName;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("reporterValue")) != null) {
                h.setReporterValue(ActionReporter.ReporterValue.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataAddressing")) != null) {
                h.setDataAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataReference")) != null) {
                h.setDataReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataLocalVariable")) != null) {
                h.setDataLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataFormula")) != null) {
                h.setDataFormula(elem.getTextTrim());
            }
            if ((memoryName = shared.getChild("memory")) != null) {
                Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(memoryName.getTextTrim());
                if (m != null) {
                    h.setMemory(m);
                } else {
                    h.removeMemory();
                }
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

