/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionOBlock;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionOBlockXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ActionOBlock p = (ActionOBlock)o;
        Element element = new Element("ActionOBlock");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<OBlock> oblock = p.getOBlock();
        if (oblock != null) {
            element.addContent((Content)new Element("oblock").addContent(oblock.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationDirect").addContent(p.getOperationDirect().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("dataAddressing").addContent(p.getDataAddressing().name()));
        element.addContent((Content)new Element("dataReference").addContent(p.getDataReference()));
        element.addContent((Content)new Element("dataLocalVariable").addContent(p.getDataLocalVariable()));
        element.addContent((Content)new Element("dataFormula").addContent(p.getDataFormula()));
        element.addContent((Content)new Element("oblockValue").addContent(p.getOBlockValue()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionOBlock h = new ActionOBlock(sys, uname);
        this.loadCommon(h, shared);
        Element oblockName = shared.getChild("oblock");
        if (oblockName != null) {
            OBlock t = (OBlock)InstanceManager.getDefault(OBlockManager.class).getNamedBean(oblockName.getTextTrim());
            if (t != null) {
                h.setOBlock(t);
            } else {
                h.removeOBlock();
            }
        }
        try {
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationAddressing")) != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("operationDirect")) != null) {
                h.setOperationDirect(ActionOBlock.DirectOperation.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataAddressing")) != null) {
                h.setDataAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataReference")) != null) {
                h.setDataReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataLocalVariable")) != null) {
                h.setDataLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataFormula")) != null) {
                h.setDataFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("oblockValue")) != null) {
                h.setOBlockValue(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

