/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionMemory;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMemoryXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionMemoryXml.class);

    @Override
    public Element store(Object o) {
        ActionMemory p = (ActionMemory)o;
        Element element = new Element("ActionMemory");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Memory> memory = p.getMemory();
        if (memory != null) {
            element.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        NamedBeanHandle<Memory> otherMemoryName = p.getOtherMemory();
        if (otherMemoryName != null) {
            element.addContent((Content)new Element("otherMemory").addContent(otherMemoryName.getName()));
        }
        element.addContent((Content)new Element("memoryOperation").addContent(p.getMemoryOperation().name()));
        element.addContent((Content)new Element("otherConstant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("otherTableCell").addContent(p.getOtherTableCell()));
        element.addContent((Content)new Element("otherVariable").addContent(p.getOtherLocalVariable()));
        element.addContent((Content)new Element("otherFormula").addContent(p.getOtherFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element elemAddressing;
        Element queryType;
        Element otherMemoryName;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionMemory h = new ActionMemory(sys, uname);
        this.loadCommon(h, shared);
        Element memoryName = shared.getChild("memory");
        if (memoryName != null) {
            Memory t = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
            if (t != null) {
                h.setMemory(t);
            } else {
                h.removeMemory();
            }
        }
        if ((otherMemoryName = shared.getChild("otherMemory")) != null) {
            Memory t = InstanceManager.getDefault(MemoryManager.class).getMemory(otherMemoryName.getTextTrim());
            if (t != null) {
                h.setOtherMemory(t);
            } else {
                h.removeOtherMemory();
            }
        }
        if ((queryType = shared.getChild("memoryOperation")) != null) {
            try {
                h.setMemoryOperation(ActionMemory.MemoryOperation.valueOf(queryType.getTextTrim()));
            }
            catch (ParserException e) {
                log.error("cannot set memory operation: " + queryType.getTextTrim(), (Throwable)e);
            }
        }
        if ((elemAddressing = shared.getChild("addressing")) == null) {
            Element formula;
            Element variable;
            Element constant = shared.getChild("constant");
            if (constant != null) {
                h.setOtherConstantValue(constant.getTextTrim());
            }
            if ((variable = shared.getChild("variable")) != null) {
                h.setOtherLocalVariable(variable.getTextTrim());
            }
            if ((formula = shared.getChild("formula")) != null) {
                try {
                    h.setOtherFormula(formula.getTextTrim());
                }
                catch (ParserException e) {
                    log.error("cannot set data: " + formula.getTextTrim(), (Throwable)e);
                }
            }
        } else {
            try {
                h.setAddressing(NamedBeanAddressing.valueOf(elemAddressing.getTextTrim()));
                Element elem = shared.getChild("reference");
                if (elem != null) {
                    h.setReference(elem.getTextTrim());
                }
                if ((elem = shared.getChild("localVariable")) != null) {
                    h.setLocalVariable(elem.getTextTrim());
                }
                if ((elem = shared.getChild("formula")) != null) {
                    h.setFormula(elem.getTextTrim());
                }
                if ((elem = shared.getChild("otherConstant")) != null) {
                    h.setOtherConstantValue(elem.getTextTrim());
                }
                if ((elem = shared.getChild("otherTableCell")) != null) {
                    h.setOtherTableCell(elem.getTextTrim());
                }
                if ((elem = shared.getChild("otherVariable")) != null) {
                    h.setOtherLocalVariable(elem.getTextTrim());
                }
                if ((elem = shared.getChild("otherFormula")) != null) {
                    h.setOtherFormula(elem.getTextTrim());
                }
            }
            catch (ParserException e) {
                throw new JmriConfigureXmlException(e);
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

