/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.ActionLocalVariable;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLocalVariableXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionLocalVariableXml.class);

    @Override
    public Element store(Object o) {
        NamedBeanHandle<Memory> memoryName;
        ActionLocalVariable p = (ActionLocalVariable)o;
        Element element = new Element("ActionLocalVariable");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        String variableName = p.getLocalVariable();
        if (variableName != null) {
            element.addContent((Content)new Element("variable").addContent(variableName));
        }
        if ((memoryName = p.getMemory()) != null) {
            element.addContent((Content)new Element("memory").addContent(memoryName.getName()));
        }
        element.addContent((Content)new Element("variableOperation").addContent(p.getVariableOperation().name()));
        element.addContent((Content)new Element("constant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("otherTableCell").addContent(p.getOtherTableCell()));
        element.addContent((Content)new Element("otherVariable").addContent(p.getOtherLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element formula;
        Element otherVariable;
        Element otherTableCell;
        Element constant;
        Element queryType;
        Element memoryName;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionLocalVariable h = new ActionLocalVariable(sys, uname);
        this.loadCommon(h, shared);
        Element variableName = shared.getChild("variable");
        if (variableName != null) {
            h.setLocalVariable(variableName.getTextTrim());
        }
        if ((memoryName = shared.getChild("memory")) != null) {
            Memory t = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
            if (t != null) {
                h.setMemory(t);
            } else {
                h.removeMemory();
            }
        }
        if ((queryType = shared.getChild("variableOperation")) != null) {
            try {
                h.setVariableOperation(ActionLocalVariable.VariableOperation.valueOf(queryType.getTextTrim()));
            }
            catch (ParserException e) {
                log.error("cannot set variable operation: " + queryType.getTextTrim(), (Throwable)e);
            }
        }
        if ((constant = shared.getChild("constant")) != null) {
            h.setConstantValue(constant.getTextTrim());
        }
        if ((otherTableCell = shared.getChild("otherTableCell")) != null) {
            h.setOtherTableCell(otherTableCell.getTextTrim());
        }
        if ((otherVariable = shared.getChild("otherVariable")) != null) {
            h.setOtherLocalVariable(otherVariable.getTextTrim());
        }
        if ((formula = shared.getChild("formula")) != null) {
            try {
                h.setFormula(formula.getTextTrim());
            }
            catch (ParserException e) {
                log.error("cannot set data: " + formula.getTextTrim(), (Throwable)e);
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

