/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.ActionListenOnBeans;
import jmri.jmrit.logixng.actions.NamedBeanType;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionListenOnBeansXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionListenOnBeansXml.class);

    @Override
    public Element store(Object o) {
        ActionListenOnBeans p = (ActionListenOnBeans)o;
        Element element = new Element("ActionListenOnBeans");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element parameters = new Element("References");
        for (ActionListenOnBeans.NamedBeanReference ref : p.getReferences()) {
            Element elementParameter = new Element("Reference");
            elementParameter.addContent((Content)new Element("name").addContent(ref.getName()));
            elementParameter.addContent((Content)new Element("type").addContent(ref.getType().name()));
            elementParameter.addContent((Content)new Element("all").addContent(ref.getListenOnAllProperties() ? "yes" : "no"));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        element.addContent((Content)new Element("localVariableNamedBean").addContent(p.getLocalVariableNamedBean()));
        element.addContent((Content)new Element("localVariableEvent").addContent(p.getLocalVariableEvent()));
        element.addContent((Content)new Element("localVariableNewValue").addContent(p.getLocalVariableNewValue()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionListenOnBeans h = new ActionListenOnBeans(sys, uname);
        this.loadCommon(h, shared);
        List parameterList = shared.getChild("References").getChildren();
        log.debug("Found " + parameterList.size() + " references");
        for (Element e : parameterList) {
            Element elementName = e.getChild("name");
            NamedBeanType type = null;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = NamedBeanType.valueOf(elementType.getTextTrim());
            }
            if (elementName == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            if (type == null) {
                throw new IllegalArgumentException("Element 'type' does not exists");
            }
            String all = "no";
            if (e.getChild("all") != null) {
                all = e.getChild("all").getValue();
            }
            boolean listenToAll = "yes".equals(all);
            h.addReference(new ActionListenOnBeans.NamedBeanReference(elementName.getTextTrim(), type, listenToAll));
        }
        Element variableName = shared.getChild("localVariableNamedBean");
        if (variableName != null) {
            h.setLocalVariableNamedBean(variableName.getTextTrim());
        }
        if ((variableName = shared.getChild("localVariableEvent")) != null) {
            h.setLocalVariableEvent(variableName.getTextTrim());
        }
        if ((variableName = shared.getChild("localVariableNewValue")) != null) {
            h.setLocalVariableNewValue(variableName.getTextTrim());
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

