/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionLight;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionLightXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ActionLight p = (ActionLight)o;
        Element element = new Element("ActionLight");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Light> light = p.getLight();
        if (light != null) {
            element.addContent((Content)new Element("light").addContent(light.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("stateAddressing").addContent(p.getStateAddressing().name()));
        element.addContent((Content)new Element("lightState").addContent(p.getBeanState().name()));
        element.addContent((Content)new Element("stateReference").addContent(p.getStateReference()));
        element.addContent((Content)new Element("stateLocalVariable").addContent(p.getStateLocalVariable()));
        element.addContent((Content)new Element("stateFormula").addContent(p.getStateFormula()));
        element.addContent((Content)new Element("dataAddressing").addContent(p.getDataAddressing().name()));
        element.addContent((Content)new Element("dataReference").addContent(p.getDataReference()));
        element.addContent((Content)new Element("dataLocalVariable").addContent(p.getDataLocalVariable()));
        element.addContent((Content)new Element("dataFormula").addContent(p.getDataFormula()));
        if (p.getLightValue() > 0) {
            element.addContent((Content)new Element("lightValue").addContent(Integer.toString(p.getLightValue())));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionLight h = new ActionLight(sys, uname);
        this.loadCommon(h, shared);
        Element lightName = shared.getChild("light");
        if (lightName != null) {
            Light t = InstanceManager.getDefault(LightManager.class).getLight(lightName.getTextTrim());
            if (t != null) {
                h.setLight(t);
            } else {
                h.removeLight();
            }
        }
        try {
            Element lightState;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateAddressing")) != null) {
                h.setStateAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((lightState = shared.getChild("lightState")) != null) {
                h.setBeanState(ActionLight.LightState.valueOf(lightState.getTextTrim()));
            }
            if ((elem = shared.getChild("stateReference")) != null) {
                h.setStateReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateLocalVariable")) != null) {
                h.setStateLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateFormula")) != null) {
                h.setStateFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataAddressing")) != null) {
                h.setDataAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataReference")) != null) {
                h.setDataReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataLocalVariable")) != null) {
                h.setDataLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataFormula")) != null) {
                h.setDataFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("lightValue")) != null) {
                try {
                    h.setLightValue(Integer.parseInt(elem.getTextTrim()));
                }
                catch (NumberFormatException numberFormatException) {
                    h.setLightValue(0);
                }
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

