/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.awt.GraphicsEnvironment;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionBlock;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionBlockXml
extends AbstractNamedBeanManagerConfigXML {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.logixng.actions.ActionBundle");

    @Override
    public Element store(Object o) {
        ActionBlock p = (ActionBlock)o;
        Element element = new Element("ActionBlock");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Block> block = p.getBlock();
        if (block != null) {
            element.addContent((Content)new Element("block").addContent(block.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("operationAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("operationDirect").addContent(p.getOperationDirect().name()));
        element.addContent((Content)new Element("operationReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("operationLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("operationFormula").addContent(p.getOperationFormula()));
        element.addContent((Content)new Element("dataAddressing").addContent(p.getDataAddressing().name()));
        element.addContent((Content)new Element("dataReference").addContent(p.getDataReference()));
        element.addContent((Content)new Element("dataLocalVariable").addContent(p.getDataLocalVariable()));
        element.addContent((Content)new Element("dataFormula").addContent(p.getDataFormula()));
        element.addContent((Content)new Element("blockValue").addContent(p.getBlockValue()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionBlock h = new ActionBlock(sys, uname);
        this.loadCommon(h, shared);
        Element blockName = shared.getChild("block");
        if (blockName != null) {
            Block t = (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(blockName.getTextTrim());
            if (t != null) {
                h.setBlock(t);
            } else {
                h.removeBlock();
            }
        }
        try {
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationAddressing")) != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("operationDirect")) != null) {
                String oper = elem.getTextTrim();
                if (oper.equals("SetToConstant") || oper.equals("CopyFromMemory") || oper.equals("CopyToMemory")) {
                    oper = "SetValue";
                }
                h.setOperationDirect(ActionBlock.DirectOperation.valueOf(oper));
            }
            if ((elem = shared.getChild("operationReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("operationFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataAddressing")) != null) {
                h.setDataAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("dataReference")) != null) {
                h.setDataReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataLocalVariable")) != null) {
                h.setDataLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("dataFormula")) != null) {
                h.setDataFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockValue")) != null) {
                h.setBlockValue(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockConstant")) != null) {
                h.setBlockValue(elem.getTextTrim());
            }
            if ((elem = shared.getChild("blockMemory")) != null) {
                String memoryName = elem.getTextTrim();
                h.setBlockValue(">>> " + elem.getTextTrim() + " <<<");
                if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                    JOptionPane.showMessageDialog(null, rb.getString("ActionBlock_MemoryChange"), String.valueOf(rb.getString("ActionBlock_MemoryTitle")) + " " + memoryName, 2);
                }
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

