/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionAudio;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class ActionAudioXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        ActionAudio p = (ActionAudio)o;
        Element element = new Element("ActionAudio");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        NamedBeanHandle<Audio> audio = p.getAudio();
        if (audio != null) {
            element.addContent((Content)new Element("audio").addContent(audio.getName()));
        }
        element.addContent((Content)new Element("addressing").addContent(p.getAddressing().name()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("localVariable").addContent(p.getLocalVariable()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)new Element("stateAddressing").addContent(p.getOperationAddressing().name()));
        element.addContent((Content)new Element("audioState").addContent(p.getOperation().name()));
        element.addContent((Content)new Element("stateReference").addContent(p.getOperationReference()));
        element.addContent((Content)new Element("stateLocalVariable").addContent(p.getOperationLocalVariable()));
        element.addContent((Content)new Element("stateFormula").addContent(p.getOperationFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionAudio h = new ActionAudio(sys, uname);
        this.loadCommon(h, shared);
        Element audioName = shared.getChild("audio");
        if (audioName != null) {
            Audio t = InstanceManager.getDefault(AudioManager.class).getAudio(audioName.getTextTrim());
            if (t != null) {
                h.setAudio(t);
            } else {
                h.removeAudio();
            }
        }
        try {
            Element audioState;
            Element elem = shared.getChild("addressing");
            if (elem != null) {
                h.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild("reference")) != null) {
                h.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("localVariable")) != null) {
                h.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("formula")) != null) {
                h.setFormula(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateAddressing")) != null) {
                h.setOperationAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((audioState = shared.getChild("audioState")) != null) {
                h.setOperation(ActionAudio.Operation.valueOf(audioState.getTextTrim()));
            }
            if ((elem = shared.getChild("stateReference")) != null) {
                h.setOperationReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateLocalVariable")) != null) {
                h.setOperationLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("stateFormula")) != null) {
                h.setOperationFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

