/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TimerUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timeout
extends AbstractDigitalAction
implements FemaleSocketListener {
    private ProtectedTimerTask _timerTask;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private int _delay;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private TimerUnit _unit = TimerUnit.MilliSeconds;
    private String _expressionSocketSystemName;
    private String _actionSocketSystemName;
    private final FemaleDigitalExpressionSocket _expressionSocket;
    private final FemaleDigitalActionSocket _actionSocket;
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private long _timerDelay = 0L;
    private long _timerStart = 0L;
    private static final Logger log = LoggerFactory.getLogger(Timeout.class);

    public Timeout(String sys, String user) {
        super(sys, user);
        this._expressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "E");
        this._actionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Timeout copy = new Timeout(sysName, userName);
        copy.setComment(this.getComment());
        copy.setDelayAddressing(this._stateAddressing);
        copy.setDelay(this._delay);
        copy.setDelayFormula(this._stateFormula);
        copy.setDelayLocalVariable(this._stateLocalVariable);
        copy.setDelayReference(this._stateReference);
        copy.setUnit(this._unit);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private ProtectedTimerTask getNewTimerTask(final ConditionalNG conditionalNG, final SymbolTable symbolTable) throws JmriException {
        final DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(symbolTable);
        return new ProtectedTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    Timeout timeout = Timeout.this;
                    synchronized (timeout) {
                        Timeout.this._timerTask = null;
                        long currentTimerTime = System.currentTimeMillis() - Timeout.this._timerStart;
                        if (currentTimerTime < Timeout.this._timerDelay) {
                            Timeout.this.scheduleTimer(conditionalNG, symbolTable, Timeout.this._timerDelay - currentTimerTime);
                        } else {
                            Timeout.this._internalSocket.conditionalNG = conditionalNG;
                            Timeout.this._internalSocket.newSymbolTable = newSymbolTable;
                            conditionalNG.execute(Timeout.this._internalSocket);
                        }
                    }
                }
                catch (RuntimeException | JmriException e) {
                    log.error("Exception thrown", (Throwable)e);
                }
            }
        };
    }

    private void scheduleTimer(ConditionalNG conditionalNG, SymbolTable symbolTable, long delay) throws JmriException {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
        }
        this._timerTask = this.getNewTimerTask(conditionalNG, symbolTable);
        TimerUtil.schedule((TimerTask)this._timerTask, delay);
    }

    private long getNewDelay() throws JmriException {
        switch (this._stateAddressing) {
            case Direct: {
                return this._delay;
            }
            case Reference: {
                return TypeConversionUtil.convertToLong(ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference));
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToLong(symbolTable.getValue(this._stateLocalVariable));
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToLong(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable())) : 0L;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws JmriException {
        boolean result = this._expressionSocket.evaluate();
        Timeout timeout = this;
        synchronized (timeout) {
            if (result) {
                if (this._timerTask != null) {
                    this._timerTask.stopTimer();
                    this._timerTask = null;
                }
                return;
            }
            if (this._timerTask != null) {
                return;
            }
            this._timerDelay = this.getNewDelay() * this._unit.getMultiply();
            this._timerStart = System.currentTimeMillis();
            ConditionalNG conditonalNG = this.getConditionalNG();
            this.scheduleTimer(conditonalNG, conditonalNG.getSymbolTable(), (long)this._delay * this._unit.getMultiply());
        }
    }

    public void setDelayAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseDelayFormula();
    }

    public NamedBeanAddressing getDelayAddressing() {
        return this._stateAddressing;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        this._delay = delay;
    }

    public void setDelayReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getDelayReference() {
        return this._stateReference;
    }

    public void setDelayLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getDelayLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setDelayFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseDelayFormula();
    }

    public String getDelayFormula() {
        return this._stateFormula;
    }

    private void parseDelayFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public TimerUnit getUnit() {
        return this._unit;
    }

    public void setUnit(TimerUnit unit) {
        this._unit = unit;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._expressionSocket;
            }
            case 1: {
                return this._actionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = null;
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Timeout_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String delay;
        switch (this._stateAddressing) {
            case Direct: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByDirect", this._unit.getTimeWithUnit(this._delay));
                break;
            }
            case Reference: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByReference", this._stateReference, this._unit.toString());
                break;
            }
            case LocalVariable: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByLocalVariable", this._stateLocalVariable, this._unit.toString());
                break;
            }
            case Formula: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByFormula", this._stateFormula, this._unit.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "Timeout_Long", this._expressionSocket.getName(), this._actionSocket.getName(), delay);
    }

    public FemaleDigitalExpressionSocket getExpressionSocket() {
        return this._expressionSocket;
    }

    public String getExpressionSocketSystemName() {
        return this._expressionSocketSystemName;
    }

    public void setExpressionSocketSystemName(String systemName) {
        this._expressionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getActionSocket() {
        return this._actionSocket;
    }

    public String getActionSocketSystemName() {
        return this._actionSocketSystemName;
    }

    public void setActionSocketSystemName(String systemName) {
        this._actionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._expressionSocket.isConnected() || !this._expressionSocket.getConnectedSocket().getSystemName().equals(this._expressionSocketSystemName)) {
                socketSystemName = this._expressionSocketSystemName;
                this._expressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._expressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._expressionSocket.getConnectedSocket().setup();
            }
            if (!this._actionSocket.isConnected() || !this._actionSocket.getConnectedSocket().getSystemName().equals(this._actionSocketSystemName)) {
                socketSystemName = this._actionSocketSystemName;
                this._actionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._actionSocket.disconnect();
                    if (maleSocket != null) {
                        this._actionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action " + socketSystemName);
                    }
                }
            } else {
                this._actionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
            this._timerTask = null;
        }
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (Timeout.this._actionSocket != null) {
                SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                this.conditionalNG.setSymbolTable(this.newSymbolTable);
                Timeout.this._actionSocket.execute();
                this.conditionalNG.setSymbolTable(oldSymbolTable);
            }
        }
    }
}

