/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.Table;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableForEach
extends AbstractDigitalAction
implements FemaleSocketListener,
VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<NamedTable> _tableHandle;
    private String _tableReference = "";
    private String _tableLocalVariable = "";
    private String _tableFormula = "";
    private ExpressionNode _tableExpressionNode;
    private NamedBeanAddressing _rowOrColumnAddressing = NamedBeanAddressing.Direct;
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnName = "";
    private String _rowOrColumnReference = "";
    private String _rowOrColumnLocalVariable = "";
    private String _rowOrColumnFormula = "";
    private ExpressionNode _rowOrColumnExpressionNode;
    private String _variableName = "";
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A1");
    private static final Logger log = LoggerFactory.getLogger(TableForEach.class);

    public TableForEach(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        TableForEach copy = new TableForEach(sysName, userName);
        copy.setComment(this.getComment());
        copy.setAddressing(this._addressing);
        copy.setTable(this._tableHandle);
        copy.setTableReference(this._tableReference);
        copy.setTableLocalVariable(this._tableLocalVariable);
        copy.setTableFormula(this._tableFormula);
        copy.setRowOrColumnAddressing(this._rowOrColumnAddressing);
        copy.setRowOrColumn(this._tableRowOrColumn);
        copy.setRowOrColumnName(this._rowOrColumnName);
        copy.setLocalVariableName(this._variableName);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    private String getNewRowOrColumnName() throws JmriException {
        switch (this._rowOrColumnAddressing) {
            case Direct: {
                return this._rowOrColumnName;
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._rowOrColumnReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._rowOrColumnLocalVariable), false);
            }
            case Formula: {
                return this._rowOrColumnExpressionNode != null ? TypeConversionUtil.convertToString(this._rowOrColumnExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _rowOrColumnAddressing state: " + this._rowOrColumnAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        SymbolTable symbolTable;
        Table table;
        switch (this._addressing) {
            case Direct: {
                table = this._tableHandle != null ? (Table)this._tableHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._tableReference);
                table = (Table)InstanceManager.getDefault(NamedTableManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                symbolTable = this.getConditionalNG().getSymbolTable();
                table = (Table)InstanceManager.getDefault(NamedTableManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._tableLocalVariable), false));
                break;
            }
            case Formula: {
                table = this._tableExpressionNode != null ? (Table)InstanceManager.getDefault(NamedTableManager.class).getNamedBean(TypeConversionUtil.convertToString(this._tableExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (table == null) {
            return;
        }
        String rowOrColumnName = this.getNewRowOrColumnName();
        if (rowOrColumnName == null) {
            log.error("rowOrColumnName is null");
            return;
        }
        if (rowOrColumnName.isEmpty()) {
            log.error("rowOrColumnName is empty string");
            return;
        }
        if (this._variableName == null) {
            log.error("variableName is null");
            return;
        }
        if (!this._socket.isConnected()) {
            log.error("socket is not connected");
            return;
        }
        symbolTable = this.getConditionalNG().getSymbolTable();
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int row = table.getRowNumber(rowOrColumnName);
            int column = 1;
            while (column <= table.numColumns()) {
                Object header = table.getCell(0, column);
                if (header != null && !header.toString().isEmpty()) {
                    symbolTable.setValue(this._variableName, table.getCell(row, column));
                    this._socket.execute();
                }
                ++column;
            }
        } else {
            int column = table.getColumnNumber(rowOrColumnName);
            int row = 1;
            while (row <= table.numRows()) {
                Object header = table.getCell(row, 0);
                if (header != null && !header.toString().isEmpty()) {
                    symbolTable.setValue(this._variableName, table.getCell(row, column));
                    this._socket.execute();
                }
                ++row;
            }
        }
    }

    public void setTable(@Nonnull String tableName) {
        this.assertListenersAreNotRegistered(log, "setTable");
        NamedTable table = InstanceManager.getDefault(NamedTableManager.class).getNamedTable(tableName);
        if (table != null) {
            this.setTable(table);
        } else {
            this.removeTable();
            log.error("turnout \"{}\" is not found", (Object)tableName);
        }
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseTableFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setTable(@Nonnull NamedBeanHandle<NamedTable> handle) {
        this.assertListenersAreNotRegistered(log, "setTable");
        this._tableHandle = handle;
        InstanceManager.getDefault(NamedTableManager.class).addVetoableChangeListener(this);
    }

    public void setTable(@Nonnull NamedTable turnout) {
        this.assertListenersAreNotRegistered(log, "setTable");
        this.setTable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(turnout.getDisplayName(), turnout));
    }

    public void removeTable() {
        this.assertListenersAreNotRegistered(log, "setTable");
        if (this._tableHandle != null) {
            InstanceManager.getDefault(NamedTableManager.class).removeVetoableChangeListener(this);
            this._tableHandle = null;
        }
    }

    public NamedBeanHandle<NamedTable> getTable() {
        return this._tableHandle;
    }

    public void setTableReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._tableReference = reference;
    }

    public String getTableReference() {
        return this._tableReference;
    }

    public void setTableLocalVariable(@Nonnull String localVariable) {
        this._tableLocalVariable = localVariable;
    }

    public String getTableLocalVariable() {
        return this._tableLocalVariable;
    }

    public void setTableFormula(@Nonnull String formula) throws ParserException {
        this._tableFormula = formula;
        this.parseTableFormula();
    }

    public String getTableFormula() {
        return this._tableFormula;
    }

    private void parseTableFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._tableExpressionNode = parser.parseExpression(this._tableFormula);
        } else {
            this._tableExpressionNode = null;
        }
    }

    public TableRowOrColumn getRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public void setRowOrColumnAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._rowOrColumnAddressing = addressing;
        this.parseRowOrColumnFormula();
    }

    public NamedBeanAddressing getRowOrColumnAddressing() {
        return this._rowOrColumnAddressing;
    }

    public String getRowOrColumnName() {
        return this._rowOrColumnName;
    }

    public void setRowOrColumnName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new RuntimeException("Daniel");
        }
        this._rowOrColumnName = rowOrColumnName;
    }

    public void setRowOrColumnReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._rowOrColumnReference = reference;
    }

    public String getRowOrColumnReference() {
        return this._rowOrColumnReference;
    }

    public void setRowOrColumnLocalVariable(@Nonnull String localVariable) {
        this._rowOrColumnLocalVariable = localVariable;
    }

    public String getRowOrColumnLocalVariable() {
        return this._rowOrColumnLocalVariable;
    }

    public void setRowOrColumnFormula(@Nonnull String formula) throws ParserException {
        this._rowOrColumnFormula = formula;
        this.parseRowOrColumnFormula();
    }

    public String getRowOrColumnFormula() {
        return this._rowOrColumnFormula;
    }

    private void parseRowOrColumnFormula() throws ParserException {
        if (this._rowOrColumnAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._rowOrColumnExpressionNode = parser.parseExpression(this._rowOrColumnFormula);
        } else {
            this._rowOrColumnExpressionNode = null;
        }
    }

    public String getLocalVariableName() {
        return this._variableName;
    }

    public void setLocalVariableName(String localVariableName) {
        this._variableName = localVariableName;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
            this.removeTable();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "TableForEach_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String rowOrColumnName;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String tableName = this._tableHandle != null ? this._tableHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", tableName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._tableReference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._tableLocalVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._tableFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._rowOrColumnAddressing) {
            case Direct: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByDirect", this._rowOrColumnName);
                break;
            }
            case Reference: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByReference", this._rowOrColumnReference);
                break;
            }
            case LocalVariable: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByLocalVariable", this._rowOrColumnLocalVariable);
                break;
            }
            case Formula: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByFormula", this._rowOrColumnFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _rowOrColumnAddressing state: " + this._rowOrColumnAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "TableForEach_Long", this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._tableRowOrColumn.toStringLowerCase(), rowOrColumnName, namedBean, this._variableName, this._socket.getName());
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action " + socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

