/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.StringIO;
import jmri.StringIOManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.actions.AbstractStringAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringActionStringIO
extends AbstractStringAction
implements VetoableChangeListener {
    private NamedBeanHandle<StringIO> _stringIOHandle;
    private static final Logger log = LoggerFactory.getLogger(StringActionStringIO.class);

    public StringActionStringIO(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        StringActionManager manager = InstanceManager.getDefault(StringActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        StringActionStringIO copy = new StringActionStringIO(sysName, userName);
        copy.setComment(this.getComment());
        if (this._stringIOHandle != null) {
            copy.setStringIO(this._stringIOHandle);
        }
        return manager.registerAction(copy);
    }

    public void setStringIO(@Nonnull String stringIOName) {
        this.assertListenersAreNotRegistered(log, "setStringIO");
        StringIO stringIO = (StringIO)InstanceManager.getDefault(StringIOManager.class).getNamedBean(stringIOName);
        if (stringIO != null) {
            this.setStringIO(stringIO);
        } else {
            this.removeStringIO();
            log.error("stringIO \"{}\" is not found", (Object)stringIOName);
        }
    }

    public void setStringIO(@Nonnull NamedBeanHandle<StringIO> handle) {
        this.assertListenersAreNotRegistered(log, "setStringIO");
        this._stringIOHandle = handle;
        InstanceManager.getDefault(StringIOManager.class).addVetoableChangeListener(this);
    }

    public void setStringIO(@Nonnull StringIO stringIO) {
        this.assertListenersAreNotRegistered(log, "setStringIO");
        this.setStringIO(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(stringIO.getDisplayName(), stringIO));
    }

    public void removeStringIO() {
        this.assertListenersAreNotRegistered(log, "setStringIO");
        if (this._stringIOHandle != null) {
            InstanceManager.getDefault(StringIOManager.class).removeVetoableChangeListener(this);
            this._stringIOHandle = null;
        }
    }

    public NamedBeanHandle<StringIO> getStringIO() {
        return this._stringIOHandle;
    }

    @Override
    public void setValue(String value) throws JmriException {
        if (this._stringIOHandle != null) {
            this._stringIOHandle.getBean().setCommandedStringValue(value);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof StringIO && evt.getOldValue().equals(this.getStringIO().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("StringStringIO_StringIOInUseStringIOExpressionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof StringIO && evt.getOldValue().equals(this.getStringIO().getBean())) {
            this.removeStringIO();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "StringActionStringIO_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._stringIOHandle != null) {
            return Bundle.getMessage(locale, "StringActionStringIO_Long", this._stringIOHandle.getBean().getDisplayName());
        }
        return Bundle.getMessage(locale, "StringActionStringIO_Long", "none");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: StringActionStringIO: bean = {}, report = {}", (Object)cdl, report);
        if (this.getStringIO() != null && bean.equals(this.getStringIO().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }
}

