/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.actions.AbstractStringAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringActionMemory
extends AbstractStringAction
implements VetoableChangeListener {
    private NamedBeanHandle<Memory> _memoryHandle;
    private static final Logger log = LoggerFactory.getLogger(StringActionMemory.class);

    public StringActionMemory(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        StringActionManager manager = InstanceManager.getDefault(StringActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        StringActionMemory copy = new StringActionMemory(sysName, userName);
        copy.setComment(this.getComment());
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        return manager.registerAction(copy);
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.error("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
    }

    public void setMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "setMemory");
        if (this._memoryHandle != null) {
            InstanceManager.memoryManagerInstance().removeVetoableChangeListener(this);
            this._memoryHandle = null;
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    @Override
    public void setValue(String value) {
        if (this._memoryHandle != null) {
            this._memoryHandle.getBean().setValue(value);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("StringMemory_MemoryInUseMemoryActionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory().getBean())) {
            this.removeMemory();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "StringActionMemory_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._memoryHandle != null) {
            return Bundle.getMessage(locale, "StringActionMemory_Long", this._memoryHandle.getBean().getDisplayName());
        }
        return Bundle.getMessage(locale, "StringActionMemory_Long", "none");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: StringActionMemory: bean = {}, report = {}", (Object)cdl, report);
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }
}

