/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.ShutDownManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownComputer
extends AbstractDigitalAction {
    private Operation _operation = Operation.ShutdownJMRI;
    private static final Logger log = LoggerFactory.getLogger(ShutdownComputer.class);

    public ShutdownComputer(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ShutdownComputer copy = new ShutdownComputer(sysName, userName);
        copy.setComment(this.getComment());
        copy.setOperation(this._operation);
        return manager.registerAction(copy);
    }

    public void setOperation(Operation operation) {
        this._operation = operation;
    }

    public Operation getOperation() {
        return this._operation;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() {
        ThreadingUtil.runOnGUI(() -> {
            switch (this._operation) {
                case ShutdownComputer: {
                    InstanceManager.getDefault(ShutDownManager.class).shutdownOS();
                    break;
                }
                case RebootComputer: {
                    InstanceManager.getDefault(ShutDownManager.class).restartOS();
                    break;
                }
                case ShutdownJMRI: {
                    InstanceManager.getDefault(ShutDownManager.class).shutdown();
                    break;
                }
                case RebootJMRI: {
                    InstanceManager.getDefault(ShutDownManager.class).restart();
                    break;
                }
                default: {
                    throw new RuntimeException("_operation has invalid value: " + this._operation.name());
                }
            }
        });
        log.error("Shutdown failed");
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ShutdownComputer_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ShutdownComputer_Long", this._operation._text);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum Operation {
        ShutdownComputer(Bundle.getMessage("ShutdownComputer_ShutdownComputer")),
        RebootComputer(Bundle.getMessage("ShutdownComputer_RebootComputer")),
        ShutdownJMRI(Bundle.getMessage("ShutdownComputer_ShutdownJMRI")),
        RebootJMRI(Bundle.getMessage("ShutdownComputer_RebootJMRI"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

