/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sequence
extends AbstractDigitalAction
implements FemaleSocketListener {
    public static final int EXPRESSION_START = 0;
    public static final int EXPRESSION_STOP = 1;
    public static final int EXPRESSION_RESET = 2;
    public static final int NUM_STATIC_EXPRESSIONS = 3;
    private String _startExpressionSocketSystemName;
    private String _stopExpressionSocketSystemName;
    private String _resetExpressionSocketSystemName;
    private final FemaleDigitalExpressionSocket _startExpressionSocket;
    private final FemaleDigitalExpressionSocket _stopExpressionSocket;
    private final FemaleDigitalExpressionSocket _resetExpressionSocket;
    private final List<ExpressionEntry> _expressionEntries = new ArrayList<ExpressionEntry>();
    private final List<ActionEntry> _actionEntries = new ArrayList<ActionEntry>();
    private int _currentStep = -1;
    private boolean _isRunning = false;
    private boolean _startImmediately = false;
    private boolean _runContinuously = false;
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(Sequence.class);

    public Sequence(String sys, String user) {
        super(sys, user);
        this._startExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketStart"));
        this._stopExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketStop"));
        this._resetExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketReset"));
        this._actionEntries.add(new ActionEntry(InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, this.getNewActionSocketName())));
        this._expressionEntries.add(new ExpressionEntry(InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewExpressionSocketName())));
    }

    public Sequence(String sys, String user, List<Map.Entry<String, String>> expressionSystemNames, List<Map.Entry<String, String>> actionSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._startExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketStart"));
        this._stopExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketStop"));
        this._resetExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("SequenceSocketReset"));
        this.setExpressionSystemNames(expressionSystemNames);
        this.setActionSystemNames(actionSystemNames);
    }

    public String getNewActionSocketName() {
        String[] names = new String[this.getChildCount()];
        int i = 0;
        while (i < this.getChildCount()) {
            names[i] = this.getChild(i).getName();
            ++i;
        }
        return this.getNewSocketName(names);
    }

    public String getNewExpressionSocketName() {
        String[] names = new String[this.getChildCount()];
        int i = 0;
        while (i < this.getChildCount()) {
            names[i] = this.getChild(i).getName();
            ++i;
        }
        return AbstractDigitalExpression.getNewSocketName(names);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Sequence copy = new Sequence(sysName, userName);
        copy.setComment(this.getComment());
        copy.setStartImmediately(this._startImmediately);
        copy.setRunContinuously(this._runContinuously);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setExpressionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._expressionEntries.isEmpty()) {
            throw new RuntimeException("expression system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._expressionEntries.add(new ExpressionEntry(socket, entry.getValue()));
        }
    }

    private void setActionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._actionEntries.isEmpty()) {
            throw new RuntimeException("action system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalActionSocket socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._actionEntries.add(new ActionEntry(socket, entry.getValue()));
        }
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void execute() throws JmriException {
        FemaleDigitalExpressionSocket exprSocket;
        if (this._stopExpressionSocket.isConnected() && this._stopExpressionSocket.evaluate()) {
            this._isRunning = false;
            return;
        }
        if (this._startExpressionSocket.isConnected() && this._startExpressionSocket.evaluate()) {
            this._isRunning = true;
        }
        if (this._resetExpressionSocket.isConnected() && this._resetExpressionSocket.evaluate()) {
            this._currentStep = -1;
        }
        if (!this._isRunning) {
            return;
        }
        if (this._currentStep == -1) {
            this._currentStep = 0;
            FemaleDigitalActionSocket socket = this._actionEntries.get(this._currentStep)._socket;
            if (socket.isConnected()) {
                socket.execute();
            }
        }
        if ((exprSocket = this._expressionEntries.get(this._currentStep)._socket).isConnected() && exprSocket.evaluate()) {
            ++this._currentStep;
            if (this._currentStep >= this._actionEntries.size()) {
                this._currentStep = 0;
            }
            FemaleDigitalActionSocket actionSocket = this._actionEntries.get(this._currentStep)._socket;
            if (exprSocket.isConnected()) {
                actionSocket.execute();
            }
        }
    }

    public boolean getStartImmediately() {
        return this._startImmediately;
    }

    public void setStartImmediately(boolean startImmediately) {
        this._startImmediately = startImmediately;
        if (this._startImmediately) {
            this._isRunning = true;
        }
    }

    public boolean getRunContinuously() {
        return this._runContinuously;
    }

    public void setRunContinuously(boolean runContinuously) {
        this._runContinuously = runContinuously;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index == 0) {
            return this._startExpressionSocket;
        }
        if (index == 1) {
            return this._stopExpressionSocket;
        }
        if (index == 2) {
            return this._resetExpressionSocket;
        }
        if ((index -= 3) % 2 == 0) {
            return this._actionEntries.get(index >> 1)._socket;
        }
        return this._expressionEntries.get(index >> 1)._socket;
    }

    @Override
    public int getChildCount() {
        return 3 + this._expressionEntries.size() + this._actionEntries.size();
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        index -= 3;
        switch (oper) {
            case Remove: {
                return index >= 0 && index + 1 < this.getChildCount() && !this.getChild(index).isConnected() && !this.getChild(index + 1).isConnected();
            }
            case InsertBefore: {
                return index >= 0;
            }
            case InsertAfter: {
                return index >= -1;
            }
            case MoveUp: {
                return index >= 2;
            }
            case MoveDown: {
                return index >= 0 && index < this.getChildCount();
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        int actionIndex = index >> 1;
        int expressionIndex = index >> 1;
        if (index % 2 != 0) {
            expressionIndex = index >> 1;
            actionIndex = (index >> 1) + 1;
        }
        FemaleDigitalActionSocket actionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, this.getNewActionSocketName());
        this._actionEntries.add(actionIndex, new ActionEntry(actionSocket));
        FemaleDigitalExpressionSocket exprSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewExpressionSocketName());
        this._expressionEntries.add(expressionIndex, new ExpressionEntry(exprSocket));
        ArrayList<FemaleSocket> addList = new ArrayList<FemaleSocket>();
        addList.add(actionSocket);
        addList.add(exprSocket);
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        int actionIndex = index >> 1;
        int expressionIndex = index - 3 >> 1;
        ArrayList<FemaleSocket> removeList = new ArrayList<FemaleSocket>();
        removeList.add(this._actionEntries.remove(actionIndex)._socket);
        removeList.add(this._expressionEntries.remove(expressionIndex)._socket);
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        int actionIndex = index >> 1;
        int expressionIndex = index >> 1;
        if (index % 2 != 0) {
            expressionIndex = index >> 1;
            actionIndex = (index >> 1) + 1;
        }
        ActionEntry actionTemp = this._actionEntries.get(actionIndex);
        this._actionEntries.set(actionIndex, this._actionEntries.get(actionIndex + 1));
        this._actionEntries.set(actionIndex + 1, actionTemp);
        ExpressionEntry exprTemp = this._expressionEntries.get(expressionIndex);
        this._expressionEntries.set(expressionIndex, this._expressionEntries.get(expressionIndex + 1));
        this._expressionEntries.set(expressionIndex + 1, exprTemp);
        ArrayList<FemaleSocket> list = new ArrayList<FemaleSocket>();
        list.add(this._actionEntries.get(actionIndex)._socket);
        list.add(this._actionEntries.get(actionIndex + 1)._socket);
        list.add(this._expressionEntries.get(expressionIndex)._socket);
        list.add(this._expressionEntries.get(expressionIndex + 1)._socket);
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        index -= 3;
        switch (oper) {
            case Remove: {
                if (index + 1 >= this.getChildCount()) {
                    throw new UnsupportedOperationException("Cannot remove only the last socket");
                }
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                if (this.getChild(index + 1).isConnected()) {
                    throw new UnsupportedOperationException("Socket below is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index < 0) {
                    throw new UnsupportedOperationException("cannot move up static sockets");
                }
                if (index <= 1) {
                    throw new UnsupportedOperationException("cannot move up first two children");
                }
                this.moveSocketDown(index - 2);
                break;
            }
            case MoveDown: {
                if (index + 2 >= this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last two children");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        if (socket == this._startExpressionSocket) {
            this._startExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._stopExpressionSocket) {
            this._stopExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._resetExpressionSocket) {
            this._resetExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            for (ExpressionEntry expressionEntry : this._expressionEntries) {
                if (socket != expressionEntry._socket) continue;
                expressionEntry._socketSystemName = socket.getConnectedSocket().getSystemName();
            }
            for (ActionEntry actionEntry : this._actionEntries) {
                if (socket != actionEntry._socket) continue;
                actionEntry._socketSystemName = socket.getConnectedSocket().getSystemName();
            }
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._startExpressionSocket) {
            this._startExpressionSocketSystemName = null;
        } else if (socket == this._stopExpressionSocket) {
            this._stopExpressionSocketSystemName = null;
        } else if (socket == this._resetExpressionSocket) {
            this._resetExpressionSocketSystemName = null;
        } else {
            for (ExpressionEntry expressionEntry : this._expressionEntries) {
                if (socket != expressionEntry._socket) continue;
                expressionEntry._socketSystemName = null;
            }
            for (ActionEntry actionEntry : this._actionEntries) {
                if (socket != actionEntry._socket) continue;
                actionEntry._socketSystemName = null;
            }
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Sequence_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Sequence_Long");
    }

    public FemaleDigitalExpressionSocket getStartExpressionSocket() {
        return this._startExpressionSocket;
    }

    public String getStartExpressionSocketSystemName() {
        return this._startExpressionSocketSystemName;
    }

    public void setStartExpressionSocketSystemName(String systemName) {
        this._startExpressionSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getStopExpressionSocket() {
        return this._stopExpressionSocket;
    }

    public String getStopExpressionSocketSystemName() {
        return this._stopExpressionSocketSystemName;
    }

    public void setStopExpressionSocketSystemName(String systemName) {
        this._stopExpressionSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getResetExpressionSocket() {
        return this._resetExpressionSocket;
    }

    public String getResetExpressionSocketSystemName() {
        return this._resetExpressionSocketSystemName;
    }

    public void setResetExpressionSocketSystemName(String systemName) {
        this._resetExpressionSocketSystemName = systemName;
    }

    public int getNumExpressions() {
        return this._expressionEntries.size();
    }

    public FemaleDigitalExpressionSocket getExpressionSocket(int socket) {
        return this._expressionEntries.get(socket)._socket;
    }

    public String getExpressionSocketSystemName(int socket) {
        return this._expressionEntries.get(socket)._socketSystemName;
    }

    public void setExpressionSocketSystemName(int socket, String systemName) {
        this._expressionEntries.get(socket)._socketSystemName = systemName;
    }

    public int getNumActions() {
        return this._actionEntries.size();
    }

    public FemaleDigitalActionSocket getActionSocket(int socket) {
        return this._actionEntries.get(socket)._socket;
    }

    public String getActionSocketSystemName(int socket) {
        return this._actionEntries.get(socket)._socketSystemName;
    }

    public void setActionSocketSystemName(int socket, String systemName) {
        this._actionEntries.get(socket)._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            MaleSocket maleSocket2;
            String socketSystemName2;
            if (!this._startExpressionSocket.isConnected() || !this._startExpressionSocket.getConnectedSocket().getSystemName().equals(this._startExpressionSocketSystemName)) {
                socketSystemName2 = this._startExpressionSocketSystemName;
                this._startExpressionSocket.disconnect();
                if (socketSystemName2 != null) {
                    maleSocket2 = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName2);
                    if (maleSocket2 != null) {
                        this._startExpressionSocket.connect(maleSocket2);
                        maleSocket2.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName2);
                    }
                }
            } else {
                this._startExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._stopExpressionSocket.isConnected() || !this._stopExpressionSocket.getConnectedSocket().getSystemName().equals(this._stopExpressionSocketSystemName)) {
                socketSystemName2 = this._stopExpressionSocketSystemName;
                this._stopExpressionSocket.disconnect();
                if (socketSystemName2 != null) {
                    maleSocket2 = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName2);
                    this._stopExpressionSocket.disconnect();
                    if (maleSocket2 != null) {
                        this._stopExpressionSocket.connect(maleSocket2);
                        maleSocket2.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName2);
                    }
                }
            } else {
                this._stopExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._resetExpressionSocket.isConnected() || !this._resetExpressionSocket.getConnectedSocket().getSystemName().equals(this._resetExpressionSocketSystemName)) {
                socketSystemName2 = this._resetExpressionSocketSystemName;
                this._resetExpressionSocket.disconnect();
                if (socketSystemName2 != null) {
                    maleSocket2 = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName2);
                    this._resetExpressionSocket.disconnect();
                    if (maleSocket2 != null) {
                        this._resetExpressionSocket.connect(maleSocket2);
                        maleSocket2.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName2);
                    }
                }
            } else {
                this._resetExpressionSocket.getConnectedSocket().setup();
            }
            for (ExpressionEntry ee : this._expressionEntries) {
                if (!ee._socket.isConnected() || !ee._socket.getConnectedSocket().getSystemName().equals(ee._socketSystemName)) {
                    socketSystemName = ee._socketSystemName;
                    ee._socket.disconnect();
                    if (socketSystemName == null) continue;
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    ee._socket.disconnect();
                    if (maleSocket != null) {
                        ee._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital expression " + socketSystemName);
                    continue;
                }
                ee._socket.getConnectedSocket().setup();
            }
            for (ActionEntry ae : this._actionEntries) {
                if (!ae._socket.isConnected() || !ae._socket.getConnectedSocket().getSystemName().equals(ae._socketSystemName)) {
                    socketSystemName = ae._socketSystemName;
                    ae._socket.disconnect();
                    if (socketSystemName == null) continue;
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    ae._socket.disconnect();
                    if (maleSocket != null) {
                        ae._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital action " + socketSystemName);
                    continue;
                }
                ae._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
        this.disableCheckForUnconnectedSocket = false;
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }

    private static class ActionEntry {
        private String _socketSystemName;
        private final FemaleDigitalActionSocket _socket;

        private ActionEntry(FemaleDigitalActionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ActionEntry(FemaleDigitalActionSocket socket) {
            this._socket = socket;
        }
    }

    private static class ExpressionEntry {
        private String _socketSystemName;
        private final FemaleDigitalExpressionSocket _socket;

        private ExpressionEntry(FemaleDigitalExpressionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ExpressionEntry(FemaleDigitalExpressionSocket socket) {
            this._socket = socket;
        }
    }
}

