/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfThenElse
extends AbstractDigitalAction
implements FemaleSocketListener {
    private Type _type = Type.ExecuteOnChange;
    private TriState _lastExpressionResult = TriState.Unknown;
    private String _ifExpressionSocketSystemName;
    private String _thenActionSocketSystemName;
    private String _elseActionSocketSystemName;
    private final FemaleDigitalExpressionSocket _ifExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "If");
    private final FemaleDigitalActionSocket _thenActionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "Then");
    private final FemaleDigitalActionSocket _elseActionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "Else");
    private static final Logger log = LoggerFactory.getLogger(IfThenElse.class);

    public IfThenElse(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        IfThenElse copy = new IfThenElse(sysName, userName);
        copy.setComment(this.getComment());
        copy.setType(this._type);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void execute() throws JmriException {
        boolean result = this._ifExpressionSocket.evaluate();
        TriState _expressionResult = TriState.getValue(result);
        if (this._type == Type.AlwaysExecute || _expressionResult != this._lastExpressionResult) {
            if (result) {
                this._thenActionSocket.execute();
            } else {
                this._elseActionSocket.execute();
            }
            this._lastExpressionResult = _expressionResult;
        }
    }

    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._ifExpressionSocket;
            }
            case 1: {
                return this._thenActionSocket;
            }
            case 2: {
                return this._elseActionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 3;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._ifExpressionSocket) {
            this._ifExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._thenActionSocket) {
            this._thenActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._elseActionSocket) {
            this._elseActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._ifExpressionSocket) {
            this._ifExpressionSocketSystemName = null;
        } else if (socket == this._thenActionSocket) {
            this._thenActionSocketSystemName = null;
        } else if (socket == this._elseActionSocket) {
            this._elseActionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "IfThenElse_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "IfThenElse_Long", this._type.toString());
    }

    public FemaleDigitalExpressionSocket getIfExpressionSocket() {
        return this._ifExpressionSocket;
    }

    public String getIfExpressionSocketSystemName() {
        return this._ifExpressionSocketSystemName;
    }

    public void setIfExpressionSocketSystemName(String systemName) {
        this._ifExpressionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getThenActionSocket() {
        return this._thenActionSocket;
    }

    public String getThenActionSocketSystemName() {
        return this._thenActionSocketSystemName;
    }

    public void setThenActionSocketSystemName(String systemName) {
        this._thenActionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getElseActionSocket() {
        return this._elseActionSocket;
    }

    public String getElseActionSocketSystemName() {
        return this._elseActionSocketSystemName;
    }

    public void setElseActionSocketSystemName(String systemName) {
        this._elseActionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._ifExpressionSocket.isConnected() || !this._ifExpressionSocket.getConnectedSocket().getSystemName().equals(this._ifExpressionSocketSystemName)) {
                socketSystemName = this._ifExpressionSocketSystemName;
                this._ifExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._ifExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._ifExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._thenActionSocket.isConnected() || !this._thenActionSocket.getConnectedSocket().getSystemName().equals(this._thenActionSocketSystemName)) {
                socketSystemName = this._thenActionSocketSystemName;
                this._thenActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._thenActionSocket.disconnect();
                    if (maleSocket != null) {
                        this._thenActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action " + socketSystemName);
                    }
                }
            } else {
                this._thenActionSocket.getConnectedSocket().setup();
            }
            if (!this._elseActionSocket.isConnected() || !this._elseActionSocket.getConnectedSocket().getSystemName().equals(this._elseActionSocketSystemName)) {
                socketSystemName = this._elseActionSocketSystemName;
                this._elseActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._elseActionSocket.disconnect();
                    if (maleSocket != null) {
                        this._elseActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action " + socketSystemName);
                    }
                }
            } else {
                this._elseActionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    private static enum TriState {
        Unknown,
        False,
        True;


        public static TriState getValue(boolean value) {
            return value ? True : False;
        }
    }

    public static enum Type {
        ExecuteOnChange(Bundle.getMessage("IfThenElse_ExecuteOnChange")),
        AlwaysExecute(Bundle.getMessage("IfThenElse_AlwaysExecute"));

        private final String _text;

        private Type(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

