/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TimerUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteDelayed
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket;
    private ProtectedTimerTask _timerTask;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private int _delay;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private TimerUnit _unit = TimerUnit.MilliSeconds;
    private boolean _resetIfAlreadyStarted;
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    protected final List<SymbolTable.VariableData> _localVariables = new ArrayList<SymbolTable.VariableData>();
    private long _timerDelay = 0L;
    private long _timerStart = 0L;
    private static final Logger log = LoggerFactory.getLogger(ExecuteDelayed.class);

    public ExecuteDelayed(String sys, String user) {
        super(sys, user);
        this._socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExecuteDelayed copy = new ExecuteDelayed(sysName, userName);
        copy.setComment(this.getComment());
        copy.setDelayAddressing(this._stateAddressing);
        copy.setDelay(this._delay);
        copy.setDelayFormula(this._stateFormula);
        copy.setDelayLocalVariable(this._stateLocalVariable);
        copy.setDelayReference(this._stateReference);
        copy.setUnit(this._unit);
        copy.setResetIfAlreadyStarted(this._resetIfAlreadyStarted);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    private ProtectedTimerTask getNewTimerTask(final ConditionalNG conditionalNG, final SymbolTable symbolTable) throws JmriException {
        final DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(symbolTable);
        return new ProtectedTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    ExecuteDelayed executeDelayed = ExecuteDelayed.this;
                    synchronized (executeDelayed) {
                        ExecuteDelayed.this._timerTask = null;
                        long currentTimerTime = System.currentTimeMillis() - ExecuteDelayed.this._timerStart;
                        if (currentTimerTime < ExecuteDelayed.this._timerDelay) {
                            ExecuteDelayed.this.scheduleTimer(conditionalNG, symbolTable, ExecuteDelayed.this._timerDelay - currentTimerTime);
                        } else {
                            ExecuteDelayed.this._internalSocket.conditionalNG = conditionalNG;
                            ExecuteDelayed.this._internalSocket.newSymbolTable = newSymbolTable;
                            conditionalNG.execute(ExecuteDelayed.this._internalSocket);
                        }
                    }
                }
                catch (RuntimeException | JmriException e) {
                    log.error("Exception thrown", (Throwable)e);
                }
            }
        };
    }

    private void scheduleTimer(ConditionalNG conditionalNG, SymbolTable symbolTable, long delay) throws JmriException {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
        }
        this._timerTask = this.getNewTimerTask(conditionalNG, symbolTable);
        TimerUtil.schedule((TimerTask)this._timerTask, delay);
    }

    private long getNewDelay() throws JmriException {
        switch (this._stateAddressing) {
            case Direct: {
                return this._delay;
            }
            case Reference: {
                return TypeConversionUtil.convertToLong(ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference));
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToLong(symbolTable.getValue(this._stateLocalVariable));
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToLong(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable())) : 0L;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws JmriException {
        ExecuteDelayed executeDelayed = this;
        synchronized (executeDelayed) {
            if (this._timerTask != null) {
                if (this._resetIfAlreadyStarted) {
                    this._timerTask.stopTimer();
                } else {
                    return;
                }
            }
            this._timerDelay = this.getNewDelay() * this._unit.getMultiply();
            this._timerStart = System.currentTimeMillis();
            ConditionalNG conditonalNG = this.getConditionalNG();
            this.scheduleTimer(conditonalNG, conditonalNG.getSymbolTable(), this._timerDelay);
        }
    }

    public void setDelayAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseDelayFormula();
    }

    public NamedBeanAddressing getDelayAddressing() {
        return this._stateAddressing;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        this._delay = delay;
    }

    public void setDelayReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getDelayReference() {
        return this._stateReference;
    }

    public void setDelayLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getDelayLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setDelayFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseDelayFormula();
    }

    public String getDelayFormula() {
        return this._stateFormula;
    }

    private void parseDelayFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public TimerUnit getUnit() {
        return this._unit;
    }

    public void setUnit(TimerUnit unit) {
        this._unit = unit;
    }

    public boolean getResetIfAlreadyStarted() {
        return this._resetIfAlreadyStarted;
    }

    public void setResetIfAlreadyStarted(boolean resetIfAlreadyStarted) {
        this._resetIfAlreadyStarted = resetIfAlreadyStarted;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ExecuteDelayed_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String delay;
        switch (this._stateAddressing) {
            case Direct: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByDirect", this._unit.getTimeWithUnit(this._delay));
                break;
            }
            case Reference: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByReference", this._stateReference, this._unit.toString());
                break;
            }
            case LocalVariable: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByLocalVariable", this._stateLocalVariable, this._unit.toString());
                break;
            }
            case Formula: {
                delay = Bundle.getMessage(locale, "ExecuteDelayed_DelayByFormula", this._stateFormula, this._unit.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ExecuteDelayed_Long", this._socket.getName(), delay, this._resetIfAlreadyStarted ? Bundle.getMessage("ExecuteDelayed_ResetRepeat") : Bundle.getMessage("ExecuteDelayed_IgnoreRepeat"));
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog action " + socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
            this._timerTask = null;
        }
    }

    @Override
    public void disposeMe() {
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (ExecuteDelayed.this._socket != null) {
                SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                this.conditionalNG.setSymbolTable(this.newSymbolTable);
                ExecuteDelayed.this._socket.execute();
                this.conditionalNG.setSymbolTable(oldSymbolTable);
            }
        }
    }
}

