/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Logix;
import jmri.LogixManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableLogix
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Logix> _logixHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private Operation _operationDirect = Operation.Disable;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(EnableLogix.class);

    public EnableLogix(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        EnableLogix copy = new EnableLogix(sysName, userName);
        copy.setComment(this.getComment());
        if (this._logixHandle != null) {
            copy.setLogix(this._logixHandle);
        }
        copy.setOperationDirect(this._operationDirect);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        return manager.registerAction(copy);
    }

    public void setLogix(@Nonnull String logixName) {
        this.assertListenersAreNotRegistered(log, "setLogix");
        Logix logix = InstanceManager.getDefault(LogixManager.class).getLogix(logixName);
        if (logix != null) {
            this.setLogix(logix);
        } else {
            this.removeLogix();
            log.error("logix \"{}\" is not found", (Object)logixName);
        }
    }

    public void setLogix(@Nonnull NamedBeanHandle<Logix> handle) {
        this.assertListenersAreNotRegistered(log, "setLogix");
        this._logixHandle = handle;
        InstanceManager.getDefault(LogixManager.class).addVetoableChangeListener(this);
    }

    public void setLogix(@Nonnull Logix logix) {
        this.assertListenersAreNotRegistered(log, "setLogix");
        this.setLogix(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(logix.getDisplayName(), logix));
    }

    public void removeLogix() {
        this.assertListenersAreNotRegistered(log, "removeLogix");
        if (this._logixHandle != null) {
            InstanceManager.getDefault(LogixManager.class).removeVetoableChangeListener(this);
            this._logixHandle = null;
        }
    }

    public NamedBeanHandle<Logix> getLogix() {
        return this._logixHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseLockFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationDirect(Operation state) {
        this._operationDirect = state;
    }

    public Operation getOperationDirect() {
        return this._operationDirect;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseLockFormula();
    }

    public String getLockFormula() {
        return this._operationFormula;
    }

    private void parseLockFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Logix && evt.getOldValue().equals(this.getLogix().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("EnableLogix_LogixInUseVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Logix && evt.getOldValue().equals(this.getLogix().getBean())) {
            this.removeLogix();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewLock() throws JmriException {
        switch (this._operationAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Logix logix;
        switch (this._addressing) {
            case Direct: {
                logix = this._logixHandle != null ? this._logixHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                logix = (Logix)InstanceManager.getDefault(LogixManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                logix = (Logix)InstanceManager.getDefault(LogixManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                logix = this._expressionNode != null ? (Logix)InstanceManager.getDefault(LogixManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (logix == null) {
            return;
        }
        String name = this._operationAddressing != NamedBeanAddressing.Direct ? this.getNewLock() : null;
        Operation lock = this._operationAddressing == NamedBeanAddressing.Direct ? this._operationDirect : Operation.valueOf(name);
        Operation theLock = lock;
        ThreadingUtil.runOnLayoutWithJmriException(() -> logix.setEnabled(theLock == Operation.Enable));
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "EnableLogix_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String logixName = this._logixHandle != null ? this._logixHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", logixName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._operationDirect._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._operationAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "EnableLogix_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum Operation {
        Enable(Bundle.getMessage("EnableLogix_Enable")),
        Disable(Bundle.getMessage("EnableLogix_Disable"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

