/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.AnalogActionManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleAnalogActionSocket;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoAnalogAction
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _analogExpressionSocketSystemName;
    private String _analogActionSocketSystemName;
    private final FemaleAnalogExpressionSocket _analogExpressionSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, "E");
    private final FemaleAnalogActionSocket _analogActionSocket = InstanceManager.getDefault(AnalogActionManager.class).createFemaleSocket(this, this, "A");
    private static final Logger log = LoggerFactory.getLogger(DoAnalogAction.class);

    public DoAnalogAction(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        DoAnalogAction copy = new DoAnalogAction(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void execute() throws JmriException {
        double result = this._analogExpressionSocket.evaluate();
        this._analogActionSocket.setValue(result);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._analogExpressionSocket;
            }
            case 1: {
                return this._analogActionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._analogExpressionSocket) {
            this._analogExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._analogActionSocket) {
            this._analogActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._analogExpressionSocket) {
            this._analogExpressionSocketSystemName = null;
        } else if (socket == this._analogActionSocket) {
            this._analogActionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DoAnalogAction_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "DoAnalogAction_Long", this._analogExpressionSocket.getName(), this._analogActionSocket.getName());
    }

    public FemaleAnalogActionSocket getAnalogActionSocket() {
        return this._analogActionSocket;
    }

    public String getAnalogActionSocketSystemName() {
        return this._analogActionSocketSystemName;
    }

    public void setAnalogActionSocketSystemName(String systemName) {
        this._analogActionSocketSystemName = systemName;
    }

    public FemaleAnalogExpressionSocket getAnalogExpressionSocket() {
        return this._analogExpressionSocket;
    }

    public String getAnalogExpressionSocketSystemName() {
        return this._analogExpressionSocketSystemName;
    }

    public void setAnalogExpressionSocketSystemName(String systemName) {
        this._analogExpressionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._analogExpressionSocket.isConnected() || !this._analogExpressionSocket.getConnectedSocket().getSystemName().equals(this._analogExpressionSocketSystemName)) {
                socketSystemName = this._analogExpressionSocketSystemName;
                this._analogExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._analogExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression " + socketSystemName);
                    }
                }
            } else {
                this._analogExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._analogActionSocket.isConnected() || !this._analogActionSocket.getConnectedSocket().getSystemName().equals(this._analogActionSocketSystemName)) {
                socketSystemName = this._analogActionSocketSystemName;
                this._analogActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._analogActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog action " + socketSystemName);
                    }
                }
            } else {
                this._analogActionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

