/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.VariableLight;
import jmri.VariableLightManager;
import jmri.jmrit.logixng.AnalogActionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractAnalogAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogActionLightIntensity
extends AbstractAnalogAction
implements VetoableChangeListener {
    public static final int INTENSITY_SOCKET = 0;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<VariableLight> _lightHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private static final Logger log = LoggerFactory.getLogger(AnalogActionLightIntensity.class);

    public AnalogActionLightIntensity(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogActionManager manager = InstanceManager.getDefault(AnalogActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogActionLightIntensity copy = new AnalogActionLightIntensity(sysName, userName);
        copy.setComment(this.getComment());
        if (this._lightHandle != null) {
            copy.setLight(this._lightHandle);
        }
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setLight(@Nonnull String lightName) {
        this.assertListenersAreNotRegistered(log, "setLight");
        VariableLight light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(lightName);
        if (light != null) {
            this.setLight(light);
        } else {
            this.removeLight();
            log.warn("light \"{}\" is not found", (Object)lightName);
        }
    }

    public void setLight(@Nonnull NamedBeanHandle<VariableLight> handle) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this._lightHandle = handle;
        InstanceManager.lightManagerInstance().addVetoableChangeListener(this);
    }

    public void setLight(@Nonnull VariableLight light) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this.setLight(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(light.getDisplayName(), light));
    }

    public void removeLight() {
        this.assertListenersAreNotRegistered(log, "setLight");
        if (this._lightHandle != null) {
            InstanceManager.lightManagerInstance().removeVetoableChangeListener(this);
            this._lightHandle = null;
        }
    }

    public NamedBeanHandle<VariableLight> getLight() {
        return this._lightHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof VariableLight && evt.getOldValue().equals(this.getLight().getBean())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("AnalogActionLightIntensity_LightInUseLightActionVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public void setValue(double value) throws JmriException {
        VariableLight light;
        switch (this._addressing) {
            case Direct: {
                light = this._lightHandle != null ? this._lightHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                light = this._expressionNode != null ? (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (light == null) {
            return;
        }
        double intensity = value;
        if (intensity < 0.0) {
            intensity = 0.0;
        }
        if (intensity > 100.0) {
            intensity = 100.0;
        }
        light.setTargetIntensity(intensity / 100.0);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogActionLightIntensity_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String lightName = this._lightHandle != null ? this._lightHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", lightName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        return Bundle.getMessage(locale, "AnalogActionLightIntensity_Long", namedBean);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

