/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionWarrant
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Warrant> _warrantHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private DirectOperation _operationDirect = DirectOperation.AllocateWarrantRoute;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private String _trainIdName = "";
    private ControlAutoTrain _controlAutoTrain = ControlAutoTrain.Halt;
    private static final Logger log = LoggerFactory.getLogger(ActionWarrant.class);

    public ActionWarrant(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionWarrant copy = new ActionWarrant(sysName, userName);
        copy.setComment(this.getComment());
        copy.setAddressing(this._addressing);
        if (this._warrantHandle != null) {
            copy.setWarrant(this._warrantHandle);
        }
        copy.setReference(this._reference);
        copy.setLocalVariable(this._localVariable);
        copy.setFormula(this._formula);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationDirect(this._operationDirect);
        copy.setOperationReference(this._operationReference);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationFormula(this._operationFormula);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setTrainIdName(this._trainIdName);
        copy.setControlAutoTrain(this._controlAutoTrain);
        return manager.registerAction(copy);
    }

    public void setWarrant(@Nonnull String warrantName) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        Warrant warrant = (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(warrantName);
        if (warrant != null) {
            this.setWarrant(warrant);
        } else {
            this.removeWarrant();
            log.error("Warrant \"{}\" is not found", (Object)warrantName);
        }
    }

    public void setWarrant(@Nonnull Warrant warrant) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        this.setWarrant(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(warrant.getDisplayName(), warrant));
    }

    public void setWarrant(@Nonnull NamedBeanHandle<Warrant> handle) {
        this.assertListenersAreNotRegistered(log, "setWarrant");
        this._warrantHandle = handle;
        InstanceManager.getDefault(WarrantManager.class).addVetoableChangeListener(this);
    }

    public void removeWarrant() {
        this.assertListenersAreNotRegistered(log, "removeWarrant");
        if (this._warrantHandle != null) {
            InstanceManager.getDefault(WarrantManager.class).removeVetoableChangeListener(this);
            this._warrantHandle = null;
        }
    }

    public NamedBeanHandle<Warrant> getWarrant() {
        return this._warrantHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationDirect(DirectOperation state) {
        this._operationDirect = state;
    }

    public DirectOperation getOperationDirect() {
        return this._operationDirect;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperFormula();
    }

    public String getOperFormula() {
        return this._operationFormula;
    }

    private void parseOperFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setTrainIdName(@Nonnull String trainIdName) {
        this._trainIdName = trainIdName;
    }

    public String getTrainIdName() {
        return this._trainIdName;
    }

    public void setControlAutoTrain(ControlAutoTrain controlAutoTrain) {
        this._controlAutoTrain = controlAutoTrain;
    }

    public ControlAutoTrain getControlAutoTrain() {
        return this._controlAutoTrain;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Warrant && evt.getOldValue().equals(this.getWarrant().getBean())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("ActionWarrant_WarrantInUseVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewOper() throws JmriException {
        switch (this._operationAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    private String getNewData() throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                switch (this._operationDirect) {
                    case SetTrainId: 
                    case SetTrainName: {
                        return this._trainIdName;
                    }
                    case ControlAutoTrain: {
                        return this._controlAutoTrain.name();
                    }
                }
                return "";
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._dataAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Warrant warrant;
        switch (this._addressing) {
            case Direct: {
                warrant = this._warrantHandle != null ? this._warrantHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                warrant = (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                warrant = (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                warrant = this._expressionNode != null ? (Warrant)InstanceManager.getDefault(WarrantManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (warrant == null) {
            return;
        }
        String name = this._operationAddressing != NamedBeanAddressing.Direct ? this.getNewOper() : null;
        DirectOperation oper = this._operationAddressing == NamedBeanAddressing.Direct ? this._operationDirect : DirectOperation.valueOf(name);
        DirectOperation theOper = oper;
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case AllocateWarrantRoute: {
                    String msg = warrant.allocateRoute(false, null);
                    if (msg == null) break;
                    log.warn("Warrant {} - {}", (Object)warrant.getDisplayName(), (Object)msg);
                    break;
                }
                case DeallocateWarrant: {
                    warrant.deAllocate();
                    break;
                }
                case SetRouteTurnouts: {
                    String msg = warrant.setRoute(false, null);
                    if (msg == null) break;
                    log.warn("Warrant {} unable to Set Route - {}", (Object)warrant.getDisplayName(), (Object)msg);
                    break;
                }
                case AutoRunTrain: {
                    WarrantTableFrame frame = WarrantTableFrame.getDefault();
                    String err = frame.runTrain(warrant, 2);
                    if (err == null) break;
                    warrant.stopWarrant(true, true);
                    throw new JmriException("runAutoTrain error - " + err);
                }
                case ManuallyRunTrain: {
                    String err = warrant.setRoute(false, null);
                    if (err == null) {
                        err = warrant.setRunMode(3, null, null, null, false);
                    }
                    if (err == null) break;
                    throw new JmriException("runManualTrain error - " + err);
                }
                case ControlAutoTrain: {
                    int controlAction = 0;
                    switch (this._controlAutoTrain) {
                        case Halt: {
                            controlAction = 1;
                            break;
                        }
                        case Resume: {
                            controlAction = 2;
                            break;
                        }
                        case Abort: {
                            controlAction = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid train control action: " + (Object)((Object)this._controlAutoTrain));
                        }
                    }
                    if (warrant.controlRunTrain(controlAction)) break;
                    log.warn("Train {} not running  - {}", (Object)warrant.getSpeedUtil().getRosterId(), (Object)warrant.getDisplayName());
                    break;
                }
                case SetTrainId: {
                    if (warrant.getSpeedUtil().setAddress(this.getNewData())) break;
                    throw new JmriException("invalid train ID in action - " + warrant.getDisplayName());
                }
                case SetTrainName: {
                    warrant.setTrainName(this.getNewData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionWarrant_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean;
        String state = "";
        switch (this._addressing) {
            case Direct: {
                String warrantName = this._warrantHandle != null ? this._warrantHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", warrantName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                if (this._operationDirect == DirectOperation.SetTrainId) {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Train_Id", namedBean, this._trainIdName);
                }
                if (this._operationDirect == DirectOperation.SetTrainName) {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Train_Name", namedBean, this._trainIdName);
                }
                if (this._operationDirect == DirectOperation.ControlAutoTrain) {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Control", namedBean, this._controlAutoTrain.name());
                }
                state = Bundle.getMessage(locale, "AddressByDirect", this._operationDirect._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._operationAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionWarrant_Long", namedBean, state);
    }

    private String getLongDataDescription(Locale locale, String bundleKey, String namedBean, String value) {
        switch (this._dataAddressing) {
            case Direct: {
                return Bundle.getMessage(locale, bundleKey, namedBean, value);
            }
            case Reference: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByReference", this._dataReference));
            }
            case LocalVariable: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
            }
            case Formula: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByFormula", this._dataFormula));
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionWarrant: bean = {}, report = {}", (Object)cdl, report);
        if (this.getWarrant() != null && bean.equals(this.getWarrant().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum ControlAutoTrain {
        Halt(Bundle.getMessage("ActionWarrant_Halt_AutoTrain")),
        Resume(Bundle.getMessage("ActionWarrant_Resume_AutoTrain")),
        Abort(Bundle.getMessage("ActionWarrant_Abort_AutoTrain"));

        private final String _text;

        private ControlAutoTrain(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum DirectOperation {
        None(""),
        AllocateWarrantRoute(Bundle.getMessage("ActionWarrant_AllocateWarrantRoute")),
        DeallocateWarrant(Bundle.getMessage("ActionWarrant_DeallocateWarrant")),
        SetRouteTurnouts(Bundle.getMessage("ActionWarrant_SetRouteTurnouts")),
        AutoRunTrain(Bundle.getMessage("ActionWarrant_AutoRunTrain")),
        ManuallyRunTrain(Bundle.getMessage("ActionWarrant_ManuallyRunTrain")),
        ControlAutoTrain(Bundle.getMessage("ActionWarrant_ControlAutoTrain")),
        SetTrainId(Bundle.getMessage("ActionWarrant_SetTrainId")),
        SetTrainName(Bundle.getMessage("ActionWarrant_SetTrainName"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

