/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTimer
extends AbstractDigitalAction
implements FemaleSocketListener {
    public static final int EXPRESSION_START = 0;
    public static final int EXPRESSION_STOP = 1;
    public static final int NUM_STATIC_EXPRESSIONS = 2;
    private String _startExpressionSocketSystemName;
    private String _stopExpressionSocketSystemName;
    private final FemaleDigitalExpressionSocket _startExpressionSocket;
    private final FemaleDigitalExpressionSocket _stopExpressionSocket;
    private final List<ActionEntry> _actionEntries = new ArrayList<ActionEntry>();
    private ProtectedTimerTask _timerTask;
    private int _currentTimer = -1;
    private TimerState _timerState = TimerState.Off;
    private boolean _startImmediately = false;
    private boolean _runContinuously = false;
    private TimerUnit _unit = TimerUnit.MilliSeconds;
    private long _currentTimerDelay = 0L;
    private long _currentTimerStart = 0L;
    private boolean _startIsActive = false;
    private static final Logger log = LoggerFactory.getLogger(ActionTimer.class);

    public ActionTimer(String sys, String user) {
        super(sys, user);
        this._startExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionTimerSocketStart"));
        this._stopExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionTimerSocketStop"));
        this._actionEntries.add(new ActionEntry(InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, this.getNewSocketName())));
    }

    public ActionTimer(String sys, String user, List<Map.Entry<String, String>> expressionSystemNames, List<ActionData> actionDataList) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._startExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionTimerSocketStart"));
        this._stopExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionTimerSocketStop"));
        this.setActionData(actionDataList);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionTimer copy = new ActionTimer(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNumActions(this.getNumActions());
        int i = 0;
        while (i < this.getNumActions()) {
            copy.setDelay(i, this.getDelay(i));
            ++i;
        }
        copy.setStartImmediately(this._startImmediately);
        copy.setRunContinuously(this._runContinuously);
        copy.setUnit(this._unit);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setActionData(List<ActionData> actionDataList) {
        if (!this._actionEntries.isEmpty()) {
            throw new RuntimeException("action system names cannot be set more than once");
        }
        for (ActionData data : actionDataList) {
            FemaleDigitalActionSocket socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, data._socketName);
            this._actionEntries.add(new ActionEntry(data._delay, socket, data._socketSystemName));
        }
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    private ProtectedTimerTask getNewTimerTask() {
        return new ProtectedTimerTask(){

            @Override
            public void execute() {
                try {
                    long currentTimerTime = System.currentTimeMillis() - ActionTimer.this._currentTimerStart;
                    if (currentTimerTime < ActionTimer.this._currentTimerDelay) {
                        ActionTimer.this.scheduleTimer(ActionTimer.this._currentTimerDelay - currentTimerTime);
                    } else {
                        ActionTimer.this._timerState = TimerState.Completed;
                        ActionTimer.this.getConditionalNG().execute();
                    }
                }
                catch (Exception e) {
                    log.error("Exception thrown", (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimer(long delay) {
        ActionTimer actionTimer = this;
        synchronized (actionTimer) {
            if (this._timerTask != null) {
                this._timerTask.stopTimer();
                this._timerTask = null;
            }
        }
        this._timerTask = this.getNewTimerTask();
        TimerUtil.schedule((TimerTask)this._timerTask, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        ActionTimer actionTimer = this;
        synchronized (actionTimer) {
            ActionEntry ae = this._actionEntries.get(this._currentTimer);
            this._currentTimerDelay = (long)ae._delay * this._unit.getMultiply();
            this._currentTimerStart = System.currentTimeMillis();
            this._timerState = TimerState.WaitToRun;
            this.scheduleTimer((long)ae._delay * this._unit.getMultiply());
        }
    }

    private boolean start() throws JmriException {
        boolean lastStartIsActive = this._startIsActive;
        boolean bl = this._startIsActive = this._startExpressionSocket.isConnected() && this._startExpressionSocket.evaluate();
        return this._startIsActive && !lastStartIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStart() throws JmriException {
        if (this.start()) {
            this._timerState = TimerState.RunNow;
        }
        if (this._timerState == TimerState.RunNow) {
            ActionTimer actionTimer = this;
            synchronized (actionTimer) {
                if (this._timerTask != null) {
                    this._timerTask.stopTimer();
                    this._timerTask = null;
                }
            }
            this._currentTimer = 0;
            while (this._currentTimer < this._actionEntries.size()) {
                ActionEntry ae = this._actionEntries.get(this._currentTimer);
                if (ae._delay > 0) {
                    this.schedule();
                    return true;
                }
                ++this._currentTimer;
            }
            this._timerState = TimerState.Off;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop() throws JmriException {
        if (this._stopExpressionSocket.isConnected() && this._stopExpressionSocket.evaluate()) {
            ActionTimer actionTimer = this;
            synchronized (actionTimer) {
                if (this._timerTask != null) {
                    this._timerTask.stopTimer();
                }
                this._timerTask = null;
            }
            this._timerState = TimerState.Off;
            return true;
        }
        return false;
    }

    @Override
    public void execute() throws JmriException {
        if (this.stop()) {
            return;
        }
        if (this.checkStart()) {
            return;
        }
        if (this._timerState == TimerState.Off) {
            return;
        }
        if (this._timerState == TimerState.Running) {
            return;
        }
        int startTimer = this._currentTimer;
        while (this._timerState == TimerState.Completed) {
            ActionEntry ae;
            if (this._timerState == TimerState.Completed && this._actionEntries.get(this._currentTimer)._socket.isConnected()) {
                this._actionEntries.get(this._currentTimer)._socket.execute();
            }
            ++this._currentTimer;
            if (this._currentTimer >= this._actionEntries.size()) {
                this._currentTimer = 0;
                if (!this._runContinuously) {
                    this._timerState = TimerState.Off;
                    return;
                }
            }
            if ((ae = this._actionEntries.get(this._currentTimer))._delay > 0) {
                this.schedule();
                return;
            }
            if (startTimer != this._currentTimer) continue;
            this._timerState = TimerState.Off;
        }
    }

    public int getDelay(int actionSocket) {
        return this._actionEntries.get(actionSocket)._delay;
    }

    public void setDelay(int actionSocket, int delay) {
        this._actionEntries.get(actionSocket)._delay = delay;
    }

    public boolean getStartImmediately() {
        return this._startImmediately;
    }

    public void setStartImmediately(boolean startImmediately) {
        this._startImmediately = startImmediately;
    }

    public boolean getRunContinuously() {
        return this._runContinuously;
    }

    public void setRunContinuously(boolean runContinuously) {
        this._runContinuously = runContinuously;
    }

    public TimerUnit getUnit() {
        return this._unit;
    }

    public void setUnit(TimerUnit unit) {
        this._unit = unit;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index == 0) {
            return this._startExpressionSocket;
        }
        if (index == 1) {
            return this._stopExpressionSocket;
        }
        if (index < 0 || index >= 2 + this._actionEntries.size()) {
            throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
        }
        return this._actionEntries.get(index - 2)._socket;
    }

    @Override
    public int getChildCount() {
        return 2 + this._actionEntries.size();
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._startExpressionSocket) {
            this._startExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._stopExpressionSocket) {
            this._stopExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            for (ActionEntry entry : this._actionEntries) {
                if (socket != entry._socket) continue;
                entry._socketSystemName = socket.getConnectedSocket().getSystemName();
            }
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._startExpressionSocket) {
            this._startExpressionSocketSystemName = null;
        } else if (socket == this._stopExpressionSocket) {
            this._stopExpressionSocketSystemName = null;
        } else {
            for (ActionEntry entry : this._actionEntries) {
                if (socket != entry._socket) continue;
                entry._socketSystemName = null;
            }
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionTimer_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionTimer_Long");
    }

    public FemaleDigitalExpressionSocket getStartExpressionSocket() {
        return this._startExpressionSocket;
    }

    public String getStartExpressionSocketSystemName() {
        return this._startExpressionSocketSystemName;
    }

    public void setStartExpressionSocketSystemName(String systemName) {
        this._startExpressionSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getStopExpressionSocket() {
        return this._stopExpressionSocket;
    }

    public String getStopExpressionSocketSystemName() {
        return this._stopExpressionSocketSystemName;
    }

    public void setStopExpressionSocketSystemName(String systemName) {
        this._stopExpressionSocketSystemName = systemName;
    }

    public int getNumActions() {
        return this._actionEntries.size();
    }

    public void setNumActions(int num) {
        ArrayList<FemaleDigitalActionSocket> addList = new ArrayList<FemaleDigitalActionSocket>();
        ArrayList<FemaleDigitalActionSocket> removeList = new ArrayList<FemaleDigitalActionSocket>();
        while (this._actionEntries.size() > num) {
            ActionEntry ae = this._actionEntries.get(num);
            if (ae._socket.isConnected()) {
                throw new IllegalArgumentException("Cannot remove sockets that are connected");
            }
            removeList.add(this._actionEntries.get(this._actionEntries.size() - 1)._socket);
            this._actionEntries.remove(this._actionEntries.size() - 1);
        }
        while (this._actionEntries.size() < num) {
            FemaleDigitalActionSocket socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._actionEntries.add(new ActionEntry(socket));
            addList.add(socket);
        }
        this.firePropertyChange("ChildCount", removeList, addList);
    }

    public FemaleDigitalActionSocket getActionSocket(int socket) {
        return this._actionEntries.get(socket)._socket;
    }

    public String getActionSocketSystemName(int socket) {
        return this._actionEntries.get(socket)._socketSystemName;
    }

    public void setActionSocketSystemName(int socket, String systemName) {
        this._actionEntries.get(socket)._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._startExpressionSocket.isConnected() || !this._startExpressionSocket.getConnectedSocket().getSystemName().equals(this._startExpressionSocketSystemName)) {
                socketSystemName = this._startExpressionSocketSystemName;
                this._startExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._startExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._startExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._stopExpressionSocket.isConnected() || !this._stopExpressionSocket.getConnectedSocket().getSystemName().equals(this._stopExpressionSocketSystemName)) {
                socketSystemName = this._stopExpressionSocketSystemName;
                this._stopExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._stopExpressionSocket.disconnect();
                    if (maleSocket != null) {
                        this._stopExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._stopExpressionSocket.getConnectedSocket().setup();
            }
            for (ActionEntry ae : this._actionEntries) {
                if (!ae._socket.isConnected() || !ae._socket.getConnectedSocket().getSystemName().equals(ae._socketSystemName)) {
                    String socketSystemName2 = ae._socketSystemName;
                    ae._socket.disconnect();
                    if (socketSystemName2 == null) continue;
                    MaleSocket maleSocket2 = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName2);
                    ae._socket.disconnect();
                    if (maleSocket2 != null) {
                        ae._socket.connect(maleSocket2);
                        maleSocket2.setup();
                        continue;
                    }
                    log.error("cannot load digital action " + socketSystemName2);
                    continue;
                }
                ae._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            if (this._startImmediately || this._timerState != TimerState.Off) {
                if (this._timerState == TimerState.Off) {
                    this._timerState = TimerState.RunNow;
                }
                this.getConditionalNG().execute();
            }
            this._listenersAreRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListenersForThisClass() {
        ActionTimer actionTimer = this;
        synchronized (actionTimer) {
            if (this._timerTask != null) {
                this._timerTask.stopTimer();
            }
            this._timerTask = null;
            this._timerState = TimerState.Off;
        }
        this._listenersAreRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeMe() {
        ActionTimer actionTimer = this;
        synchronized (actionTimer) {
            if (this._timerTask != null) {
                this._timerTask.stopTimer();
            }
            this._timerTask = null;
        }
    }

    public static class ActionData {
        private int _delay;
        private String _socketName;
        private String _socketSystemName;

        public ActionData(int delay, String socketName, String socketSystemName) {
            this._delay = delay;
            this._socketName = socketName;
            this._socketSystemName = socketSystemName;
        }
    }

    private static class ActionEntry {
        private int _delay;
        private String _socketSystemName;
        private final FemaleDigitalActionSocket _socket;

        private ActionEntry(int delay, FemaleDigitalActionSocket socket, String socketSystemName) {
            this._delay = delay;
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ActionEntry(FemaleDigitalActionSocket socket) {
            this._socket = socket;
        }
    }

    private static enum TimerState {
        Off,
        RunNow,
        WaitToRun,
        Running,
        Completed;

    }
}

