/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionThrottle
extends AbstractDigitalAction
implements FemaleSocketListener {
    public static final int LOCO_ADDRESS_SOCKET = 0;
    public static final int LOCO_SPEED_SOCKET = 1;
    public static final int LOCO_DIRECTION_SOCKET = 2;
    private DccThrottle _throttle;
    private ThrottleListener _throttleListener;
    private String _locoAddressSocketSystemName;
    private String _locoSpeedSocketSystemName;
    private String _locoDirectionSocketSystemName;
    private final FemaleAnalogExpressionSocket _locoAddressSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Address"));
    private final FemaleAnalogExpressionSocket _locoSpeedSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Speed"));
    private final FemaleDigitalExpressionSocket _locoDirectionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Direction"));
    boolean _isActive = false;
    private static final Logger log = LoggerFactory.getLogger(ActionThrottle.class);

    public ActionThrottle(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionThrottle copy = new ActionThrottle(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        int currentLocoAddress = -1;
        int newLocoAddress = -1;
        if (this._throttle != null) {
            currentLocoAddress = this._throttle.getLocoAddress().getNumber();
        }
        if (this._locoAddressSocket.isConnected()) {
            newLocoAddress = (int)((MaleAnalogExpressionSocket)this._locoAddressSocket.getConnectedSocket()).evaluate();
        }
        if (newLocoAddress != currentLocoAddress) {
            if (this._throttle != null) {
                this._throttle.setSpeedSetting(0.0f);
                InstanceManager.getDefault(ThrottleManager.class).releaseThrottle(this._throttle, this._throttleListener);
                this._throttle = null;
            }
            if (newLocoAddress != -1) {
                this._throttleListener = new ThrottleListener(){

                    @Override
                    public void notifyThrottleFound(DccThrottle t) {
                        ActionThrottle.this._throttle = t;
                        ActionThrottle.this.executeConditionalNG();
                    }

                    @Override
                    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                        log.warn("loco {} cannot be aquired", (Object)address.getNumber());
                    }

                    @Override
                    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
                        log.warn("Loco {} cannot be aquired. Decision required.", (Object)address.getNumber());
                    }
                };
                boolean result = InstanceManager.getDefault(ThrottleManager.class).requestThrottle(newLocoAddress, this._throttleListener);
                if (!result) {
                    log.warn("loco {} cannot be aquired", (Object)newLocoAddress);
                }
            }
        }
        if (this._throttle != null) {
            double speed = 0.0;
            boolean isForward = true;
            if (this._locoSpeedSocket.isConnected()) {
                speed = ((MaleAnalogExpressionSocket)this._locoSpeedSocket.getConnectedSocket()).evaluate();
            }
            if (this._locoDirectionSocket.isConnected()) {
                isForward = ((MaleDigitalExpressionSocket)this._locoDirectionSocket.getConnectedSocket()).evaluate();
            }
            DccThrottle throttle = this._throttle;
            float spd = (float)speed;
            boolean fwd = isForward;
            ThreadingUtil.runOnLayoutWithJmriException(() -> {
                throttle.setSpeedSetting(spd);
                throttle.setIsForward(fwd);
            });
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._locoAddressSocket;
            }
            case 1: {
                return this._locoSpeedSocket;
            }
            case 2: {
                return this._locoDirectionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 3;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._locoAddressSocket) {
            this._locoAddressSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoSpeedSocket) {
            this._locoSpeedSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoDirectionSocket) {
            this._locoDirectionSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._locoAddressSocket) {
            if (this._throttle != null) {
                this._throttle.setSpeedSetting(0.0f);
                InstanceManager.getDefault(ThrottleManager.class).releaseThrottle(this._throttle, this._throttleListener);
            }
            this._locoAddressSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoSpeedSocket) {
            this._locoSpeedSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoDirectionSocket) {
            this._locoDirectionSocketSystemName = null;
            this.executeConditionalNG();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    private void executeConditionalNG() {
        ConditionalNG c;
        if (this._listenersAreRegistered && (c = this.getConditionalNG()) != null) {
            c.execute();
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionThrottle_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionThrottle_Long", this._locoAddressSocket.getName());
    }

    public FemaleAnalogExpressionSocket getLocoAddressSocket() {
        return this._locoAddressSocket;
    }

    public String getLocoAddressSocketSystemName() {
        return this._locoAddressSocketSystemName;
    }

    public void setLocoAddressSocketSystemName(String systemName) {
        this._locoAddressSocketSystemName = systemName;
    }

    public FemaleAnalogExpressionSocket getLocoSpeedSocket() {
        return this._locoSpeedSocket;
    }

    public String getLocoSpeedSocketSystemName() {
        return this._locoSpeedSocketSystemName;
    }

    public void setLocoSpeedSocketSystemName(String systemName) {
        this._locoSpeedSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getLocoDirectionSocket() {
        return this._locoDirectionSocket;
    }

    public String getLocoDirectionSocketSystemName() {
        return this._locoDirectionSocketSystemName;
    }

    public void setLocoDirectionSocketSystemName(String systemName) {
        this._locoDirectionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._locoAddressSocket.isConnected() || !this._locoAddressSocket.getConnectedSocket().getSystemName().equals(this._locoAddressSocketSystemName)) {
                socketSystemName = this._locoAddressSocketSystemName;
                this._locoAddressSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoAddressSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoAddressSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression " + socketSystemName);
                    }
                }
            } else {
                this._locoAddressSocket.getConnectedSocket().setup();
            }
            if (!this._locoSpeedSocket.isConnected() || !this._locoSpeedSocket.getConnectedSocket().getSystemName().equals(this._locoSpeedSocketSystemName)) {
                socketSystemName = this._locoSpeedSocketSystemName;
                this._locoSpeedSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoSpeedSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoSpeedSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression " + socketSystemName);
                    }
                }
            } else {
                this._locoSpeedSocket.getConnectedSocket().setup();
            }
            if (!this._locoDirectionSocket.isConnected() || !this._locoDirectionSocket.getConnectedSocket().getSystemName().equals(this._locoDirectionSocketSystemName)) {
                socketSystemName = this._locoDirectionSocketSystemName;
                this._locoDirectionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoDirectionSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoDirectionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression " + socketSystemName);
                    }
                }
            } else {
                this._locoDirectionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
        if (this._throttle != null) {
            InstanceManager.getDefault(ThrottleManager.class).releaseThrottle(this._throttle, this._throttleListener);
        }
    }
}

