/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSignalMast
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<SignalMast> _signalMastHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private OperationType _operationType = OperationType.Aspect;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _aspectAddressing = NamedBeanAddressing.Direct;
    private String _signalMastAspect = "";
    private String _aspectReference = "";
    private String _aspectLocalVariable = "";
    private String _aspectFormula = "";
    private ExpressionNode _aspectExpressionNode;
    private NamedBeanHandle<SignalMast> _exampleSignalMastHandle;
    private static final Logger log = LoggerFactory.getLogger(ActionSignalMast.class);

    public ActionSignalMast(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSignalMast copy = new ActionSignalMast(sysName, userName);
        copy.setComment(this.getComment());
        if (this._signalMastHandle != null) {
            copy.setSignalMast(this._signalMastHandle);
        }
        copy.setAspect(this._signalMastAspect);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationType(this._operationType);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        copy.setAspectAddressing(this._aspectAddressing);
        copy.setAspectFormula(this._aspectFormula);
        copy.setAspectLocalVariable(this._aspectLocalVariable);
        copy.setAspectReference(this._aspectReference);
        copy.setExampleSignalMast(this._exampleSignalMastHandle);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setSignalMast(@Nonnull String signalMastName) {
        this.assertListenersAreNotRegistered(log, "setSignalMast");
        SignalMast signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName);
        if (signalMast != null) {
            this.setSignalMast(signalMast);
        } else {
            this.removeSignalMast();
            log.warn("signalMast \"{}\" is not found", (Object)signalMastName);
        }
    }

    public void setSignalMast(@Nonnull NamedBeanHandle<SignalMast> handle) {
        this.assertListenersAreNotRegistered(log, "setSignalMast");
        this._signalMastHandle = handle;
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
    }

    public void setSignalMast(@Nonnull SignalMast signalMast) {
        this.assertListenersAreNotRegistered(log, "setSignalMast");
        this.setSignalMast(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast.getDisplayName(), signalMast));
    }

    public void removeSignalMast() {
        this.assertListenersAreNotRegistered(log, "setSignalMast");
        if (this._signalMastHandle != null) {
            InstanceManager.getDefault(SignalMastManager.class).removeVetoableChangeListener(this);
            this._signalMastHandle = null;
        }
    }

    public NamedBeanHandle<SignalMast> getSignalMast() {
        return this._signalMastHandle;
    }

    public void setExampleSignalMast(@Nonnull String signalMastName) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalMast");
        SignalMast signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName);
        if (signalMast != null) {
            this.setExampleSignalMast(signalMast);
        } else {
            this.removeExampleSignalMast();
            log.warn("signalMast \"{}\" is not found", (Object)signalMastName);
        }
    }

    public void setExampleSignalMast(@Nonnull NamedBeanHandle<SignalMast> handle) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalMast");
        this._exampleSignalMastHandle = handle;
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
    }

    public void setExampleSignalMast(@Nonnull SignalMast signalMast) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalMast");
        this.setExampleSignalMast(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast.getDisplayName(), signalMast));
    }

    public void removeExampleSignalMast() {
        this.assertListenersAreNotRegistered(log, "removeExampleSignalMast");
        if (this._exampleSignalMastHandle != null) {
            InstanceManager.getDefault(SignalMastManager.class).removeVetoableChangeListener(this);
            this._exampleSignalMastHandle = null;
        }
    }

    public NamedBeanHandle<SignalMast> getExampleSignalMast() {
        return this._exampleSignalMastHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationType(OperationType operationType) {
        this._operationType = operationType;
    }

    public OperationType getOperationType() {
        return this._operationType;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setAspectAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._aspectAddressing = addressing;
        this.parseAspectFormula();
    }

    public NamedBeanAddressing getAspectAddressing() {
        return this._aspectAddressing;
    }

    public void setAspect(String aspect) {
        this._signalMastAspect = aspect == null ? "" : aspect;
    }

    public String getAspect() {
        return this._signalMastAspect;
    }

    public void setAspectReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._aspectReference = reference;
    }

    public String getAspectReference() {
        return this._aspectReference;
    }

    public void setAspectLocalVariable(@Nonnull String localVariable) {
        this._aspectLocalVariable = localVariable;
    }

    public String getAspectLocalVariable() {
        return this._aspectLocalVariable;
    }

    public void setAspectFormula(@Nonnull String formula) throws ParserException {
        this._aspectFormula = formula;
        this.parseAspectFormula();
    }

    public String getAspectFormula() {
        return this._aspectFormula;
    }

    private void parseAspectFormula() throws ParserException {
        if (this._aspectAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._aspectExpressionNode = parser.parseExpression(this._aspectFormula);
        } else {
            this._aspectExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof SignalMast) {
                if (this._signalMastHandle != null && evt.getOldValue().equals(this._signalMastHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalMast_SignalMastInUseSignalMastActionVeto", this.getDisplayName()), e);
                }
                if (this._exampleSignalMastHandle != null && evt.getOldValue().equals(this._exampleSignalMastHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalMast_SignalMastInUseSignalMastActionVeto", this.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof SignalMast) {
            if (this._signalMastHandle != null && evt.getOldValue().equals(this._signalMastHandle.getBean())) {
                this.removeSignalMast();
            }
            if (this._exampleSignalMastHandle != null && evt.getOldValue().equals(this._exampleSignalMastHandle.getBean())) {
                this.removeExampleSignalMast();
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewAspect(ConditionalNG conditionalNG) throws JmriException {
        switch (this._aspectAddressing) {
            case Direct: {
                return this._signalMastAspect;
            }
            case Reference: {
                return ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._aspectReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._aspectLocalVariable), false);
            }
            case Formula: {
                return this._aspectExpressionNode != null ? TypeConversionUtil.convertToString(this._aspectExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._aspectAddressing.name());
    }

    private OperationType getOperation() throws JmriException {
        String oper = "";
        try {
            switch (this._operationAddressing) {
                case Direct: {
                    return this._operationType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
                    return OperationType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
                    return OperationType.valueOf(oper);
                }
                case Formula: {
                    if (this._aspectExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false);
                        return OperationType.valueOf(oper);
                    }
                    return null;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown operation: " + oper, e);
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        SignalMast signalMast;
        switch (this._addressing) {
            case Direct: {
                signalMast = this._signalMastHandle != null ? this._signalMastHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                signalMast = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                signalMast = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                signalMast = this._expressionNode != null ? (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (signalMast == null) {
            return;
        }
        OperationType operation = this.getOperation();
        ConditionalNG conditionalNG = this.getConditionalNG();
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            try {
                switch (operation) {
                    case Aspect: {
                        String newAspect = this.getNewAspect(conditionalNG);
                        if (!newAspect.isEmpty()) {
                            signalMast.setAspect(newAspect);
                        }
                        break;
                    }
                    case Lit: {
                        signalMast.setLit(true);
                        break;
                    }
                    case NotLit: {
                        signalMast.setLit(false);
                        break;
                    }
                    case Held: {
                        signalMast.setHeld(true);
                        break;
                    }
                    case NotHeld: {
                        signalMast.setHeld(false);
                        break;
                    }
                    case PermissiveSmlDisabled: {
                        signalMast.setPermissiveSmlDisabled(true);
                        break;
                    }
                    case PermissiveSmlNotDisabled: {
                        signalMast.setPermissiveSmlDisabled(false);
                        break;
                    }
                    default: {
                        throw new JmriException("Unknown enum: " + this._operationType.name());
                    }
                }
            }
            catch (JmriException e) {
                ref.set(e);
            }
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalMast_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String aspect;
        String operation;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String sensorName = this._signalMastHandle != null ? this._signalMastHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", sensorName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                operation = Bundle.getMessage(locale, "AddressByDirect", this._operationType._text);
                break;
            }
            case Reference: {
                operation = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                operation = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                operation = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _operationAddressing state: " + this._operationAddressing.name());
            }
        }
        switch (this._aspectAddressing) {
            case Direct: {
                aspect = Bundle.getMessage(locale, "AddressByDirect", this._signalMastAspect);
                break;
            }
            case Reference: {
                aspect = Bundle.getMessage(locale, "AddressByReference", this._aspectReference);
                break;
            }
            case LocalVariable: {
                aspect = Bundle.getMessage(locale, "AddressByLocalVariable", this._aspectLocalVariable);
                break;
            }
            case Formula: {
                aspect = Bundle.getMessage(locale, "AddressByFormula", this._aspectFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._aspectAddressing.name());
            }
        }
        if (this._operationAddressing == NamedBeanAddressing.Direct) {
            if (this._operationType == OperationType.Aspect) {
                return Bundle.getMessage(locale, "SignalMast_LongAspect", namedBean, aspect);
            }
            return Bundle.getMessage(locale, "SignalMast_Long", namedBean, operation);
        }
        return Bundle.getMessage(locale, "SignalMast_LongUnknownOper", namedBean, operation, aspect);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionSignalMast: bean = {}, report = {}", (Object)cdl, report);
        if (this.getSignalMast() != null && bean.equals(this.getSignalMast().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
        if (this.getExampleSignalMast() != null && bean.equals(this.getExampleSignalMast().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum OperationType {
        Aspect(Bundle.getMessage("SignalMastOperationType_Aspect")),
        Lit(Bundle.getMessage("SignalMastOperationType_Lit")),
        NotLit(Bundle.getMessage("SignalMastOperationType_NotLit")),
        Held(Bundle.getMessage("SignalMastOperationType_Held")),
        NotHeld(Bundle.getMessage("SignalMastOperationType_NotHeld")),
        PermissiveSmlDisabled(Bundle.getMessage("SignalMastOperationType_PermissiveSmlDisabled")),
        PermissiveSmlNotDisabled(Bundle.getMessage("SignalMastOperationType_PermissiveSmlNotDisabled"));

        private final String _text;

        private OperationType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

