/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSignalHead
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<SignalHead> _signalHeadHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private OperationType _operationType = OperationType.Appearance;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _appearanceAddressing = NamedBeanAddressing.Direct;
    private int _signalHeadAppearance = 0;
    private String _appearanceReference = "";
    private String _appearanceLocalVariable = "";
    private String _appearanceFormula = "";
    private ExpressionNode _appearanceExpressionNode;
    private NamedBeanHandle<SignalHead> _exampleSignalHeadHandle;
    private static final Logger log = LoggerFactory.getLogger(ActionSignalHead.class);

    public ActionSignalHead(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSignalHead copy = new ActionSignalHead(sysName, userName);
        copy.setComment(this.getComment());
        if (this._signalHeadHandle != null) {
            copy.setSignalHead(this._signalHeadHandle);
        }
        copy.setAppearance(this._signalHeadAppearance);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationType(this._operationType);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        copy.setAppearanceAddressing(this._appearanceAddressing);
        copy.setAppearanceFormula(this._appearanceFormula);
        copy.setAppearanceLocalVariable(this._appearanceLocalVariable);
        copy.setAppearanceReference(this._appearanceReference);
        copy.setExampleSignalHead(this._exampleSignalHeadHandle);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setSignalHead(@Nonnull String signalHeadName) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (signalHead != null) {
            this.setSignalHead(signalHead);
        } else {
            this.removeSignalHead();
            log.warn("signalHead \"{}\" is not found", (Object)signalHeadName);
        }
    }

    public void setSignalHead(@Nonnull NamedBeanHandle<SignalHead> handle) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        this._signalHeadHandle = handle;
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
    }

    public void setSignalHead(@Nonnull SignalHead signalHead) {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        this.setSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead.getDisplayName(), signalHead));
    }

    public void removeSignalHead() {
        this.assertListenersAreNotRegistered(log, "setSignalHead");
        if (this._signalHeadHandle != null) {
            InstanceManager.getDefault(SignalHeadManager.class).removeVetoableChangeListener(this);
            this._signalHeadHandle = null;
        }
    }

    public NamedBeanHandle<SignalHead> getSignalHead() {
        return this._signalHeadHandle;
    }

    public void setExampleSignalHead(@Nonnull String signalHeadName) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        SignalHead signalHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHeadName);
        if (signalHead != null) {
            this.setExampleSignalHead(signalHead);
        } else {
            this.removeExampleSignalHead();
            log.warn("signalHead \"{}\" is not found", (Object)signalHeadName);
        }
    }

    public void setExampleSignalHead(@Nonnull NamedBeanHandle<SignalHead> handle) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        this._exampleSignalHeadHandle = handle;
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
    }

    public void setExampleSignalHead(@Nonnull SignalHead signalHead) {
        this.assertListenersAreNotRegistered(log, "setExampleSignalHead");
        this.setExampleSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead.getDisplayName(), signalHead));
    }

    public void removeExampleSignalHead() {
        this.assertListenersAreNotRegistered(log, "removeExampleSignalHead");
        if (this._exampleSignalHeadHandle != null) {
            InstanceManager.getDefault(SignalHeadManager.class).removeVetoableChangeListener(this);
            this._exampleSignalHeadHandle = null;
        }
    }

    public NamedBeanHandle<SignalHead> getExampleSignalHead() {
        return this._exampleSignalHeadHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationType(OperationType operationType) {
        this._operationType = operationType;
    }

    public OperationType getOperationType() {
        return this._operationType;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setAppearanceAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._appearanceAddressing = addressing;
        this.parseAppearanceFormula();
    }

    public NamedBeanAddressing getAppearanceAddressing() {
        return this._appearanceAddressing;
    }

    public void setAppearance(int appearance) {
        this._signalHeadAppearance = appearance;
    }

    public int getAppearance() {
        return this._signalHeadAppearance;
    }

    public void setAppearanceReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._appearanceReference = reference;
    }

    public String getAppearanceReference() {
        return this._appearanceReference;
    }

    public void setAppearanceLocalVariable(@Nonnull String localVariable) {
        this._appearanceLocalVariable = localVariable;
    }

    public String getAppearanceLocalVariable() {
        return this._appearanceLocalVariable;
    }

    public void setAppearanceFormula(@Nonnull String formula) throws ParserException {
        this._appearanceFormula = formula;
        this.parseAppearanceFormula();
    }

    public String getAppearanceFormula() {
        return this._appearanceFormula;
    }

    private void parseAppearanceFormula() throws ParserException {
        if (this._appearanceAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._appearanceExpressionNode = parser.parseExpression(this._appearanceFormula);
        } else {
            this._appearanceExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof SignalHead) {
                if (this._signalHeadHandle != null && evt.getOldValue().equals(this._signalHeadHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalHead_SignalHeadInUseSignalHeadActionVeto", this.getDisplayName()), e);
                }
                if (this._exampleSignalHeadHandle != null && evt.getOldValue().equals(this._exampleSignalHeadHandle.getBean())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("SignalHead_SignalHeadInUseSignalHeadActionVeto", this.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof SignalHead) {
            if (this._signalHeadHandle != null && evt.getOldValue().equals(this._signalHeadHandle.getBean())) {
                this.removeSignalHead();
            }
            if (this._exampleSignalHeadHandle != null && evt.getOldValue().equals(this._exampleSignalHeadHandle.getBean())) {
                this.removeExampleSignalHead();
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private int getAppearanceFromName(String name) {
        if (this._signalHeadHandle == null) {
            throw new UnsupportedOperationException("_signalHeadHandle is null");
        }
        SignalHead sh = this._signalHeadHandle.getBean();
        String[] keys = sh.getValidStateKeys();
        int i = 0;
        while (i < keys.length) {
            if (name.equals(keys[i])) {
                return sh.getValidStates()[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Appearance " + name + " is not valid for signal head " + sh.getSystemName());
    }

    private int getNewAppearance(ConditionalNG conditionalNG) throws JmriException {
        switch (this._appearanceAddressing) {
            case Direct: {
                return this._signalHeadAppearance;
            }
            case Reference: {
                return this.getAppearanceFromName(ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._appearanceReference));
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return this.getAppearanceFromName(TypeConversionUtil.convertToString(symbolTable.getValue(this._appearanceLocalVariable), false));
            }
            case Formula: {
                return this._appearanceExpressionNode != null ? this.getAppearanceFromName(TypeConversionUtil.convertToString(this._appearanceExpressionNode.calculate(conditionalNG.getSymbolTable()), false)) : -1;
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._appearanceAddressing.name());
    }

    private OperationType getOperation() throws JmriException {
        String oper = "";
        try {
            switch (this._operationAddressing) {
                case Direct: {
                    return this._operationType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
                    return OperationType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
                    return OperationType.valueOf(oper);
                }
                case Formula: {
                    if (this._appearanceExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false);
                        return OperationType.valueOf(oper);
                    }
                    return null;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown operation: " + oper, e);
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        SignalHead signalHead;
        switch (this._addressing) {
            case Direct: {
                signalHead = this._signalHeadHandle != null ? this._signalHeadHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                signalHead = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                signalHead = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                signalHead = this._expressionNode != null ? (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (signalHead == null) {
            return;
        }
        OperationType operation = this.getOperation();
        ConditionalNG conditionalNG = this.getConditionalNG();
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            try {
                switch (operation) {
                    case Appearance: {
                        int newAppearance = this.getNewAppearance(conditionalNG);
                        if (newAppearance != -1) {
                            signalHead.setAppearance(newAppearance);
                        }
                        break;
                    }
                    case Lit: {
                        signalHead.setLit(true);
                        break;
                    }
                    case NotLit: {
                        signalHead.setLit(false);
                        break;
                    }
                    case Held: {
                        signalHead.setHeld(true);
                        break;
                    }
                    case NotHeld: {
                        signalHead.setHeld(false);
                        break;
                    }
                    default: {
                        throw new JmriException("Unknown enum: " + this._operationType.name());
                    }
                }
            }
            catch (JmriException e) {
                ref.set(e);
            }
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalHead_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String appearance;
        String operation;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String sensorName = this._signalHeadHandle != null ? this._signalHeadHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", sensorName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                operation = Bundle.getMessage(locale, "AddressByDirect", this._operationType._text);
                break;
            }
            case Reference: {
                operation = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                operation = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                operation = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _operationAddressing state: " + this._operationAddressing.name());
            }
        }
        switch (this._appearanceAddressing) {
            case Direct: {
                String a = "";
                if (this._signalHeadHandle != null && this._signalHeadHandle.getBean() != null) {
                    a = this._signalHeadHandle.getBean().getAppearanceName(this._signalHeadAppearance);
                }
                appearance = Bundle.getMessage(locale, "AddressByDirect", a);
                break;
            }
            case Reference: {
                appearance = Bundle.getMessage(locale, "AddressByReference", this._appearanceReference);
                break;
            }
            case LocalVariable: {
                appearance = Bundle.getMessage(locale, "AddressByLocalVariable", this._appearanceLocalVariable);
                break;
            }
            case Formula: {
                appearance = Bundle.getMessage(locale, "AddressByFormula", this._appearanceFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._appearanceAddressing.name());
            }
        }
        if (this._operationAddressing == NamedBeanAddressing.Direct) {
            if (this._operationType == OperationType.Appearance) {
                return Bundle.getMessage(locale, "SignalHead_LongAppearance", namedBean, appearance);
            }
            return Bundle.getMessage(locale, "SignalHead_Long", namedBean, operation);
        }
        return Bundle.getMessage(locale, "SignalHead_LongUnknownOper", namedBean, operation, appearance);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionSignalHead: bean = {}, report = {}", (Object)cdl, report);
        if (this.getSignalHead() != null && bean.equals(this.getSignalHead().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
        if (this.getExampleSignalHead() != null && bean.equals(this.getExampleSignalHead().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum OperationType {
        Appearance(Bundle.getMessage("SignalHeadOperationType_Appearance")),
        Lit(Bundle.getMessage("SignalHeadOperationType_Lit")),
        NotLit(Bundle.getMessage("SignalHeadOperationType_NotLit")),
        Held(Bundle.getMessage("SignalHeadOperationType_Held")),
        NotHeld(Bundle.getMessage("SignalHeadOperationType_NotHeld"));

        private final String _text;

        private OperationType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

