/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReporter
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Reporter> _reporterHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private ReporterValue _reporterValue = ReporterValue.CopyCurrentReport;
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private NamedBeanHandle<Memory> _memoryHandle;
    private static final Logger log = LoggerFactory.getLogger(ActionReporter.class);

    public ActionReporter(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionReporter copy = new ActionReporter(sysName, userName);
        copy.setComment(this.getComment());
        copy.setAddressing(this._addressing);
        if (this._reporterHandle != null) {
            copy.setReporter(this._reporterHandle);
        }
        copy.setReference(this._reference);
        copy.setLocalVariable(this._localVariable);
        copy.setFormula(this._formula);
        copy.setReporterValue(this._reporterValue);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        return manager.registerAction(copy);
    }

    public void setReporter(@Nonnull String reporterName) {
        this.assertListenersAreNotRegistered(log, "setReporter");
        Reporter reporter = (Reporter)InstanceManager.getDefault(ReporterManager.class).getNamedBean(reporterName);
        if (reporter != null) {
            this.setReporter(reporter);
        } else {
            this.removeReporter();
            log.error("Reporter \"{}\" is not found", (Object)reporterName);
        }
    }

    public void setReporter(@Nonnull Reporter reporter) {
        this.assertListenersAreNotRegistered(log, "setReporter");
        this.setReporter(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(reporter.getDisplayName(), reporter));
    }

    public void setReporter(@Nonnull NamedBeanHandle<Reporter> handle) {
        this.assertListenersAreNotRegistered(log, "setReporter");
        this._reporterHandle = handle;
        InstanceManager.getDefault(ReporterManager.class).addVetoableChangeListener(this);
    }

    public void removeReporter() {
        this.assertListenersAreNotRegistered(log, "removeReporter");
        if (this._reporterHandle != null) {
            InstanceManager.getDefault(ReporterManager.class).removeVetoableChangeListener(this);
            this._reporterHandle = null;
        }
    }

    public NamedBeanHandle<Reporter> getReporter() {
        return this._reporterHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setReporterValue(ReporterValue value) {
        this._reporterValue = value;
    }

    public ReporterValue getReporterValue() {
        return this._reporterValue;
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        Memory memory = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.error("Memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "removeMemory");
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
            this._memoryHandle = null;
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Reporter && evt.getOldValue().equals(this.getReporter().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("ActionReporter_ReporterInUseVeto", this.getDisplayName()), e);
            }
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("ActionReporter_MemoryInUseVeto", this.getDisplayName()), e);
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    Reporter getSourceReporter() throws JmriException {
        Reporter reporter = null;
        switch (this._addressing) {
            case Direct: {
                reporter = this._reporterHandle != null ? this._reporterHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                reporter = (Reporter)InstanceManager.getDefault(ReporterManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                reporter = (Reporter)InstanceManager.getDefault(ReporterManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                reporter = this._expressionNode != null ? (Reporter)InstanceManager.getDefault(ReporterManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        return reporter;
    }

    Object getReporterData(Reporter reporter) throws JmriException {
        Object obj;
        ReporterValue value = this._reporterValue;
        switch (value) {
            case CopyCurrentReport: {
                obj = reporter.getCurrentReport();
                break;
            }
            case CopyLastReport: {
                obj = reporter.getLastReport();
                break;
            }
            case CopyState: {
                obj = reporter.getState();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value name: " + value.name());
            }
        }
        return obj;
    }

    void updateDestination(Object data) throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                if (this._memoryHandle == null) break;
                this._memoryHandle.getBean().setValue(data);
                break;
            }
            case Reference: {
                String refName = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
                log.debug("ref ref = {}, name = {}", (Object)this._dataReference, (Object)refName);
                Memory refMem = InstanceManager.getDefault(MemoryManager.class).getMemory(refName);
                if (refMem == null) {
                    throw new IllegalArgumentException("invalid memory reference: " + refName);
                }
                refMem.setValue(data);
                break;
            }
            case LocalVariable: {
                log.debug("LocalVariable: lv = {}", (Object)this._dataLocalVariable);
                this.getConditionalNG().getSymbolTable().setValue(this._dataLocalVariable, data);
                break;
            }
            case Formula: {
                String formulaName;
                String string = formulaName = this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
                if (formulaName == null) {
                    throw new IllegalArgumentException("invalid memory formula, name is null");
                }
                Memory formulaMem = InstanceManager.getDefault(MemoryManager.class).getMemory(formulaName);
                if (formulaMem == null) {
                    throw new IllegalArgumentException("invalid memory formula: " + formulaName);
                }
                formulaMem.setValue(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
            }
        }
    }

    @Override
    public void execute() throws JmriException {
        Reporter reporter = this.getSourceReporter();
        if (reporter == null) {
            return;
        }
        log.debug("reporter = {}", (Object)reporter.getDisplayName());
        Object data = this.getReporterData(reporter);
        log.debug("data = {}", data);
        this.updateDestination(data);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionReporter_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String bean = "";
        String dest = "";
        switch (this._addressing) {
            case Direct: {
                String reporterName = this._reporterHandle != null ? this._reporterHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                bean = Bundle.getMessage(locale, "AddressByDirect", reporterName);
                break;
            }
            case Reference: {
                bean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                bean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                bean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._dataAddressing) {
            case Direct: {
                String memoryName = this._memoryHandle != null ? this._memoryHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                dest = Bundle.getMessage(locale, "AddressByDirect", memoryName);
                break;
            }
            case Reference: {
                dest = Bundle.getMessage(locale, "AddressByReference", this._dataReference);
                break;
            }
            case LocalVariable: {
                dest = Bundle.getMessage(locale, "AddressByLocalVariable", this._dataLocalVariable);
                break;
            }
            case Formula: {
                dest = Bundle.getMessage(locale, "AddressByFormula", this._dataFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
            }
        }
        String item = this.getReporterValue().toString();
        return Bundle.getMessage(locale, "ActionReporter_Long", item, bean, dest);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionReporter: bean = {}, report = {}", (Object)cdl, report);
        if (this.getReporter() != null && bean.equals(this.getReporter().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum ReporterValue {
        CopyCurrentReport(Bundle.getMessage("ActionReporter_CopyCurrentReport")),
        CopyLastReport(Bundle.getMessage("ActionReporter_CopyLastReport")),
        CopyState(Bundle.getMessage("ActionReporter_CopyState"));

        private final String _text;

        private ReporterValue(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

