/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.util.ThreadingUtil;

public class ActionPower
extends AbstractDigitalAction {
    private PowerState _powerState = PowerState.On;

    public ActionPower(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionPower copy = new ActionPower(sysName, userName);
        copy.setComment(this.getComment());
        copy.setBeanState(this._powerState);
        return manager.registerAction(copy);
    }

    public void setBeanState(PowerState state) {
        this._powerState = state;
    }

    public PowerState getBeanState() {
        return this._powerState;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        AtomicReference exception = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            try {
                InstanceManager.getDefault(PowerManager.class).setPower(this._powerState.getID());
            }
            catch (JmriException e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (JmriException)exception.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Power_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Power_Long", this._powerState._text);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum PowerState {
        Off(4, Bundle.getMessage("PowerStateOff")),
        On(2, Bundle.getMessage("PowerStateOn"));

        private final int _id;
        private final String _text;

        private PowerState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static PowerState get(int id) {
            switch (id) {
                case 4: {
                    return Off;
                }
                case 2: {
                    return On;
                }
            }
            throw new IllegalArgumentException("invalid power state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

