/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMemory
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Memory> _memoryHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanHandle<Memory> _otherMemoryHandle;
    private MemoryOperation _memoryOperation = MemoryOperation.SetToString;
    private String _otherConstantValue = "";
    private String _otherTableCell = "";
    private String _otherLocalVariable = "";
    private String _otherFormula = "";
    private ExpressionNode _otherExpressionNode;
    private boolean _listenToMemory = true;
    private static final Logger log = LoggerFactory.getLogger(ActionMemory.class);

    public ActionMemory(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionMemory copy = new ActionMemory(sysName, userName);
        copy.setComment(this.getComment());
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        if (this._otherMemoryHandle != null) {
            copy.setOtherMemory(this._otherMemoryHandle);
        }
        copy.setMemoryOperation(this._memoryOperation);
        copy.setOtherConstantValue(this._otherConstantValue);
        copy.setOtherTableCell(this._otherTableCell);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setOtherFormula(this._otherFormula);
        copy.setListenToMemory(this._listenToMemory);
        return manager.registerAction(copy);
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "removeMemory");
        if (this._memoryHandle != null) {
            this._memoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setMemoryOperation(MemoryOperation state) throws ParserException {
        this._memoryOperation = state;
        this.parseOtherFormula();
    }

    public MemoryOperation getMemoryOperation() {
        return this._memoryOperation;
    }

    public void setOtherConstantValue(String constantValue) {
        this._otherConstantValue = constantValue;
    }

    public String getConstantValue() {
        return this._otherConstantValue;
    }

    public void setOtherMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
        Memory memory = memoryManager.getMemory(memoryName);
        if (memory != null) {
            this.setOtherMemory(memory);
        } else {
            this.removeOtherMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setOtherMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        this._otherMemoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setOtherMemory(@Nonnull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setOtherMemory");
        this.setOtherMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeOtherMemory() {
        this.assertListenersAreNotRegistered(log, "removeOtherMemory");
        if (this._otherMemoryHandle != null) {
            this._otherMemoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getOtherMemory() {
        return this._otherMemoryHandle;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setOtherTableCell(@Nonnull String tableCell) {
        if (!tableCell.isEmpty() && !ReferenceUtil.isReference(tableCell)) {
            throw new IllegalArgumentException("The table reference \"" + tableCell + "\" is not a valid reference");
        }
        this._otherTableCell = tableCell;
    }

    public String getOtherTableCell() {
        return this._otherTableCell;
    }

    public static String convertTableReference(String string, boolean toReference) {
        String tableString = string == null ? "" : string.trim();
        boolean referenceFormat = ReferenceUtil.isReference(tableString);
        if (toReference) {
            if (referenceFormat) {
                return tableString;
            }
            return "{" + tableString + "}";
        }
        if (!referenceFormat) {
            return tableString;
        }
        return tableString.isEmpty() ? "" : tableString.substring(1, tableString.length() - 1);
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setOtherFormula(String formula) throws ParserException {
        this._otherFormula = formula;
        this.parseOtherFormula();
    }

    public String getOtherFormula() {
        return this._otherFormula;
    }

    private void parseOtherFormula() throws ParserException {
        if (this._memoryOperation == MemoryOperation.CalculateFormula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._otherExpressionNode = parser.parseExpression(this._otherFormula);
        } else {
            this._otherExpressionNode = null;
        }
    }

    private void addRemoveVetoListener() {
        if (this._memoryHandle != null || this._otherMemoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory) {
            boolean doVeto = false;
            if (this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                doVeto = true;
            }
            if (this._otherMemoryHandle != null && evt.getOldValue().equals(this._otherMemoryHandle.getBean())) {
                doVeto = true;
            }
            if (doVeto) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("ActionMemory_MemoryInUseMemoryActionVeto", this.getDisplayName()), e);
            }
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        Object ref;
        Memory memory;
        switch (this._addressing) {
            case Direct: {
                memory = this._memoryHandle != null ? this._memoryHandle.getBean() : null;
                break;
            }
            case Reference: {
                ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                memory = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean((String)ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                memory = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                memory = this._expressionNode != null ? (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (memory == null) {
            return;
        }
        ref = new AtomicReference();
        ConditionalNG conditionalNG = this.getConditionalNG();
        ThreadingUtil.runOnLayoutWithJmriException(() -> this.lambda$0(memory, conditionalNG, (AtomicReference)ref));
        if (((AtomicReference)ref).get() != null) {
            throw (JmriException)((AtomicReference)ref).get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionMemory_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
        String copyToMemoryName = this._otherMemoryHandle != null ? this._otherMemoryHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._memoryOperation) {
            case SetToNull: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Null", memoryName);
            }
            case SetToString: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Value", memoryName, this._otherConstantValue);
            }
            case CopyTableCellToMemory: {
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyTableCellToMemory", memoryName, ActionMemory.convertTableReference(this._otherTableCell, false));
            }
            case CopyVariableToMemory: {
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyVariableToMemory", memoryName, this._otherLocalVariable);
            }
            case CopyMemoryToMemory: {
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyMemoryToMemory", memoryName, copyToMemoryName);
            }
            case CalculateFormula: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Formula", memoryName, this._otherFormula);
            }
        }
        throw new IllegalArgumentException("_memoryOperation has invalid value: " + this._memoryOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._otherMemoryHandle != null) {
            if (this._listenToMemory) {
                this._otherMemoryHandle.getBean().addPropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._listenToMemory && this._otherMemoryHandle != null) {
                this._otherMemoryHandle.getBean().removePropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionMemory: bean = {}, report = {}", (Object)cdl, report);
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
        if (this.getOtherMemory() != null && bean.equals(this.getOtherMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    private /* synthetic */ void lambda$0(Memory memory, ConditionalNG conditionalNG, AtomicReference atomicReference) throws JmriException, RuntimeException {
        switch (this._memoryOperation) {
            case SetToNull: {
                memory.setValue(null);
                break;
            }
            case SetToString: {
                memory.setValue(this._otherConstantValue);
                break;
            }
            case CopyTableCellToMemory: {
                String refValue = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._otherTableCell);
                memory.setValue(refValue);
                break;
            }
            case CopyVariableToMemory: {
                Object variableValue = conditionalNG.getSymbolTable().getValue(this._otherLocalVariable);
                memory.setValue(variableValue);
                break;
            }
            case CopyMemoryToMemory: {
                if (this._otherMemoryHandle != null) {
                    memory.setValue(this._otherMemoryHandle.getBean().getValue());
                    break;
                }
                log.warn("setMemory should copy memory to memory but other memory is null");
                break;
            }
            case CalculateFormula: {
                if (this._otherFormula.isEmpty()) {
                    memory.setValue(null);
                    break;
                }
                try {
                    if (this._otherExpressionNode == null) {
                        return;
                    }
                    memory.setValue(this._otherExpressionNode.calculate(conditionalNG.getSymbolTable()));
                }
                catch (JmriException e) {
                    atomicReference.set(e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("_memoryOperation has invalid value: {}" + this._memoryOperation.name());
            }
        }
    }

    public static enum MemoryOperation {
        SetToNull(Bundle.getMessage("ActionMemory_MemoryOperation_SetToNull")),
        SetToString(Bundle.getMessage("ActionMemory_MemoryOperation_SetToString")),
        CopyVariableToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyVariableToMemory")),
        CopyMemoryToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyMemoryToMemory")),
        CopyTableCellToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyTableCellToMemory")),
        CalculateFormula(Bundle.getMessage("ActionMemory_MemoryOperation_CalculateFormula"));

        private final String _text;

        private MemoryOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

