/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLocalVariable
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private String _localVariable;
    private NamedBeanHandle<Memory> _memoryHandle;
    private VariableOperation _variableOperation = VariableOperation.SetToString;
    private String _constantValue = "";
    private String _otherTableCell = "";
    private String _otherLocalVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private boolean _listenToMemory = true;
    private static final Logger log = LoggerFactory.getLogger(ActionLocalVariable.class);

    public ActionLocalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = systemNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLocalVariable copy = new ActionLocalVariable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setLocalVariable(this._localVariable);
        copy.setVariableOperation(this._variableOperation);
        copy.setConstantValue(this._constantValue);
        if (this._memoryHandle != null) {
            copy.setMemory(this._memoryHandle);
        }
        copy.setOtherTableCell(this._otherTableCell);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setFormula(this._formula);
        copy.setListenToMemory(this._listenToMemory);
        return manager.registerAction(copy);
    }

    public void setLocalVariable(String variableName) {
        this.assertListenersAreNotRegistered(log, "setLocalVariable");
        this._localVariable = variableName;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setMemory(@Nonnull String memoryName) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
        Memory memory = memoryManager.getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        this._memoryHandle = handle;
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public void setMemory(@CheckForNull Memory memory) {
        this.assertListenersAreNotRegistered(log, "setMemory");
        if (memory != null) {
            this._memoryHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            this._memoryHandle = null;
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public void removeMemory() {
        this.assertListenersAreNotRegistered(log, "removeMemory");
        if (this._memoryHandle != null) {
            InstanceManager.memoryManagerInstance().removeVetoableChangeListener(this);
            this._memoryHandle = null;
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setVariableOperation(VariableOperation variableOperation) throws ParserException {
        this._variableOperation = variableOperation;
        this.parseFormula();
    }

    public VariableOperation getVariableOperation() {
        return this._variableOperation;
    }

    public void setOtherTableCell(@Nonnull String tableCell) {
        if (!tableCell.isEmpty() && !ReferenceUtil.isReference(tableCell)) {
            throw new IllegalArgumentException("The table reference \"" + tableCell + "\" is not a valid reference");
        }
        this._otherTableCell = tableCell;
    }

    public String getOtherTableCell() {
        return this._otherTableCell;
    }

    public static String convertTableReference(String string, boolean toReference) {
        String tableString = string == null ? "" : string.trim();
        boolean referenceFormat = ReferenceUtil.isReference(tableString);
        if (toReference) {
            if (referenceFormat) {
                return tableString;
            }
            return "{" + tableString + "}";
        }
        if (!referenceFormat) {
            return tableString;
        }
        return tableString.isEmpty() ? "" : tableString.substring(1, tableString.length() - 1);
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setFormula(String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    private void parseFormula() throws ParserException {
        if (this._variableOperation == VariableOperation.CalculateFormula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this._memoryHandle.getBean())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("ActionLocalVariable_MemoryInUseLocalVariableActionVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        if (this._localVariable == null) {
            return;
        }
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        switch (this._variableOperation) {
            case SetToNull: {
                symbolTable.setValue(this._localVariable, null);
                break;
            }
            case SetToString: {
                symbolTable.setValue(this._localVariable, this._constantValue);
                break;
            }
            case CopyVariableToVariable: {
                Object variableValue = this.getConditionalNG().getSymbolTable().getValue(this._otherLocalVariable);
                symbolTable.setValue(this._localVariable, variableValue);
                break;
            }
            case CopyMemoryToVariable: {
                if (this._memoryHandle != null) {
                    symbolTable.setValue(this._localVariable, this._memoryHandle.getBean().getValue());
                    break;
                }
                log.warn("ActionLocalVariable should copy memory to variable but memory is null");
                break;
            }
            case CopyTableCellToVariable: {
                String refValue = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._otherTableCell);
                symbolTable.setValue(this._localVariable, refValue);
                break;
            }
            case CalculateFormula: {
                if (this._formula.isEmpty()) {
                    symbolTable.setValue(this._localVariable, null);
                    break;
                }
                if (this._expressionNode == null) {
                    return;
                }
                symbolTable.setValue(this._localVariable, this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()));
                break;
            }
            default: {
                throw new IllegalArgumentException("_memoryOperation has invalid value: {}" + this._variableOperation.name());
            }
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionLocalVariable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String copyToMemoryName = this._memoryHandle != null ? this._memoryHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._variableOperation) {
            case SetToNull: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_Null", this._localVariable);
            }
            case SetToString: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_Value", this._localVariable, this._constantValue);
            }
            case CopyVariableToVariable: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_CopyVariableToVariable", this._localVariable, this._otherLocalVariable);
            }
            case CopyTableCellToVariable: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_CopyTableCellToVariable", this._localVariable, ActionLocalVariable.convertTableReference(this._otherTableCell, false));
            }
            case CopyMemoryToVariable: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_CopyMemoryToVariable", this._localVariable, copyToMemoryName);
            }
            case CalculateFormula: {
                return Bundle.getMessage(locale, "ActionLocalVariable_Long_Formula", this._localVariable, this._formula);
            }
        }
        throw new IllegalArgumentException("_memoryOperation has invalid value: " + this._variableOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered && this._memoryHandle != null) {
            if (this._listenToMemory) {
                this._memoryHandle.getBean().addPropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._listenToMemory && this._memoryHandle != null) {
                this._memoryHandle.getBean().removePropertyChangeListener("value", this);
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionLocalVariable: bean = {}, report = {}", (Object)cdl, report);
        if (this.getMemory() != null && bean.equals(this.getMemory().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum VariableOperation {
        SetToNull(Bundle.getMessage("ActionLocalVariable_VariableOperation_SetToNull")),
        SetToString(Bundle.getMessage("ActionLocalVariable_VariableOperation_SetToString")),
        CopyVariableToVariable(Bundle.getMessage("ActionLocalVariable_VariableOperation_CopyVariableToVariable")),
        CopyMemoryToVariable(Bundle.getMessage("ActionLocalVariable_VariableOperation_CopyMemoryToVariable")),
        CopyTableCellToVariable(Bundle.getMessage("ActionLocalVariable_VariableOperation_CopyTableCellToVariable")),
        CalculateFormula(Bundle.getMessage("ActionLocalVariable_VariableOperation_CalculateFormula"));

        private final String _text;

        private VariableOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

