/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.actions.NamedBeanType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionListenOnBeansTable
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanType _namedBeanType = NamedBeanType.Light;
    private NamedBeanHandle<NamedTable> _tableHandle;
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnName = "";
    private boolean _includeCellsWithoutHeader = false;
    private boolean _listenOnAllProperties = false;
    private final List<Map.Entry<NamedBean, String>> _namedBeansEntries = new ArrayList<Map.Entry<NamedBean, String>>();
    private static final Logger log = LoggerFactory.getLogger(ActionListenOnBeansTable.class);

    public ActionListenOnBeansTable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionListenOnBeansTable copy = new ActionListenOnBeansTable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNamedBeanType(this._namedBeanType);
        copy.setTable(this._tableHandle);
        copy.setTableRowOrColumn(this._tableRowOrColumn);
        copy.setIncludeCellsWithoutHeader(this._includeCellsWithoutHeader);
        return manager.registerAction(copy);
    }

    public NamedBeanType getNamedBeanType() {
        return this._namedBeanType;
    }

    public void setNamedBeanType(@Nonnull NamedBeanType namedBeanType) {
        if (namedBeanType == null) {
            throw new RuntimeException("Daniel");
        }
        this._namedBeanType = namedBeanType;
    }

    public void setTable(@Nonnull String tableName) {
        this.assertListenersAreNotRegistered(log, "setTable");
        NamedTable table = InstanceManager.getDefault(NamedTableManager.class).getNamedTable(tableName);
        if (table != null) {
            this.setTable(table);
        } else {
            this.removeTable();
            log.error("table \"{}\" is not found", (Object)tableName);
        }
    }

    public void setTable(@Nonnull NamedBeanHandle<NamedTable> handle) {
        this.assertListenersAreNotRegistered(log, "setTable");
        this._tableHandle = handle;
        InstanceManager.getDefault(NamedTableManager.class).addVetoableChangeListener(this);
    }

    public void setTable(@Nonnull NamedTable table) {
        this.assertListenersAreNotRegistered(log, "setTable");
        this.setTable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(table.getDisplayName(), table));
    }

    public void removeTable() {
        this.assertListenersAreNotRegistered(log, "setTable");
        if (this._tableHandle != null) {
            InstanceManager.getDefault(NamedTableManager.class).removeVetoableChangeListener(this);
            this._tableHandle = null;
        }
    }

    public NamedBeanHandle<NamedTable> getTable() {
        return this._tableHandle;
    }

    public TableRowOrColumn getTableRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setTableRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public String getRowOrColumnName() {
        return this._rowOrColumnName;
    }

    public void setRowOrColumnName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new IllegalArgumentException("Row/column name is null");
        }
        this._rowOrColumnName = rowOrColumnName;
    }

    public boolean getListenOnAllProperties() {
        return this._listenOnAllProperties;
    }

    public void setListenOnAllProperties(boolean listenOnAllProperties) {
        this._listenOnAllProperties = listenOnAllProperties;
    }

    public boolean getIncludeCellsWithoutHeader() {
        return this._includeCellsWithoutHeader;
    }

    public void setIncludeCellsWithoutHeader(boolean includeCellsWithoutHeader) {
        this._includeCellsWithoutHeader = includeCellsWithoutHeader;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
            this.removeTable();
        }
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() {
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeansTable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeansTable_Long", this._namedBeanType.toString(), this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._tableRowOrColumn.toStringLowerCase(), this._rowOrColumnName, this.getTable() != null ? this.getTable().getName() : "");
    }

    @Override
    public void setup() {
    }

    public List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>();
        if (this._tableHandle == null) {
            log.error("tableHandle is null");
            return items;
        }
        if (this._rowOrColumnName.isEmpty()) {
            log.error("rowOrColumnName is empty string");
            return items;
        }
        NamedTable table = this._tableHandle.getBean();
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int row = table.getRowNumber(this._rowOrColumnName);
            int column = 1;
            while (column <= table.numColumns()) {
                Object cell;
                Object header = table.getCell(0, column);
                if ((this._includeCellsWithoutHeader || header != null && !header.toString().isEmpty()) && (cell = table.getCell(row, column)) != null) {
                    items.add(cell.toString());
                }
                ++column;
            }
        } else {
            int column = table.getColumnNumber(this._rowOrColumnName);
            int row = 1;
            while (row <= table.numRows()) {
                Object cell;
                Object header = table.getCell(row, 0);
                if ((this._includeCellsWithoutHeader || header != null && !header.toString().isEmpty()) && (cell = table.getCell(row, column)) != null && !cell.toString().isEmpty()) {
                    items.add(cell.toString());
                }
                ++row;
            }
        }
        return items;
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        List<String> items = this.getItems();
        for (String item : items) {
            NamedBean namedBean = this._namedBeanType.getManager().getNamedBean(item);
            if (namedBean != null) {
                AbstractMap.SimpleEntry<NamedBean, String> namedBeanEntry = new AbstractMap.SimpleEntry<NamedBean, String>(namedBean, this._namedBeanType.getPropertyName());
                this._namedBeansEntries.add(namedBeanEntry);
                if (!this._listenOnAllProperties && this._namedBeanType.getPropertyName() != null) {
                    namedBean.addPropertyChangeListener(this._namedBeanType.getPropertyName(), this);
                    continue;
                }
                namedBean.addPropertyChangeListener(this);
                continue;
            }
            log.warn("The named bean \"{}\" cannot be found in the manager for {}", (Object)item, (Object)this._namedBeanType.toString());
        }
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        for (Map.Entry<NamedBean, String> namedBeanEntry : this._namedBeansEntries) {
            if (!this._listenOnAllProperties && namedBeanEntry.getValue() != null) {
                namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
            } else {
                namedBeanEntry.getKey().removePropertyChangeListener(this);
            }
            namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
        }
        this._listenersAreRegistered = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }
}

