/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.actions.NamedBeanType;
import jmri.jmrit.logixng.util.DuplicateKeyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionListenOnBeans
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private final Map<String, NamedBeanReference> _namedBeanReferences = new DuplicateKeyMap<String, NamedBeanReference>();
    private String _localVariableNamedBean;
    private String _localVariableEvent;
    private String _localVariableNewValue;
    private String _lastNamedBean;
    private String _lastEvent;
    private String _lastNewValue;
    private static final Logger log = LoggerFactory.getLogger(ActionListenOnBeans.class);

    public ActionListenOnBeans(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionListenOnBeans copy = new ActionListenOnBeans(sysName, userName);
        copy.setComment(this.getComment());
        for (NamedBeanReference reference : this._namedBeanReferences.values()) {
            copy.addReference(reference);
        }
        return manager.registerAction(copy);
    }

    public void addReference(String beanAndType) {
        this.assertListenersAreNotRegistered(log, "addReference");
        String[] parts = beanAndType.split(":");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Parameter 'beanAndType' must be on the format type:name where type is turnout, sensor, memory, ..., or on the format type:name:all where all is yes or no");
        }
        boolean listenToAll = false;
        if (parts.length == 3) {
            listenToAll = "yes".equals(parts[2]);
        }
        try {
            NamedBeanType type = NamedBeanType.valueOf(parts[0]);
            NamedBeanReference reference = new NamedBeanReference(parts[1], type, listenToAll);
            this._namedBeanReferences.put(reference._name, reference);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String types = Arrays.asList(NamedBeanType.values()).stream().map(Enum::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Parameter 'beanAndType' has wrong type. Valid types are: " + types);
        }
    }

    public void addReference(NamedBeanReference reference) {
        this.assertListenersAreNotRegistered(log, "addReference");
        this._namedBeanReferences.put(reference._name, reference);
    }

    public void removeReference(NamedBeanReference reference) {
        this.assertListenersAreNotRegistered(log, "removeReference");
        this._namedBeanReferences.remove(reference._name);
    }

    public Collection<NamedBeanReference> getReferences() {
        return this._namedBeanReferences.values();
    }

    public void clearReferences() {
        this._namedBeanReferences.clear();
    }

    public void setLocalVariableNamedBean(String localVariableNamedBean) {
        this._localVariableNamedBean = localVariableNamedBean != null && !localVariableNamedBean.isEmpty() ? localVariableNamedBean : null;
    }

    public String getLocalVariableNamedBean() {
        return this._localVariableNamedBean;
    }

    public void setLocalVariableEvent(String localVariableEvent) {
        this._localVariableEvent = localVariableEvent != null && !localVariableEvent.isEmpty() ? localVariableEvent : null;
    }

    public String getLocalVariableEvent() {
        return this._localVariableEvent;
    }

    public void setLocalVariableNewValue(String localVariableNewValue) {
        this._localVariableNewValue = localVariableNewValue != null && !localVariableNewValue.isEmpty() ? localVariableNewValue : null;
    }

    public String getLocalVariableNewValue() {
        return this._localVariableNewValue;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        ActionListenOnBeans actionListenOnBeans = this;
        synchronized (actionListenOnBeans) {
            SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
            if (this._localVariableNamedBean != null) {
                symbolTable.setValue(this._localVariableNamedBean, this._lastNamedBean);
            }
            if (this._localVariableEvent != null) {
                symbolTable.setValue(this._localVariableEvent, this._lastEvent);
            }
            if (this._localVariableNewValue != null) {
                symbolTable.setValue(this._localVariableNewValue, this._lastNewValue);
            }
            this._lastNamedBean = null;
            this._lastEvent = null;
            this._lastNewValue = null;
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeans_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeans_Long");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        for (NamedBeanReference namedBeanReference : this._namedBeanReferences.values()) {
            if (namedBeanReference._handle == null) continue;
            if (!namedBeanReference._listenOnAllProperties && namedBeanReference._type.getPropertyName() != null) {
                namedBeanReference._handle.getBean().addPropertyChangeListener(namedBeanReference._type.getPropertyName(), this);
                continue;
            }
            namedBeanReference._handle.getBean().addPropertyChangeListener(this);
        }
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        for (NamedBeanReference namedBeanReference : this._namedBeanReferences.values()) {
            if (namedBeanReference._handle == null) continue;
            if (!namedBeanReference._listenOnAllProperties && namedBeanReference._type.getPropertyName() != null) {
                namedBeanReference._handle.getBean().removePropertyChangeListener(namedBeanReference._type.getPropertyName(), this);
                continue;
            }
            namedBeanReference._handle.getBean().removePropertyChangeListener(this);
        }
        this._listenersAreRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ActionListenOnBeans actionListenOnBeans = this;
        synchronized (actionListenOnBeans) {
            this._lastNamedBean = ((NamedBean)evt.getSource()).getDisplayName();
            this._lastEvent = evt.getPropertyName();
            this._lastNewValue = evt.getNewValue() != null ? evt.getNewValue().toString() : null;
        }
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionListenOnBeans: bean = {}, report = {}", (Object)cdl, report);
        for (NamedBeanReference namedBeanReference : this._namedBeanReferences.values()) {
            if (namedBeanReference._handle == null || !bean.equals(namedBeanReference._handle.getBean())) continue;
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static class NamedBeanReference {
        private String _name;
        private NamedBeanType _type;
        private NamedBeanHandle<? extends NamedBean> _handle;
        private boolean _listenOnAllProperties = false;

        public NamedBeanReference(NamedBeanReference ref) {
            this(ref._name, ref._type, ref._listenOnAllProperties);
        }

        public NamedBeanReference(String name, NamedBeanType type, boolean all) {
            this._name = name;
            this._type = type;
            this._listenOnAllProperties = all;
            NamedBean bean = this._type.getManager().getNamedBean(name);
            if (bean != null) {
                this._handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this._name, bean);
            }
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
            this.updateHandle();
        }

        public NamedBeanType getType() {
            return this._type;
        }

        public void setType(NamedBeanType type) {
            if (type == null) {
                log.warn("type is null");
                type = NamedBeanType.Turnout;
            }
            this._type = type;
            this.updateHandle();
        }

        public NamedBeanHandle<? extends NamedBean> getHandle() {
            return this._handle;
        }

        private void updateHandle() {
            if (!this._name.isEmpty()) {
                NamedBean bean = this._type.getManager().getNamedBean(this._name);
                if (bean != null) {
                    this._handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this._name, bean);
                } else {
                    log.warn("Cannot find named bean " + this._name + " in manager for " + this._type.getManager().getBeanTypeHandled());
                    this._handle = null;
                }
            } else {
                this._handle = null;
            }
        }

        public boolean getListenOnAllProperties() {
            return this._listenOnAllProperties;
        }

        public void setListenOnAllProperties(boolean listenOnAllProperties) {
            this._listenOnAllProperties = listenOnAllProperties;
        }
    }
}

