/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.VariableLight;
import jmri.VariableLightManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLightIntensity
extends AbstractDigitalAction
implements FemaleSocketListener,
VetoableChangeListener {
    public static final int INTENSITY_SOCKET = 0;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<VariableLight> _lightHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private String _intensitySocketSystemName;
    private final FemaleAnalogExpressionSocket _intensitySocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionLightIntensity_SocketName"));
    private static final Logger log = LoggerFactory.getLogger(ActionLightIntensity.class);

    public ActionLightIntensity(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLightIntensity copy = new ActionLightIntensity(sysName, userName);
        copy.setComment(this.getComment());
        if (this._lightHandle != null) {
            copy.setLight(this._lightHandle);
        }
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setLight(@Nonnull String lightName) {
        this.assertListenersAreNotRegistered(log, "setLight");
        VariableLight light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(lightName);
        if (light != null) {
            this.setLight(light);
        } else {
            this.removeLight();
            log.warn("light \"{}\" is not found", (Object)lightName);
        }
    }

    public void setLight(@Nonnull NamedBeanHandle<VariableLight> handle) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this._lightHandle = handle;
        InstanceManager.lightManagerInstance().addVetoableChangeListener(this);
    }

    public void setLight(@Nonnull VariableLight light) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this.setLight(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(light.getDisplayName(), light));
    }

    public void removeLight() {
        this.assertListenersAreNotRegistered(log, "setLight");
        if (this._lightHandle != null) {
            InstanceManager.lightManagerInstance().removeVetoableChangeListener(this);
            this._lightHandle = null;
        }
    }

    public NamedBeanHandle<VariableLight> getLight() {
        return this._lightHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof VariableLight && evt.getOldValue().equals(this.getLight().getBean())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("ActionLightIntensity_LightInUseLightActionVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public void execute() throws JmriException {
        VariableLight light;
        switch (this._addressing) {
            case Direct: {
                light = this._lightHandle != null ? this._lightHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                light = (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                light = this._expressionNode != null ? (VariableLight)InstanceManager.getDefault(VariableLightManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (light == null) {
            return;
        }
        double intensity = 0.0;
        if (this._intensitySocket.isConnected()) {
            intensity = ((MaleAnalogExpressionSocket)this._intensitySocket.getConnectedSocket()).evaluate();
        }
        if (intensity < 0.0) {
            intensity = 0.0;
        }
        if (intensity > 100.0) {
            intensity = 100.0;
        }
        light.setTargetIntensity(intensity / 100.0);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._intensitySocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._intensitySocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._intensitySocketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._intensitySocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._intensitySocketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionLightIntensity_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String lightName = this._lightHandle != null ? this._lightHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", lightName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionLightIntensity_Long", namedBean);
    }

    public FemaleAnalogExpressionSocket getIntensitySocket() {
        return this._intensitySocket;
    }

    public String getIntensitySocketSystemName() {
        return this._intensitySocketSystemName;
    }

    public void setIntensitySystemName(String systemName) {
        this._intensitySocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._intensitySocket.isConnected() || !this._intensitySocket.getConnectedSocket().getSystemName().equals(this._intensitySocketSystemName)) {
                String socketSystemName = this._intensitySocketSystemName;
                this._intensitySocket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._intensitySocket.disconnect();
                    if (maleSocket != null) {
                        this._intensitySocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression " + socketSystemName);
                    }
                }
            } else {
                this._intensitySocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

