/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.VariableLight;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLight
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Light> _lightHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _stateAddressing = NamedBeanAddressing.Direct;
    private LightState _lightState = LightState.On;
    private String _stateReference = "";
    private String _stateLocalVariable = "";
    private String _stateFormula = "";
    private ExpressionNode _stateExpressionNode;
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private int _lightValue = 0;
    private static final int TOGGLE_ID = -1;
    private static final int INTENSITY_ID = -2;
    private static final int INTERVAL_ID = -3;
    private static final Logger log = LoggerFactory.getLogger(ActionLight.class);

    public ActionLight(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLight copy = new ActionLight(sysName, userName);
        copy.setComment(this.getComment());
        if (this._lightHandle != null) {
            copy.setLight(this._lightHandle);
        }
        copy.setBeanState(this._lightState);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setStateAddressing(this._stateAddressing);
        copy.setStateFormula(this._stateFormula);
        copy.setStateLocalVariable(this._stateLocalVariable);
        copy.setStateReference(this._stateReference);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setLightValue(this._lightValue);
        return manager.registerAction(copy);
    }

    public void setLight(@Nonnull String lightName) {
        this.assertListenersAreNotRegistered(log, "setLight");
        Light light = InstanceManager.getDefault(LightManager.class).getLight(lightName);
        if (light != null) {
            this.setLight(light);
        } else {
            this.removeLight();
            log.warn("light \"{}\" is not found", (Object)lightName);
        }
    }

    public void setLight(@Nonnull NamedBeanHandle<Light> handle) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this._lightHandle = handle;
        InstanceManager.lightManagerInstance().addVetoableChangeListener(this);
    }

    public void setLight(@Nonnull Light light) {
        this.assertListenersAreNotRegistered(log, "setLight");
        this.setLight(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(light.getDisplayName(), light));
    }

    public void removeLight() {
        this.assertListenersAreNotRegistered(log, "setLight");
        if (this._lightHandle != null) {
            InstanceManager.lightManagerInstance().removeVetoableChangeListener(this);
            this._lightHandle = null;
        }
    }

    public NamedBeanHandle<Light> getLight() {
        return this._lightHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setStateAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._stateAddressing = addressing;
        this.parseStateFormula();
    }

    public NamedBeanAddressing getStateAddressing() {
        return this._stateAddressing;
    }

    public void setBeanState(LightState state) {
        this._lightState = state;
    }

    public LightState getBeanState() {
        return this._lightState;
    }

    public void setStateReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._stateReference = reference;
    }

    public String getStateReference() {
        return this._stateReference;
    }

    public void setStateLocalVariable(@Nonnull String localVariable) {
        this._stateLocalVariable = localVariable;
    }

    public String getStateLocalVariable() {
        return this._stateLocalVariable;
    }

    public void setStateFormula(@Nonnull String formula) throws ParserException {
        this._stateFormula = formula;
        this.parseStateFormula();
    }

    public String getStateFormula() {
        return this._stateFormula;
    }

    private void parseStateFormula() throws ParserException {
        if (this._stateAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._stateExpressionNode = parser.parseExpression(this._stateFormula);
        } else {
            this._stateExpressionNode = null;
        }
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setLightValue(int value) {
        this._lightValue = value;
    }

    public int getLightValue() {
        return this._lightValue;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Light && evt.getOldValue().equals(this.getLight().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("Light_LightInUseLightActionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Light && evt.getOldValue().equals(this.getLight().getBean())) {
            this.removeLight();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewState() throws JmriException {
        switch (this._stateAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._stateReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._stateLocalVariable), false);
            }
            case Formula: {
                return this._stateExpressionNode != null ? TypeConversionUtil.convertToString(this._stateExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._stateAddressing.name());
    }

    private int getNewData() throws JmriException {
        String newValue = "";
        switch (this._dataAddressing) {
            case Direct: {
                return this._lightValue;
            }
            case Reference: {
                newValue = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                newValue = TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
                break;
            }
            case Formula: {
                newValue = this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._dataAddressing.name());
            }
        }
        try {
            int newInt = Integer.parseInt(newValue);
            if (newInt < 0) {
                newInt = 0;
            }
            if (newInt > 100) {
                newInt = 100;
            }
            return newInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public void execute() throws JmriException {
        Light light;
        switch (this._addressing) {
            case Direct: {
                light = this._lightHandle != null ? this._lightHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                light = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                light = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                light = this._expressionNode != null ? (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (light == null) {
            return;
        }
        String name = this._stateAddressing != NamedBeanAddressing.Direct ? this.getNewState() : null;
        LightState state = this._stateAddressing == NamedBeanAddressing.Direct ? this._lightState : LightState.valueOf(name);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (state == LightState.Toggle) {
                if (light.getKnownState() == 2) {
                    light.setCommandedState(4);
                } else {
                    light.setCommandedState(2);
                }
            } else if (state == LightState.Intensity) {
                if (light instanceof VariableLight) {
                    ((VariableLight)light).setTargetIntensity((double)this.getNewData() / 100.0);
                } else {
                    light.setCommandedState(this.getNewData() > 50 ? 2 : 4);
                }
            } else if (state == LightState.Interval) {
                if (light instanceof VariableLight) {
                    ((VariableLight)light).setTransitionTime(this.getNewData());
                }
            } else {
                light.setCommandedState(state.getID());
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Light_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String lightName = this._lightHandle != null ? this._lightHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", lightName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._stateAddressing) {
            case Direct: {
                if (this._lightState == LightState.Intensity || this._lightState == LightState.Interval) {
                    String bundleKey = "Light_Long_Value";
                    switch (this._dataAddressing) {
                        case Direct: {
                            String type = this._lightState == LightState.Intensity ? Bundle.getMessage("Light_Intensity_Value") : Bundle.getMessage("Light_Interval_Value");
                            return Bundle.getMessage(locale, bundleKey, namedBean, type, this._lightValue);
                        }
                        case Reference: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByReference", this._dataReference));
                        }
                        case LocalVariable: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
                        }
                        case Formula: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByFormula", this._dataFormula));
                        }
                    }
                    throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
                }
                state = Bundle.getMessage(locale, "AddressByDirect", this._lightState._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._stateReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._stateLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._stateFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._stateAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "Light_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionLight: bean = {}, report = {}", (Object)cdl, report);
        if (this.getLight() != null && bean.equals(this.getLight().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum LightState {
        Off(4, Bundle.getMessage("StateOff")),
        On(2, Bundle.getMessage("StateOn")),
        Toggle(-1, Bundle.getMessage("LightToggleStatus")),
        Intensity(-2, Bundle.getMessage("LightIntensity")),
        Interval(-3, Bundle.getMessage("LightInterval")),
        Unknown(1, Bundle.getMessage("BeanStateUnknown")),
        Inconsistent(8, Bundle.getMessage("BeanStateInconsistent"));

        private final int _id;
        private final String _text;

        private LightState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static LightState get(int id) {
            switch (id) {
                case 1: {
                    return Unknown;
                }
                case 8: {
                    return Inconsistent;
                }
                case 4: {
                    return Off;
                }
                case 2: {
                    return On;
                }
                case -1: {
                    return Toggle;
                }
            }
            throw new IllegalArgumentException("invalid light state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

