/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LogixManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionEntryExit
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<DestinationPoints> _destinationPointsHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private Operation _operationDirect = Operation.SetNXPairEnabled;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ActionEntryExit.class);

    public ActionEntryExit(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionEntryExit copy = new ActionEntryExit(sysName, userName);
        copy.setComment(this.getComment());
        if (this._destinationPointsHandle != null) {
            copy.setDestinationPoints(this._destinationPointsHandle);
        }
        copy.setOperationDirect(this._operationDirect);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        return manager.registerAction(copy);
    }

    public void setDestinationPoints(@Nonnull String entryExitName) {
        this.assertListenersAreNotRegistered(log, "setDestinationPoints");
        DestinationPoints entryExit = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(entryExitName);
        if (entryExit != null) {
            this.setDestinationPoints(entryExit);
        } else {
            this.removeDestinationPoints();
            log.error("DestinationPoints \"{}\" is not found", (Object)entryExitName);
        }
    }

    public void setDestinationPoints(@Nonnull NamedBeanHandle<DestinationPoints> handle) {
        this.assertListenersAreNotRegistered(log, "setDestinationPoints");
        this._destinationPointsHandle = handle;
        InstanceManager.getDefault(LogixManager.class).addVetoableChangeListener(this);
    }

    public void setDestinationPoints(@Nonnull DestinationPoints entryExit) {
        this.assertListenersAreNotRegistered(log, "setDestinationPoints");
        this.setDestinationPoints(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(entryExit.getDisplayName(), entryExit));
    }

    public void removeDestinationPoints() {
        this.assertListenersAreNotRegistered(log, "removeEntryExit");
        if (this._destinationPointsHandle != null) {
            InstanceManager.getDefault(LogixManager.class).removeVetoableChangeListener(this);
            this._destinationPointsHandle = null;
        }
    }

    public NamedBeanHandle<DestinationPoints> getDestinationPoints() {
        return this._destinationPointsHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseLockFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationDirect(Operation state) {
        this._operationDirect = state;
    }

    public Operation getOperationDirect() {
        return this._operationDirect;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseLockFormula();
    }

    public String getLockFormula() {
        return this._operationFormula;
    }

    private void parseLockFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof DestinationPoints && evt.getOldValue().equals(this.getDestinationPoints().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("ActionEntryExit_DestinationPointsInUseVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof DestinationPoints && evt.getOldValue().equals(this.getDestinationPoints().getBean())) {
            this.removeDestinationPoints();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewLock() throws JmriException {
        switch (this._operationAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        DestinationPoints entryExit;
        switch (this._addressing) {
            case Direct: {
                entryExit = this._destinationPointsHandle != null ? this._destinationPointsHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                entryExit = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                entryExit = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                entryExit = this._expressionNode != null ? InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (entryExit == null) {
            return;
        }
        String name = this._operationAddressing != NamedBeanAddressing.Direct ? this.getNewLock() : null;
        Operation oper = this._operationAddressing == NamedBeanAddressing.Direct ? this._operationDirect : Operation.valueOf(name);
        Operation theOper = oper;
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case SetNXPairEnabled: {
                    entryExit.setEnabled(true);
                    break;
                }
                case SetNXPairDisabled: {
                    entryExit.setEnabled(false);
                    break;
                }
                case SetNXPairSegment: {
                    InstanceManager.getDefault(EntryExitPairs.class).setSingleSegmentRoute(entryExit.getSystemName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionEntryExit_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String state;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String entryExitName = this._destinationPointsHandle != null ? this._destinationPointsHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", entryExitName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                state = Bundle.getMessage(locale, "AddressByDirect", this._operationDirect._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._operationAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionEntryExit_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionEntryExit: bean = {}, report = {}", (Object)cdl, report);
        if (this.getDestinationPoints() != null && bean.equals(this.getDestinationPoints().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum Operation {
        SetNXPairEnabled(Bundle.getMessage("ActionEntryExit_SetNXPairEnabled")),
        SetNXPairDisabled(Bundle.getMessage("ActionEntryExit_SetNXPairDisabled")),
        SetNXPairSegment(Bundle.getMessage("ActionEntryExit_SetNXPairSegment"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

