/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Timebase;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.util.ThreadingUtil;

public class ActionClock
extends AbstractDigitalAction {
    private ClockState _clockState = ClockState.SetClock;
    private int _clockTime = 0;

    public ActionClock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionClock copy = new ActionClock(sysName, userName);
        copy.setComment(this.getComment());
        copy.setBeanState(this._clockState);
        copy.setClockTime(this._clockTime);
        return manager.registerAction(copy);
    }

    public void setBeanState(ClockState state) {
        this._clockState = state;
    }

    public ClockState getBeanState() {
        return this._clockState;
    }

    public void setClockTime(int minutes) {
        this._clockTime = minutes;
    }

    public int getClockTime() {
        return this._clockTime;
    }

    public static String formatTime(int minutes) {
        String hhmm = "00:00";
        if (minutes >= 0 && minutes < 1440) {
            hhmm = String.format("%02d:%02d", minutes / 60, minutes % 60);
        }
        return hhmm;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ClockState theState = this._clockState;
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theState) {
                case SetClock: {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(InstanceManager.getDefault(Timebase.class).getTime());
                    cal.set(11, this._clockTime / 60);
                    cal.set(12, this._clockTime % 60);
                    cal.set(13, 0);
                    InstanceManager.getDefault(Timebase.class).userSetTime(cal.getTime());
                    break;
                }
                case StartClock: {
                    InstanceManager.getDefault(Timebase.class).setRun(true);
                    break;
                }
                case StopClock: {
                    InstanceManager.getDefault(Timebase.class).setRun(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid clock state: " + theState.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionClock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this.getBeanState() == ClockState.SetClock) {
            return Bundle.getMessage(locale, "ActionClock_LongTime", this._clockState._text, ActionClock.formatTime(this.getClockTime()));
        }
        return Bundle.getMessage(locale, "ActionClock_Long", this._clockState._text);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum ClockState {
        SetClock(Bundle.getMessage("ActionClock_SetClock")),
        StartClock(Bundle.getMessage("ActionClock_StartClock")),
        StopClock(Bundle.getMessage("ActionClock_StopClock"));

        private final String _text;

        private ClockState(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

