/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionBlock
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Block> _blockHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private DirectOperation _operationDirect = DirectOperation.SetOccupied;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private String _blockValue = "";
    private static final Logger log = LoggerFactory.getLogger(ActionBlock.class);

    public ActionBlock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionBlock copy = new ActionBlock(sysName, userName);
        copy.setComment(this.getComment());
        copy.setAddressing(this._addressing);
        if (this._blockHandle != null) {
            copy.setBlock(this._blockHandle);
        }
        copy.setReference(this._reference);
        copy.setLocalVariable(this._localVariable);
        copy.setFormula(this._formula);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationDirect(this._operationDirect);
        copy.setOperationReference(this._operationReference);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationFormula(this._operationFormula);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setBlockValue(this._blockValue);
        return manager.registerAction(copy);
    }

    public void setBlock(@Nonnull String blockName) {
        this.assertListenersAreNotRegistered(log, "setBlock");
        Block block = (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(blockName);
        if (block != null) {
            this.setBlock(block);
        } else {
            this.removeBlock();
            log.error("Block \"{}\" is not found", (Object)blockName);
        }
    }

    public void setBlock(@Nonnull Block block) {
        this.assertListenersAreNotRegistered(log, "setBlock");
        this.setBlock(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(block.getDisplayName(), block));
    }

    public void setBlock(@Nonnull NamedBeanHandle<Block> handle) {
        this.assertListenersAreNotRegistered(log, "setBlock");
        this._blockHandle = handle;
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
    }

    public void removeBlock() {
        this.assertListenersAreNotRegistered(log, "removeBlock");
        if (this._blockHandle != null) {
            InstanceManager.getDefault(BlockManager.class).removeVetoableChangeListener(this);
            this._blockHandle = null;
        }
    }

    public NamedBeanHandle<Block> getBlock() {
        return this._blockHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationDirect(DirectOperation state) {
        this._operationDirect = state;
    }

    public DirectOperation getOperationDirect() {
        return this._operationDirect;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setBlockValue(@Nonnull String value) {
        this._blockValue = value;
    }

    public String getBlockValue() {
        return this._blockValue;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Block && evt.getOldValue().equals(this.getBlock().getBean())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("ActionBlock_BlockInUseVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewOperation() throws JmriException {
        switch (this._operationAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    private String getNewData() throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                return this._blockValue;
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
            }
            case Formula: {
                return this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._dataAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Block block;
        switch (this._addressing) {
            case Direct: {
                block = this._blockHandle != null ? this._blockHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                block = (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                block = (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                block = this._expressionNode != null ? (Block)InstanceManager.getDefault(BlockManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (block == null) {
            return;
        }
        String name = this._operationAddressing != NamedBeanAddressing.Direct ? this.getNewOperation() : null;
        DirectOperation oper = this._operationAddressing == NamedBeanAddressing.Direct ? this._operationDirect : DirectOperation.valueOf(name);
        DirectOperation theOper = oper;
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case SetOccupied: {
                    Sensor sensor = block.getSensor();
                    if (sensor != null) {
                        try {
                            sensor.setKnownState(2);
                        }
                        catch (JmriException jmriException) {
                            log.debug("Exception setting sensor active");
                        }
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorSensor", block.getDisplayName()));
                }
                case SetNotOccupied: {
                    Sensor sensor = block.getSensor();
                    if (sensor != null) {
                        try {
                            sensor.setKnownState(4);
                        }
                        catch (JmriException jmriException) {
                            log.debug("Exception setting sensor inactive");
                        }
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorSensor", block.getDisplayName()));
                }
                case SetAltColorOn: {
                    LayoutBlock lblk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                    if (lblk != null) {
                        lblk.setUseExtraColor(true);
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorLayoutBlock", block.getDisplayName()));
                }
                case SetAltColorOff: {
                    LayoutBlock lblk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                    if (lblk != null) {
                        lblk.setUseExtraColor(false);
                        break;
                    }
                    throw new JmriException(Bundle.getMessage("ActionBlock_ErrorLayoutBlock", block.getDisplayName()));
                }
                case SetNullValue: {
                    block.setValue(null);
                    break;
                }
                case SetValue: {
                    block.setValue(this.getNewData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionBlock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean;
        String state = "";
        switch (this._addressing) {
            case Direct: {
                String blockName = this._blockHandle != null ? this._blockHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", blockName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                if (this._operationDirect == DirectOperation.SetValue) {
                    String bundleKey = "ActionBlock_Long_Value";
                    switch (this._dataAddressing) {
                        case Direct: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, this._blockValue);
                        }
                        case Reference: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByReference", this._dataReference));
                        }
                        case LocalVariable: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
                        }
                        case Formula: {
                            return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByFormula", this._dataFormula));
                        }
                    }
                    throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
                }
                state = Bundle.getMessage(locale, "AddressByDirect", this._operationDirect._text);
                break;
            }
            case Reference: {
                state = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                state = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                state = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._operationAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionBlock_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionBlock: bean = {}, report = {}", (Object)cdl, report);
        if (this.getBlock() != null && bean.equals(this.getBlock().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum DirectOperation {
        SetOccupied(Bundle.getMessage("ActionBlock_SetOccupied")),
        SetNotOccupied(Bundle.getMessage("ActionBlock_SetNotOccupied")),
        SetAltColorOn(Bundle.getMessage("ActionBlock_SetAltColorOn")),
        SetAltColorOff(Bundle.getMessage("ActionBlock_SetAltColorOff")),
        SetNullValue(Bundle.getMessage("ActionBlock_SetNullValue")),
        SetValue(Bundle.getMessage("ActionBlock_SetValue"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

