/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionAudio
extends AbstractDigitalAction
implements VetoableChangeListener {
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<Audio> _audioHandle;
    private String _reference = "";
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private Operation _operation = Operation.Play;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ActionAudio.class);

    public ActionAudio(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionAudio copy = new ActionAudio(sysName, userName);
        copy.setComment(this.getComment());
        if (this._audioHandle != null) {
            copy.setAudio(this._audioHandle);
        }
        copy.setOperation(this._operation);
        copy.setAddressing(this._addressing);
        copy.setFormula(this._formula);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        return manager.registerAction(copy);
    }

    public void setAudio(@Nonnull String audioName) {
        this.assertListenersAreNotRegistered(log, "setAudio");
        Audio audio = InstanceManager.getDefault(AudioManager.class).getAudio(audioName);
        if (audio != null) {
            this.setAudio(audio);
        } else {
            this.removeAudio();
            log.warn("audio \"{}\" is not found", (Object)audioName);
        }
    }

    public void setAudio(@Nonnull NamedBeanHandle<Audio> handle) {
        this.assertListenersAreNotRegistered(log, "setAudio");
        this._audioHandle = handle;
        InstanceManager.getDefault(AudioManager.class).addVetoableChangeListener(this);
    }

    public void setAudio(@Nonnull Audio audio) {
        this.assertListenersAreNotRegistered(log, "setAudio");
        this.setAudio(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(audio.getDisplayName(), audio));
    }

    public void removeAudio() {
        this.assertListenersAreNotRegistered(log, "setAudio");
        if (this._audioHandle != null) {
            InstanceManager.getDefault(AudioManager.class).removeVetoableChangeListener(this);
            this._audioHandle = null;
        }
    }

    public NamedBeanHandle<Audio> getAudio() {
        return this._audioHandle;
    }

    public void setAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperation(Operation state) {
        this._operation = state;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Audio && evt.getOldValue().equals(this.getAudio().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("Audio_AudioInUseAudioActionVeto", this.getDisplayName()), e);
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Audio && evt.getOldValue().equals(this.getAudio().getBean())) {
            this.removeAudio();
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewState() throws JmriException {
        switch (this._operationAddressing) {
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._operationReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
            }
            case Formula: {
                return this._operationExpressionNode != null ? TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Audio audio;
        switch (this._addressing) {
            case Direct: {
                audio = this._audioHandle != null ? this._audioHandle.getBean() : null;
                break;
            }
            case Reference: {
                String ref = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._reference);
                audio = (Audio)InstanceManager.getDefault(AudioManager.class).getNamedBean(ref);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                audio = (Audio)InstanceManager.getDefault(AudioManager.class).getNamedBean(TypeConversionUtil.convertToString(symbolTable.getValue(this._localVariable), false));
                break;
            }
            case Formula: {
                audio = this._expressionNode != null ? (Audio)InstanceManager.getDefault(AudioManager.class).getNamedBean(TypeConversionUtil.convertToString(this._expressionNode.calculate(this.getConditionalNG().getSymbolTable()), false)) : null;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        if (audio == null) {
            return;
        }
        String name = this._operationAddressing != NamedBeanAddressing.Direct ? this.getNewState() : null;
        Operation operation = this._operationAddressing == NamedBeanAddressing.Direct ? this._operation : Operation.valueOf(name);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (audio.getSubType() == 'S') {
                AudioSource audioSource = (AudioSource)audio;
                switch (operation) {
                    case Play: {
                        audioSource.play();
                        break;
                    }
                    case Stop: {
                        audioSource.stop();
                        break;
                    }
                    case PlayToggle: {
                        audioSource.togglePlay();
                        break;
                    }
                    case Pause: {
                        audioSource.pause();
                        break;
                    }
                    case Resume: {
                        audioSource.resume();
                        break;
                    }
                    case PauseToggle: {
                        audioSource.togglePause();
                        break;
                    }
                    case Rewind: {
                        audioSource.rewind();
                        break;
                    }
                    case FadeIn: {
                        audioSource.fadeIn();
                        break;
                    }
                    case FadeOut: {
                        audioSource.fadeOut();
                        break;
                    }
                    case ResetPosition: {
                        audioSource.resetCurrentPosition();
                        break;
                    }
                }
            } else if (audio.getSubType() == 'L') {
                AudioListener audioListener = (AudioListener)audio;
                switch (operation) {
                    case ResetPosition: {
                        audioListener.resetCurrentPosition();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionAudio_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String operation;
        String namedBean;
        switch (this._addressing) {
            case Direct: {
                String audioName = this._audioHandle != null ? this._audioHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", audioName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        switch (this._operationAddressing) {
            case Direct: {
                operation = Bundle.getMessage(locale, "AddressByDirect", this._operation._text);
                break;
            }
            case Reference: {
                operation = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                operation = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                operation = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._operationAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "ActionAudio_Long", operation, namedBean);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionAudio: bean = {}, report = {}", (Object)cdl, report);
        if (this.getAudio() != null && bean.equals(this.getAudio().getBean())) {
            report.add(new NamedBeanUsageReport("LogixNGAction", cdl, this.getLongDescription()));
        }
    }

    public static enum Operation {
        Play(Bundle.getMessage("ActionAudio_Operation_Play")),
        PlayToggle(Bundle.getMessage("ActionAudio_Operation_PlayToggle")),
        Pause(Bundle.getMessage("ActionAudio_Operation_Pause")),
        PauseToggle(Bundle.getMessage("ActionAudio_Operation_PauseToggle")),
        Resume(Bundle.getMessage("ActionAudio_Operation_Resume")),
        Stop(Bundle.getMessage("ActionAudio_Operation_Stop")),
        FadeIn(Bundle.getMessage("ActionAudio_Operation_FadeIn")),
        FadeOut(Bundle.getMessage("ActionAudio_Operation_FadeOut")),
        Rewind(Bundle.getMessage("ActionAudio_Operation_Rewind")),
        ResetPosition(Bundle.getMessage("ActionAudio_Operation_ResetPosition"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

