/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionBean;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDigitalAction
extends AbstractBase
implements DigitalActionBean {
    private Base _parent = null;
    private int _state = 1;
    private static final Logger log = LoggerFactory.getLogger(AbstractDigitalAction.class);

    public AbstractDigitalAction(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(DigitalActionManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid: " + this.mSystemName);
        }
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
    }

    protected String getPreferredSocketPrefix() {
        return "A";
    }

    public String getNewSocketName() {
        String[] names = new String[this.getChildCount()];
        int i = 0;
        while (i < this.getChildCount()) {
            names[i] = this.getChild(i).getName();
            ++i;
        }
        return this.getNewSocketName(names);
    }

    public String getNewSocketName(String[] names) {
        String prefix = this.getPreferredSocketPrefix();
        int x = 1;
        while (x < 10000) {
            boolean validName = true;
            int i = 0;
            while (i < names.length) {
                String name = String.valueOf(prefix) + Integer.toString(x);
                if (name.equals(names[i])) {
                    validName = false;
                    break;
                }
                ++i;
            }
            if (validName) {
                return String.valueOf(prefix) + Integer.toString(x);
            }
            ++x;
        }
        throw new RuntimeException("Unable to find a new socket name");
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameDigitalAction");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in AbstractDigitalAction.");
        this._state = s;
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in AbstractDigitalAction.");
        return this._state;
    }
}

