/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.io.File;
import java.io.FileNotFoundException;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.jmrit.logixng.Bundle;

public interface Table {
    @CheckReturnValue
    default public Object getCell(int row) {
        return this.getCell(row, 1);
    }

    @CheckReturnValue
    public Object getCell(int var1, int var2);

    @CheckReturnValue
    default public Object getCell(@Nonnull String row) throws RowNotFoundException {
        return this.getCell(this.getRowNumber(row), 1);
    }

    default public Object getCell(@Nonnull String row, @Nonnull String column) throws RowNotFoundException, ColumnNotFoundException {
        return this.getCell(this.getRowNumber(row), this.getColumnNumber(column));
    }

    @CheckReturnValue
    public void setCell(Object var1, int var2, int var3);

    default public void setCell(Object value, String row) throws RowNotFoundException {
        this.setCell(value, this.getRowNumber(row), 1);
    }

    default public void setCell(Object value, String row, String column) throws RowNotFoundException, ColumnNotFoundException {
        this.setCell(value, this.getRowNumber(row), this.getColumnNumber(column));
    }

    public int numRows();

    public int numColumns();

    public int getRowNumber(String var1) throws RowNotFoundException;

    public int getColumnNumber(String var1) throws ColumnNotFoundException;

    public void storeTableAsCSV(@Nonnull File var1) throws FileNotFoundException;

    public void storeTableAsCSV(@Nonnull File var1, @CheckForNull String var2, @CheckForNull String var3) throws FileNotFoundException;

    public static class ColumnNotFoundException
    extends IllegalArgumentException {
        public ColumnNotFoundException(String name) {
            super(Bundle.getMessage("Table_ColumnNotFound", name));
        }

        public ColumnNotFoundException(String name, Throwable cause) {
            super(Bundle.getMessage("Table_ColumnNotFound", name), cause);
        }
    }

    public static class RowNotFoundException
    extends IllegalArgumentException {
        public RowNotFoundException(String name) {
            super(Bundle.getMessage("Table_RowNotFound", name));
        }

        public RowNotFoundException(String name, Throwable cause) {
            super(Bundle.getMessage("Table_RowNotFound", name), cause);
        }
    }
}

