/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.Bundle;
import jmri.jmrit.logixng.Stack;

public interface SymbolTable {
    public Map<String, Symbol> getSymbols();

    public Map<String, Object> getSymbolValues();

    public Object getValue(String var1);

    public boolean hasValue(String var1);

    public void setValue(String var1, Object var2);

    public void createSymbols(Collection<? extends VariableData> var1) throws JmriException;

    public void createSymbols(SymbolTable var1, Collection<? extends VariableData> var2) throws JmriException;

    public void removeSymbols(Collection<? extends VariableData> var1) throws JmriException;

    public void printSymbolTable(PrintWriter var1);

    public static boolean validateName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (!Character.isLetterOrDigit(name.charAt(i)) && name.charAt(i) != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Stack getStack();

    public static enum InitialValueType {
        None(Bundle.getMessage("InitialValueType_None"), true),
        Integer(Bundle.getMessage("InitialValueType_Integer"), true),
        FloatingNumber(Bundle.getMessage("InitialValueType_FloatingNumber"), true),
        String(Bundle.getMessage("InitialValueType_String"), true),
        Array(Bundle.getMessage("InitialValueType_Array"), false),
        Map(Bundle.getMessage("InitialValueType_Map"), false),
        LocalVariable(Bundle.getMessage("InitialValueType_LocalVariable"), true),
        Memory(Bundle.getMessage("InitialValueType_Memory"), true),
        Reference(Bundle.getMessage("InitialValueType_Reference"), true),
        Formula(Bundle.getMessage("InitialValueType_Formula"), true);

        private final String _descr;
        private final boolean _isValidAsParameter;

        private InitialValueType(String descr, boolean isValidAsParameter) {
            this._descr = descr;
            this._isValidAsParameter = isValidAsParameter;
        }

        public String toString() {
            return this._descr;
        }

        public boolean isValidAsParameter() {
            return this._isValidAsParameter;
        }
    }

    public static interface Symbol {
        public String getName();

        public int getIndex();
    }

    public static class SymbolNotFound
    extends IllegalArgumentException {
        public SymbolNotFound(String message) {
            super(message);
        }
    }

    public static class VariableData {
        public String _name;
        public InitialValueType _initialValueType = InitialValueType.None;
        public String _initialValueData;

        public VariableData(String name, InitialValueType initialValueType, String initialValueData) {
            this._name = name;
            if (initialValueType != null) {
                this._initialValueType = initialValueType;
            }
            this._initialValueData = initialValueData;
        }

        public VariableData(VariableData variableData) {
            this._name = variableData._name;
            this._initialValueType = variableData._initialValueType;
            this._initialValueData = variableData._initialValueData;
        }

        public String getName() {
            return this._name;
        }

        public InitialValueType getInitialValueType() {
            return this._initialValueType;
        }

        public String getInitialValueData() {
            return this._initialValueData;
        }
    }
}

