/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import jmri.Manager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.FemaleSocketManager;
import jmri.jmrit.logixng.Module;
import org.apache.commons.lang3.mutable.MutableInt;

public interface ModuleManager
extends Manager<Module> {
    public Module createModule(String var1, String var2, FemaleSocketManager.SocketType var3) throws IllegalArgumentException;

    public Module createModule(String var1, FemaleSocketManager.SocketType var2) throws IllegalArgumentException;

    public Module getModule(String var1);

    @Override
    public Module getByUserName(String var1);

    @Override
    public Module getBySystemName(String var1);

    public String getAutoSystemName();

    public boolean resolveAllTrees(List<String> var1);

    public void setupAllModules();

    public void deleteModule(Module var1);

    public void printTree(Base.PrintTreeSettings var1, PrintWriter var2, String var3, MutableInt var4);

    public void printTree(Base.PrintTreeSettings var1, Locale var2, PrintWriter var3, String var4, MutableInt var5);

    public static Manager.NameValidity validSystemNameFormat(String subSystemNamePrefix, String systemName) {
        if (systemName.matches(String.valueOf(subSystemNamePrefix) + "(:AUTO:)?\\d+")) {
            return Manager.NameValidity.VALID;
        }
        if (systemName.matches(String.valueOf(subSystemNamePrefix) + "\\$.+")) {
            return Manager.NameValidity.VALID;
        }
        if (systemName.matches(String.valueOf(subSystemNamePrefix) + ":JMRI:.+")) {
            return Manager.NameValidity.VALID;
        }
        if (systemName.matches(String.valueOf(subSystemNamePrefix) + ":JMRI-LIB:.+")) {
            return Manager.NameValidity.VALID;
        }
        return Manager.NameValidity.INVALID;
    }

    @Override
    default public String getSubSystemNamePrefix() {
        return String.valueOf(this.getSystemNamePrefix()) + "M";
    }
}

