/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;

public interface FemaleSocket
extends Base {
    public void connect(MaleSocket var1) throws SocketAlreadyConnectedException;

    public void disconnect();

    default public boolean canDisconnect() {
        return true;
    }

    public MaleSocket getConnectedSocket();

    public boolean isConnected();

    public boolean isCompatible(MaleSocket var1);

    default public boolean validateName(String name) {
        return this.validateName(name, false);
    }

    public boolean validateName(String var1, boolean var2);

    default public void setName(String name) {
        this.setName(name, false);
    }

    public void setName(String var1, boolean var2);

    @CheckForNull
    public String getName();

    default public boolean isSocketOperationAllowed(FemaleSocketOperation oper) {
        Base parent = this.getParent();
        if (parent == null) {
            return false;
        }
        int i = 0;
        while (i < parent.getChildCount()) {
            if (parent.getChild(i) == this) {
                return parent.isSocketOperationAllowed(i, oper);
            }
            ++i;
        }
        throw new IllegalArgumentException("Invalid index");
    }

    default public void doSocketOperation(FemaleSocketOperation oper) {
        Base parent = this.getParent();
        int i = 0;
        while (i < parent.getChildCount()) {
            if (parent.getChild(i) == this) {
                parent.doSocketOperation(i, oper);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Invalid index");
    }

    public void setEnableListeners(boolean var1);

    public boolean getEnableListeners();

    default public boolean isAncestor(MaleSocket maleSocket) {
        Base base = maleSocket;
        while (base != null && base != this) {
            base = base.getParent();
        }
        return base == this;
    }

    public Map<Category, List<Class<? extends Base>>> getConnectableClasses();

    @Override
    default public void setup() {
        if (this.isConnected()) {
            this.getConnectedSocket().setup();
        }
    }
}

