/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.MaleSocket;
import org.apache.commons.lang3.mutable.MutableInt;

public interface Base
extends PropertyChangeProvider {
    public static final String PROPERTY_CHILD_COUNT = "ChildCount";
    public static final String PROPERTY_CHILD_REORDER = "ChildReorder";
    public static final String PROPERTY_SOCKET_CONNECTED = "SocketConnected";
    public static final String PROPERTY_SOCKET_DISCONNECTED = "SocketDisconnected";
    public static final String PROPERTY_LAST_RESULT_CHANGED = "LastResultChanged";
    public static final int SOCKET_CONNECTED = 2;
    public static final int SOCKET_DISCONNECTED = 4;
    public static final String PRINT_LINE_NUMBERS_FORMAT = "%8d:  ";

    public String getSystemName();

    @CheckReturnValue
    @CheckForNull
    public String getUserName();

    @CheckReturnValue
    @CheckForNull
    public String getComment();

    public void setUserName(@CheckForNull String var1) throws NamedBean.BadUserNameException;

    public Base getDeepCopy(Map<String, String> var1, Map<String, String> var2) throws JmriException;

    public Base deepCopyChildren(Base var1, Map<String, String> var2, Map<String, String> var3) throws JmriException;

    public void setComment(@CheckForNull String var1);

    default public String getShortDescription() {
        return this.getShortDescription(Locale.getDefault());
    }

    default public String getLongDescription() {
        return this.getLongDescription(Locale.getDefault());
    }

    public String getShortDescription(Locale var1);

    public String getLongDescription(Locale var1);

    public ConditionalNG getConditionalNG();

    public LogixNG getLogixNG();

    public Base getRoot();

    public Base getParent();

    public void setParent(Base var1);

    public boolean setParentForAllChildren(List<String> var1);

    public FemaleSocket getChild(int var1) throws IllegalArgumentException, UnsupportedOperationException;

    public int getChildCount();

    default public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        if (this instanceof MaleSocket) {
            return ((MaleSocket)this).getObject().isSocketOperationAllowed(index, oper);
        }
        return false;
    }

    default public void doSocketOperation(int index, FemaleSocketOperation oper) {
        if (this instanceof MaleSocket) {
            ((MaleSocket)this).getObject().doSocketOperation(index, oper);
        }
    }

    public Category getCategory();

    public boolean isActive();

    public void setup();

    public void dispose();

    default public boolean isEnabled() {
        return true;
    }

    public void registerListeners();

    public void unregisterListeners();

    default public void printTree(PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(new PrintTreeSettings(), writer, indent, lineNumber);
    }

    public void printTree(PrintTreeSettings var1, PrintWriter var2, String var3, MutableInt var4);

    default public void printTree(Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(new PrintTreeSettings(), locale, writer, indent, lineNumber);
    }

    public void printTree(PrintTreeSettings var1, Locale var2, PrintWriter var3, String var4, MutableInt var5);

    public void printTree(PrintTreeSettings var1, Locale var2, PrintWriter var3, String var4, String var5, MutableInt var6);

    public void getUsageTree(int var1, NamedBean var2, List<NamedBeanUsageReport> var3, NamedBean var4);

    public void getUsageDetail(int var1, NamedBean var2, List<NamedBeanUsageReport> var3, NamedBean var4);

    public void addPropertyChangeListener(@Nonnull PropertyChangeListener var1, String var2, String var3);

    public void addPropertyChangeListener(@Nonnull String var1, @Nonnull PropertyChangeListener var2, String var3, String var4);

    public void updateListenerRef(@Nonnull PropertyChangeListener var1, String var2);

    public void vetoableChange(@Nonnull PropertyChangeEvent var1) throws PropertyVetoException;

    @CheckReturnValue
    public String getListenerRef(@Nonnull PropertyChangeListener var1);

    @CheckReturnValue
    public ArrayList<String> getListenerRefs();

    @CheckReturnValue
    public void getListenerRefsIncludingChildren(List<String> var1);

    @CheckReturnValue
    public int getNumPropertyChangeListeners();

    @CheckReturnValue
    @Nonnull
    public PropertyChangeListener[] getPropertyChangeListenersByReference(@Nonnull String var1);

    default public void forEntireTree(RunnableWithBase r) {
        r.run(this);
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChild(i).forEntireTree(r);
            ++i;
        }
    }

    public static class PrintTreeSettings {
        public boolean _printLineNumbers = false;
        public boolean _printErrorHandling = true;
        public boolean _printNotConnectedSockets = true;
        public boolean _printLocalVariables = true;
    }

    public static interface RunnableWithBase {
        public void run(@Nonnull Base var1);
    }
}

