/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.SpeedStepMode;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.SCWarrant;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantManagerXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(WarrantManagerXml.class);

    @Override
    public Element store(Object o) {
        Element warrants = new Element("warrants");
        warrants.setAttribute("class", "jmri.jmrit.logix.configurexml.WarrantManagerXml");
        WarrantManager wm = (WarrantManager)o;
        if (wm != null) {
            SortedSet warrantList = wm.getNamedBeanSet();
            if (warrantList.isEmpty()) {
                return null;
            }
            for (Warrant warrant : warrantList) {
                BlockOrder avoidOrder;
                List<BlockOrder> orders;
                String sName = warrant.getSystemName();
                String uName = warrant.getUserName();
                log.debug("Warrant: sysName= {}, userName= {}", (Object)sName, (Object)uName);
                Element elem = new Element("warrant");
                elem.setAttribute("systemName", sName);
                if (uName == null) {
                    uName = "";
                }
                if (uName.length() > 0) {
                    elem.setAttribute("userName", uName);
                }
                if (warrant instanceof SCWarrant) {
                    elem.setAttribute("wtype", "SC");
                    elem.setAttribute("speedFactor", "" + ((SCWarrant)warrant).getSpeedFactor());
                    elem.setAttribute("timeToPlatform", "" + ((SCWarrant)warrant).getTimeToPlatform());
                    elem.setAttribute("forward", ((SCWarrant)warrant).getForward() ? "true" : "false");
                } else {
                    elem.setAttribute("wtype", "normal");
                }
                String comment = warrant.getComment();
                if (comment != null) {
                    Element c = new Element("comment");
                    c.addContent(comment);
                    elem.addContent((Content)c);
                }
                if ((orders = warrant.getBlockOrders()) == null) {
                    log.error("Warrant {} has no Route defined. (no BlockOrders) Cannot store.", (Object)warrant.getDisplayName());
                    continue;
                }
                for (BlockOrder bo : orders) {
                    elem.addContent((Content)WarrantManagerXml.storeOrder(bo, "blockOrder"));
                }
                BlockOrder viaOrder = warrant.getViaOrder();
                if (viaOrder != null) {
                    elem.addContent((Content)WarrantManagerXml.storeOrder(viaOrder, "viaOrder"));
                }
                if ((avoidOrder = warrant.getAvoidOrder()) != null) {
                    elem.addContent((Content)WarrantManagerXml.storeOrder(avoidOrder, "avoidOrder"));
                }
                List<ThrottleSetting> throttleCmds = warrant.getThrottleCommands();
                for (ThrottleSetting ts : throttleCmds) {
                    elem.addContent((Content)WarrantManagerXml.storeThrottleSetting(ts));
                }
                elem.addContent((Content)WarrantManagerXml.storeTrain(warrant, "train"));
                warrants.addContent((Content)elem);
            }
        }
        return warrants;
    }

    private static Element storeTrain(Warrant warrant, String type) {
        Element elem = new Element(type);
        SpeedUtil speedUtil = warrant.getSpeedUtil();
        String str = speedUtil.getRosterId();
        if (str == null) {
            str = "";
        }
        elem.setAttribute("trainId", str);
        DccLocoAddress addr = speedUtil.getDccAddress();
        if (addr != null) {
            elem.setAttribute("dccAddress", "" + addr.getNumber());
            elem.setAttribute("dccType", addr.getProtocol().getShortName());
        }
        elem.setAttribute("runBlind", warrant.getRunBlind() ? "true" : "false");
        elem.setAttribute("shareRoute", warrant.getShareRoute() ? "true" : "false");
        elem.setAttribute("noRamp", warrant.getNoRamp() ? "true" : "false");
        str = warrant.getTrainName();
        if (str == null) {
            str = "";
        }
        elem.setAttribute("trainName", str);
        return elem;
    }

    private static Element storeOrder(BlockOrder order, String type) {
        Element elem = new Element(type);
        OBlock block = order.getBlock();
        if (block != null) {
            Element blk = new Element("block");
            blk.setAttribute("systemName", block.getSystemName());
            String uname = block.getUserName();
            if (uname == null) {
                uname = "";
            }
            if (uname.length() > 0) {
                blk.setAttribute("userName", uname);
            }
            elem.addContent((Content)blk);
        } else {
            log.error("Null block in BlockOrder!");
        }
        String str = order.getPathName();
        if (str == null) {
            str = "";
        }
        elem.setAttribute("pathName", str);
        str = order.getEntryName();
        if (str == null) {
            str = "";
        }
        elem.setAttribute("entryName", str);
        str = order.getExitName();
        if (str == null) {
            str = "";
        }
        elem.setAttribute("exitName", str);
        return elem;
    }

    private static Element storeThrottleSetting(ThrottleSetting ts) {
        Element element = new Element("throttleSetting");
        element.setAttribute("elapsedTime", String.valueOf(ts.getTime()));
        String name = ts.getBeanSystemName();
        if (name != null) {
            element.setAttribute("beanName", name);
        } else {
            element.setAttribute("beanName", "");
        }
        element.setAttribute("trackSpeed", String.valueOf(ts.getTrackSpeed()));
        Element elem = new Element("command");
        ThrottleSetting.Command cmd = ts.getCommand();
        elem.setAttribute("commandType", String.valueOf(cmd.getIntId()));
        elem.setAttribute("fKey", String.valueOf(ts.getKeyNum()));
        element.addContent((Content)elem);
        elem = new Element("commandValue");
        ThrottleSetting.CommandValue cmdVal = ts.getValue();
        elem.setAttribute("valueType", String.valueOf(cmdVal.getType().getIntId()));
        elem.setAttribute("speedMode", cmdVal.getMode().name);
        elem.setAttribute("floatValue", String.valueOf(cmdVal.getFloat()));
        element.addContent((Content)elem);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sysName;
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        if (shared.getChildren().isEmpty()) {
            return true;
        }
        List warrantList = shared.getChildren("warrant");
        log.debug("Found {} Warrant objects", (Object)warrantList.size());
        boolean previouslyLoaded = false;
        for (Element elem : warrantList) {
            Element train;
            Element order;
            Warrant warrant;
            if (elem.getAttribute("systemName") == null) {
                log.warn("unexpected null for systemName in elem {}", (Object)elem);
                break;
            }
            sysName = null;
            if (elem.getAttribute("systemName") != null) {
                sysName = elem.getAttribute("systemName").getValue();
            }
            String userName = null;
            if (elem.getAttribute("userName") != null) {
                userName = elem.getAttribute("userName").getValue();
            }
            boolean SCWa = true;
            log.debug("loading warrant {}", (Object)sysName);
            Attribute wType = elem.getAttribute("wtype");
            if (wType == null) {
                log.debug("wtype is null for {}", (Object)sysName);
                SCWa = false;
            } else if (!wType.getValue().equals("SC")) {
                log.debug("wtype is {} for {}", (Object)wType.getValue(), (Object)sysName);
                SCWa = false;
            }
            long timeToPlatform = 500L;
            Attribute TTP = elem.getAttribute("timeToPlatform");
            if (TTP != null) {
                try {
                    timeToPlatform = TTP.getLongValue();
                }
                catch (DataConversionException e2) {
                    log.debug("ignoring DataConversionException (and reverting to default value): {}", (Object)e2.toString());
                }
            }
            if ((warrant = manager.createNewWarrant(sysName, userName, SCWa, timeToPlatform)) == null) {
                log.info("Warrant \"{}\" (userName={}) previously loaded. This version not loaded.", (Object)sysName, (Object)userName);
                previouslyLoaded = true;
                continue;
            }
            previouslyLoaded = false;
            if (SCWa && warrant instanceof SCWarrant) {
                if (elem.getAttribute("forward") != null) {
                    ((SCWarrant)warrant).setForward(elem.getAttribute("forward").getValue().equals("true"));
                }
                if (elem.getAttribute("speedFactor") != null) {
                    try {
                        ((SCWarrant)warrant).setSpeedFactor(elem.getAttribute("speedFactor").getFloatValue());
                    }
                    catch (DataConversionException dataConversionException) {
                        log.warn("error converting speed value");
                    }
                }
                warrant.setNoRamp(SCWa);
                warrant.setShareRoute(SCWa);
            }
            List orders = elem.getChildren("blockOrder");
            for (Element ord : orders) {
                BlockOrder bo = WarrantManagerXml.loadBlockOrder(ord);
                if (bo == null) {
                    log.error("Bad BlockOrder in warrant \"{}\".", (Object)warrant.getDisplayName());
                    continue;
                }
                warrant.addBlockOrder(bo);
            }
            String c = elem.getChildText("comment");
            if (c != null) {
                warrant.setComment(c);
            }
            if ((order = elem.getChild("viaOrder")) != null) {
                warrant.setViaOrder(WarrantManagerXml.loadBlockOrder(order));
            }
            if ((order = elem.getChild("avoidOrder")) != null) {
                warrant.setAvoidOrder(WarrantManagerXml.loadBlockOrder(order));
            }
            if (SCWa) {
                boolean forward = true;
                if (elem.getAttribute("forward") != null) {
                    forward = elem.getAttribute("forward").getValue().equals("true");
                }
                if (warrant instanceof SCWarrant) {
                    ((SCWarrant)warrant).setForward(forward);
                }
                warrant.setNoRamp(SCWa);
                warrant.setShareRoute(SCWa);
            }
            if ((train = elem.getChild("train")) == null) continue;
            WarrantManagerXml.loadTrain(train, warrant);
        }
        if (!previouslyLoaded) {
            warrantList = shared.getChildren("warrant");
            for (Element elem : warrantList) {
                Warrant warrant;
                if (elem.getAttribute("systemName") == null) break;
                if (elem.getAttribute("systemName") == null || (sysName = elem.getAttribute("systemName").getValue()) == null || (warrant = (Warrant)manager.getBySystemName(sysName)) == null) continue;
                log.debug("warrant: {}", (Object)warrant.getDisplayName());
                List throttleCmds = elem.getChildren("throttleCommand");
                if (throttleCmds != null && !throttleCmds.isEmpty()) {
                    log.debug("throttleCommand size= {}", (Object)throttleCmds.size());
                    throttleCmds.forEach(e -> warrant.addThrottleCommand(WarrantManagerXml.loadThrottleCommand(e, warrant)));
                    warrant.setTrackSpeeds();
                    continue;
                }
                throttleCmds = elem.getChildren("throttleSetting");
                if (throttleCmds == null) continue;
                log.debug("throttleSetting size= {}", (Object)throttleCmds.size());
                throttleCmds.forEach(e -> warrant.addThrottleCommand(WarrantManagerXml.loadThrottleSetting(e, warrant)));
            }
        }
        return true;
    }

    private static void loadTrain(Element elem, Warrant warrant) {
        SpeedUtil speedUtil = warrant.getSpeedUtil();
        if (elem.getAttribute("trainId") != null) {
            speedUtil.setRosterId(elem.getAttribute("trainId").getValue());
        }
        if (speedUtil.getRosterEntry() == null && elem.getAttribute("dccAddress") != null) {
            try {
                int address = elem.getAttribute("dccAddress").getIntValue();
                String type = "L";
                if (elem.getAttribute("dccType") != null) {
                    type = elem.getAttribute("dccType").getValue();
                }
                if (!speedUtil.setDccAddress(address, type)) {
                    log.error("dccAddress {}, dccType {} in Warrant {}", new Object[]{address, type, warrant.getDisplayName()});
                }
            }
            catch (DataConversionException dce) {
                log.error("{} for dccAddress in Warrant {}", (Object)dce, (Object)warrant.getDisplayName());
            }
        }
        if (elem.getAttribute("runBlind") != null) {
            warrant.setRunBlind(elem.getAttribute("runBlind").getValue().equals("true"));
        }
        if (elem.getAttribute("shareRoute") != null) {
            warrant.setShareRoute(elem.getAttribute("shareRoute").getValue().equals("true"));
        }
        if (elem.getAttribute("noRamp") != null) {
            warrant.setNoRamp(elem.getAttribute("noRamp").getValue().equals("true"));
        }
        if (elem.getAttribute("trainName") != null) {
            warrant.setTrainName(elem.getAttribute("trainName").getValue());
        }
    }

    private static BlockOrder loadBlockOrder(Element elem) {
        OBlock block = null;
        List blocks = elem.getChildren("block");
        if (blocks.size() > 1) {
            log.error("More than one block present: {}", (Object)blocks.size());
        }
        if (blocks.size() > 0) {
            String name = ((Element)blocks.get(0)).getAttribute("systemName").getValue();
            block = InstanceManager.getDefault(OBlockManager.class).getOBlock(name);
            if (block == null) {
                log.error("No such Block \"{}\" found.", (Object)name);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Load Block {}.", (Object)name);
            }
        } else {
            log.error("Null BlockOrder element");
            return null;
        }
        Attribute attr = elem.getAttribute("pathName");
        String pathName = null;
        if (attr != null) {
            pathName = attr.getValue();
        }
        attr = elem.getAttribute("entryName");
        String entryName = null;
        if (attr != null) {
            entryName = attr.getValue();
        }
        attr = elem.getAttribute("exitName");
        String exitName = null;
        if (attr != null) {
            exitName = attr.getValue();
        }
        return new BlockOrder(block, pathName, entryName, exitName);
    }

    private static ThrottleSetting loadThrottleSetting(Element element, Warrant w) {
        String errMsg;
        ThrottleSetting ts = new ThrottleSetting();
        Attribute attr = element.getAttribute("elapsedTime");
        if (attr != null) {
            ts.setTime(Long.parseLong(attr.getValue()));
        }
        ThrottleSetting.Command cmd = null;
        Element elem = element.getChild("command");
        if (elem != null) {
            attr = elem.getAttribute("commandType");
            if (attr != null) {
                try {
                    cmd = ThrottleSetting.getCommandTypeFromInt(Integer.parseInt(attr.getValue()));
                    ts.setCommand(cmd);
                }
                catch (IllegalArgumentException iae) {
                    log.error("{} for {} in warrant {}", new Object[]{iae.getMessage(), ts.toString(), w.getDisplayName()});
                }
            } else {
                log.error("Command type is null for {} in warrant {}", (Object)ts.toString(), (Object)w.getDisplayName());
            }
            attr = elem.getAttribute("fKey");
            if (attr != null) {
                ts.setKeyNum(Integer.parseInt(attr.getValue()));
            }
        }
        elem = element.getChild("commandValue");
        ThrottleSetting.ValueType valType = null;
        SpeedStepMode mode = null;
        float floatVal = 0.0f;
        if (elem != null) {
            attr = elem.getAttribute("valueType");
            if (attr != null) {
                try {
                    valType = ThrottleSetting.getValueTypeFromInt(Integer.parseInt(attr.getValue()));
                }
                catch (IllegalArgumentException iae) {
                    log.error("{} for throttleSetting {} in warrant {}", new Object[]{iae.getMessage(), ts.toString(), w.getDisplayName()});
                }
            } else {
                log.error("Value type is null for {} in warrant {}", (Object)ts.toString(), (Object)w.getDisplayName());
            }
            attr = elem.getAttribute("speedMode");
            if (attr != null) {
                mode = SpeedStepMode.getByName(attr.getValue());
            }
            if ((attr = elem.getAttribute("floatValue")) != null) {
                floatVal = Float.parseFloat(attr.getValue());
            }
        }
        ts.setValue(valType, mode, floatVal);
        attr = element.getAttribute("trackSpeed");
        if (attr != null) {
            ts.setTrackSpeed(Float.parseFloat(attr.getValue()));
        }
        if ((attr = element.getAttribute("beanName")) != null && (errMsg = ts.setNamedBean(cmd, attr.getValue())) != null) {
            log.error("{} for {} in warrant {}", new Object[]{errMsg, ts.toString(), w.getDisplayName()});
        }
        return ts;
    }

    private static ThrottleSetting loadThrottleCommand(Element elem, Warrant w) {
        long time = 0L;
        try {
            time = elem.getAttribute("time").getLongValue();
        }
        catch (DataConversionException dataConversionException) {
            log.warn("error loading throttle command");
        }
        Attribute attr = elem.getAttribute("command");
        String command = null;
        if (attr == null) {
            log.error("Command type is null. ThrottleSetting not loaded for warrant {}", (Object)w.getDisplayName());
            return null;
        }
        command = attr.getValue();
        attr = elem.getAttribute("value");
        String value = null;
        if (attr != null) {
            value = attr.getValue();
        }
        attr = elem.getAttribute("block");
        String block = null;
        if (attr != null) {
            block = attr.getValue();
        }
        float speed = 0.0f;
        attr = elem.getAttribute("trackSpeed");
        if (attr != null) {
            try {
                speed = attr.getFloatValue();
            }
            catch (DataConversionException ex) {
                speed = 0.0f;
                log.error("Unable to read speed of command.", (Throwable)ex);
            }
        }
        return new ThrottleSetting(time, command, value, block, speed);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(WarrantManager.class).getXMLOrder();
    }
}

