/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix.configurexml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import jmri.BeanSetting;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Path;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Turnout;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.jmrit.logix.WarrantTableAction;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBlockManagerXml
extends AbstractXmlAdapter {
    private HashMap<String, OBlock> _blockMap;
    private HashMap<String, OPath> _pathMap;
    private OBlockManager _manager;
    private PortalManager _portalMgr;
    private static final Logger log = LoggerFactory.getLogger(OBlockManagerXml.class);

    @Override
    public Element store(Object o) {
        Element blocks = new Element("oblocks");
        blocks.setAttribute("class", "jmri.jmrit.logix.configurexml.OBlockManagerXml");
        OBlockManager obm = (OBlockManager)o;
        if (obm != null) {
            SortedSet oblockList = obm.getNamedBeanSet();
            if (oblockList.isEmpty()) {
                return null;
            }
            for (OBlock block : oblockList) {
                Element se;
                String comment;
                String sName = block.getSystemName();
                String uName = block.getUserName();
                log.debug("OBlock: sysName= {}, userName= {}", (Object)sName, (Object)uName);
                Element elem = new Element("oblock");
                elem.setAttribute("systemName", sName);
                if (uName != null && !uName.isEmpty()) {
                    elem.setAttribute("userName", uName);
                    elem.addContent((Content)new Element("userName").addContent(uName));
                }
                if ((comment = block.getComment()) != null && !comment.isEmpty()) {
                    Element c = new Element("comment");
                    c.addContent(comment);
                    elem.addContent((Content)c);
                }
                elem.setAttribute("length", "" + block.getLengthMm());
                elem.setAttribute("units", block.isMetric() ? "true" : "false");
                elem.setAttribute("curve", "" + block.getCurvature());
                if (block.getNamedSensor() != null) {
                    se = new Element("sensor");
                    se.setAttribute("systemName", block.getNamedSensor().getName());
                    elem.addContent((Content)se);
                }
                if (block.getNamedErrorSensor() != null) {
                    se = new Element("errorSensor");
                    se.setAttribute("systemName", block.getNamedErrorSensor().getName());
                    elem.addContent((Content)se);
                }
                if (block.getReporter() != null) {
                    se = new Element("reporter");
                    se.setAttribute("systemName", block.getReporter().getSystemName());
                    se.setAttribute("reportCurrent", block.isReportingCurrent() ? "true" : "false");
                    elem.addContent((Content)se);
                }
                elem.setAttribute("permissive", block.getPermissiveWorking() ? "true" : "false");
                elem.setAttribute("speedNotch", block.getBlockSpeed());
                List<Path> paths = block.getPaths();
                for (Path op : paths) {
                    if (!(op instanceof OPath)) continue;
                    elem.addContent((Content)OBlockManagerXml.storePath((OPath)op));
                }
                List<Portal> portals = block.getPortals();
                for (Portal po : portals) {
                    elem.addContent((Content)OBlockManagerXml.storePortal(po));
                }
                blocks.addContent((Content)elem);
            }
        }
        return blocks;
    }

    private static Element storePortal(Portal portal) {
        Element toElem;
        Element elem = new Element("portal");
        elem.setAttribute("portalName", portal.getName());
        OBlock block = portal.getFromBlock();
        if (block != null) {
            Element fromElem = new Element("fromBlock");
            fromElem.setAttribute("blockName", block.getSystemName());
            List<OPath> paths = portal.getFromPaths();
            if (paths != null) {
                for (OPath path : paths) {
                    fromElem.addContent((Content)OBlockManagerXml.storePathKey(path));
                }
            }
            elem.addContent((Content)fromElem);
        } else {
            log.error("Portal \"{}\" has no fromBlock!", (Object)portal.getName());
        }
        NamedBean signal = portal.getFromSignal();
        if (signal != null) {
            Element fromElem = new Element("fromSignal");
            fromElem.setAttribute("signalName", signal.getSystemName());
            fromElem.setAttribute("signalDelay", "" + portal.getFromSignalOffset());
            elem.addContent((Content)fromElem);
        }
        if ((block = portal.getToBlock()) != null) {
            toElem = new Element("toBlock");
            toElem.setAttribute("blockName", block.getSystemName());
            List<OPath> paths = portal.getToPaths();
            if (paths != null) {
                for (OPath path : paths) {
                    toElem.addContent((Content)OBlockManagerXml.storePathKey(path));
                }
            }
            elem.addContent((Content)toElem);
        } else {
            log.error("Portal \"{}\" has no toBlock!", (Object)portal.getName());
        }
        signal = portal.getToSignal();
        if (signal != null) {
            toElem = new Element("toSignal");
            toElem.setAttribute("signalName", signal.getSystemName());
            toElem.setAttribute("signalDelay", "" + portal.getToSignalOffset());
            elem.addContent((Content)toElem);
        }
        return elem;
    }

    private static Element storePathKey(OPath path) {
        Element elem = new Element("path");
        elem.setAttribute("pathName", path.getName());
        elem.setAttribute("blockName", path.getBlock().getSystemName());
        return elem;
    }

    private static Element storePath(OPath path) {
        Element elem = new Element("path");
        elem.setAttribute("pathName", path.getName());
        elem.setAttribute("blockName", path.getBlock().getSystemName());
        Portal portal = path.getFromPortal();
        if (portal != null) {
            elem.setAttribute("fromPortal", portal.getName());
        }
        if ((portal = path.getToPortal()) != null) {
            elem.setAttribute("toPortal", portal.getName());
        }
        List<BeanSetting> list = path.getSettings();
        for (BeanSetting bs : list) {
            Element e = new Element("setting");
            e.setAttribute("turnout", bs.getBeanName());
            e.setAttribute("set", "" + bs.getSetting());
            elem.addContent((Content)e);
        }
        elem.setAttribute("fromDirection", "" + path.getFromBlockDirection());
        elem.setAttribute("toDirection", "" + path.getToBlockDirection());
        elem.setAttribute("length", "" + path.getLength());
        return elem;
    }

    private OBlock getBlock(String sysName) {
        OBlock block = this._blockMap.get(sysName);
        if (block == null) {
            try {
                block = this._manager.provideOBlock(sysName);
                log.debug("found OBlock: ({}) {}", (Object)sysName, (Object)block);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                block = this._manager.createNewOBlock(sysName, null);
                log.debug("create OBlock: ({})", (Object)sysName);
            }
            this._blockMap.put(sysName, block);
        }
        return block;
    }

    private OPath getPath(OBlock block, String name) {
        String key = String.valueOf(block.getSystemName()) + name;
        OPath path = this._pathMap.get(key);
        if (path == null) {
            path = new OPath(block, name);
            this._pathMap.put(key, path);
            log.debug("create OPath: \"{}\" in block {}", (Object)name, (Object)block.getSystemName());
        }
        return path;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        this._blockMap = new HashMap();
        this._pathMap = new HashMap();
        this._manager = InstanceManager.getDefault(OBlockManager.class);
        this._portalMgr = InstanceManager.getDefault(PortalManager.class);
        List blockList = shared.getChildren("oblock");
        log.debug("Found {} OBlock objects", (Object)blockList.size());
        for (Element bl : blockList) {
            this.loadBlock(bl);
        }
        for (OBlock oblock : this._manager.getNamedBeanSet()) {
            WarrantTableAction.getDefault().checkSharedTurnouts(oblock);
        }
        return true;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("load called. Invalid method.");
    }

    private void loadBlock(Element elem) {
        Element reporter;
        Element errSensor;
        List sensors;
        if (elem.getAttribute("systemName") == null) {
            log.error("unexpected null for block systemName elem = {}", (Object)elem);
            return;
        }
        String systemName = elem.getAttribute("systemName").getValue();
        String userName = null;
        if (elem.getAttribute("userName") != null) {
            userName = elem.getAttribute("userName").getValue();
        }
        log.debug("Load block sysName= {}, userName= {}", (Object)systemName, (Object)userName);
        OBlock block = this.getBlock(systemName);
        block.setUserName(userName);
        String c = elem.getChildText("comment");
        if (c != null) {
            block.setComment(c);
        }
        if (elem.getAttribute("units") != null) {
            block.setMetricUnits(elem.getAttribute("units").getValue().equals("true"));
        } else {
            block.setMetricUnits(false);
        }
        if (elem.getAttribute("length") != null) {
            block.setLength(Float.parseFloat(elem.getAttribute("length").getValue()));
        }
        if (elem.getAttribute("curve") != null) {
            block.setCurvature(Integer.parseInt(elem.getAttribute("curve").getValue()));
        }
        if ((sensors = elem.getChildren("sensor")).size() > 1) {
            log.error("More than one sensor present: {}", (Object)sensors.size());
        }
        if (sensors.size() > 0) {
            String name = ((Element)sensors.get(0)).getAttribute("systemName").getValue();
            block.setSensor(name);
        }
        if ((errSensor = elem.getChild("errorSensor")) != null) {
            String name = errSensor.getAttribute("systemName").getValue();
            block.setErrorSensor(name);
        }
        if ((reporter = elem.getChild("reporter")) != null) {
            String name = reporter.getAttribute("systemName").getValue();
            try {
                Reporter rep = InstanceManager.getDefault(ReporterManager.class).getReporter(name);
                if (rep != null) {
                    block.setReporter(rep);
                }
            }
            catch (Exception ex) {
                log.error("No Reporter named \"{}\" found. threw exception: {}", (Object)name, (Object)ex);
            }
            if (reporter.getAttribute("reportCurrent") != null) {
                block.setReportingCurrent(reporter.getAttribute("reportCurrent").getValue().equals("true"));
            } else {
                block.setReportingCurrent(false);
            }
        }
        if (elem.getAttribute("permissive") != null) {
            block.setPermissiveWorking(elem.getAttribute("permissive").getValue().equals("true"));
        } else {
            block.setPermissiveWorking(false);
        }
        if (elem.getAttribute("speedNotch") != null) {
            try {
                block.setBlockSpeed(elem.getAttribute("speedNotch").getValue());
            }
            catch (JmriException ex) {
                JOptionPane.showMessageDialog(null, String.valueOf(ex.getMessage()) + "\n" + elem.getAttribute("speedNotch").getValue());
            }
        }
        List portals = elem.getChildren("portal");
        for (Element po : portals) {
            Portal portal = this.loadPortal(po);
            if (portal == null) continue;
            block.addPortal(portal);
        }
        List paths = elem.getChildren("path");
        for (Element pa : paths) {
            if (block.addPath(this.loadPath(pa, block))) continue;
            log.error("load: block \"{}\" failed to add path \"{}\" in block \"{}\"", new Object[]{systemName, pa.getName(), block.getSystemName()});
        }
    }

    private Portal loadPortal(Element elem) {
        Attribute attr;
        String name;
        String userName = elem.getAttribute("portalName").getValue();
        String fromBlockName = null;
        String toBlockName = null;
        Portal portal = this._portalMgr.getPortal(userName);
        if (portal != null) {
            OBlock block = portal.getFromBlock();
            if (block != null) {
                fromBlockName = block.getSystemName();
            }
            if ((block = portal.getToBlock()) != null) {
                toBlockName = block.getSystemName();
            }
        } else {
            portal = this._portalMgr.providePortal(userName);
        }
        if (portal == null) {
            log.error("unable to create Portal ({}) elem attrs= {}", (Object)userName, (Object)elem.getAttributes());
            return null;
        }
        log.debug("create Portal: ({})", (Object)userName);
        OBlock fromBlock = null;
        Element eFromBlk = elem.getChild("fromBlock");
        if (eFromBlk != null && eFromBlk.getAttribute("blockName") != null) {
            String name2 = eFromBlk.getAttribute("blockName").getValue();
            if (fromBlockName != null && !fromBlockName.equals(name2)) {
                log.error("Portal user name \"{}\" has conflicting fromBlock \"{}\". Should be \"{}\"", new Object[]{userName, fromBlockName, name2});
            } else {
                fromBlock = this.getBlock(name2);
                if (fromBlock != null) {
                    portal.setFromBlock(fromBlock, false);
                    fromBlock.addPortal(portal);
                    List ePathsFromBlock = eFromBlk.getChildren("path");
                    for (Element e : ePathsFromBlock) {
                        String pathName = e.getAttribute("pathName").getValue();
                        String blockName = e.getAttribute("blockName").getValue();
                        log.debug("Load portal= \"{}\" fromBlock= {}, pathName= {}, blockName= {}", new Object[]{userName, fromBlock.getSystemName(), pathName, blockName});
                        OPath path = this.getPath(fromBlock, pathName);
                        portal.addPath(path);
                    }
                }
            }
        } else {
            log.error("Portal \"{}\" has no fromBlock!", (Object)userName);
        }
        OBlock toBlock = null;
        Element eToBlk = elem.getChild("toBlock");
        if (eToBlk != null && eToBlk.getAttribute("blockName") != null) {
            String name3 = eToBlk.getAttribute("blockName").getValue();
            if (toBlockName != null && !toBlockName.equals(name3)) {
                log.error("Portal user name \"{}\" has conflicting toBlock \"{}\". Should be \"{}\"", new Object[]{userName, toBlockName, name3});
            } else {
                toBlock = this.getBlock(name3);
                if (toBlock != null) {
                    portal.setToBlock(toBlock, false);
                    toBlock.addPortal(portal);
                    List ePathsToBlock = eToBlk.getChildren("path");
                    for (Element ePath : ePathsToBlock) {
                        String pathName = ePath.getAttribute("pathName").getValue();
                        String blockName = ePath.getAttribute("blockName").getValue();
                        log.debug("Load portal= \"{}\" toBlock= {}, pathName= {}, blockName= {}", new Object[]{userName, toBlock.getSystemName(), pathName, blockName});
                        OPath path = this.getPath(toBlock, pathName);
                        portal.addPath(path);
                    }
                }
            }
        } else {
            log.error("Portal \"{}\" has no toBlock!", (Object)userName);
        }
        Element eSignal = elem.getChild("fromSignal");
        if (eSignal != null) {
            name = eSignal.getAttribute("signalName").getValue();
            float length = 0.0f;
            try {
                attr = eSignal.getAttribute("signalDelay");
                if (attr != null) {
                    length = attr.getFloatValue();
                }
            }
            catch (DataConversionException dataConversionException) {
                log.error("Could not parse signalDelay fromSignal ({}) in portal ({})", (Object)name, (Object)userName);
            }
            portal.setProtectSignal(Portal.getSignal(name), length, toBlock);
        }
        if ((eSignal = elem.getChild("toSignal")) != null) {
            name = eSignal.getAttribute("signalName").getValue();
            float length = 0.0f;
            try {
                attr = eSignal.getAttribute("signalDelay");
                if (attr != null) {
                    length = attr.getFloatValue();
                }
            }
            catch (DataConversionException dataConversionException) {
                log.error("Could not parse signalDelay toSignal ({}) in portal ({})", (Object)name, (Object)userName);
            }
            portal.setProtectSignal(Portal.getSignal(name), length, fromBlock);
        }
        log.debug("End Load portal {}", (Object)userName);
        return portal;
    }

    OPath loadPath(Element elem, OBlock block) {
        Portal portal;
        Attribute attr;
        String pName = elem.getAttribute("pathName").getValue();
        OPath path = this.getPath(block, pName);
        try {
            attr = elem.getAttribute("fromDirection");
            if (attr != null) {
                path.setFromBlockDirection(attr.getIntValue());
            }
            if ((attr = elem.getAttribute("toDirection")) != null) {
                path.setToBlockDirection(attr.getIntValue());
            }
            if ((attr = elem.getAttribute("length")) != null) {
                path.setLength(attr.getFloatValue());
            }
        }
        catch (DataConversionException dataConversionException) {
            log.error("Could not parse attribute of path \"{}\" in block \"{}\")", (Object)pName, (Object)block.getSystemName());
        }
        if ((attr = elem.getAttribute("fromPortal")) != null && (portal = this._portalMgr.providePortal(attr.getValue())) != null) {
            path.setFromPortal(portal);
            portal.addPath(path);
        }
        if ((attr = elem.getAttribute("toPortal")) != null && (portal = this._portalMgr.providePortal(attr.getValue())) != null) {
            path.setToPortal(portal);
            portal.addPath(path);
        }
        List settings = elem.getChildren("setting");
        log.debug("Path \"{}\" has {} settings.", (Object)pName, (Object)settings.size());
        HashSet<String> turnouts = new HashSet<String>();
        int dups = 0;
        for (Element setElem : settings) {
            int setting = 0;
            try {
                setting = setElem.getAttribute("set").getIntValue();
            }
            catch (DataConversionException dataConversionException) {
                log.error("Could not parse 'set' attribute for path path \"{}\" in block \"{}\"", (Object)pName, (Object)block.getSystemName());
            }
            String sysName = setElem.getAttribute("turnout").getValue();
            if (!turnouts.contains(sysName)) {
                Turnout to = InstanceManager.turnoutManagerInstance().provideTurnout(sysName);
                turnouts.add(sysName);
                BeanSetting bs = new BeanSetting(to, sysName, setting);
                path.addSetting(bs);
                continue;
            }
            ++dups;
        }
        if (dups > 0) {
            log.warn("{} duplicate settings not loaded for path \"{}\"", (Object)dups, (Object)pName);
        }
        return path;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(OBlockManager.class).getXMLOrder();
    }
}

