/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.logix.BlockOrder;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.SpeedUtil;
import jmri.jmrit.logix.ThrottleSetting;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.logix.WarrantRoute;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WarrantTableModel
extends BeanTableDataModel<Warrant> {
    public static final int WARRANT_COLUMN = 0;
    public static final int ROUTE_COLUMN = 1;
    public static final int TRAIN_NAME_COLUMN = 2;
    public static final int ADDRESS_COLUMN = 3;
    public static final int ALLOCATE_COLUMN = 4;
    public static final int DEALLOC_COLUMN = 5;
    public static final int SET_COLUMN = 6;
    public static final int AUTO_RUN_COLUMN = 7;
    public static final int MANUAL_RUN_COLUMN = 8;
    public static final int CONTROL_COLUMN = 9;
    public static final int EDIT_COLUMN = 10;
    public static final int DELETE_COLUMN = 11;
    public static final int NUMCOLS = 12;
    WarrantManager _manager;
    WarrantTableFrame _frame;
    private ArrayList<Warrant> _warList;
    private final ArrayList<Warrant> _warNX;
    static Color myGreen = new Color(0, 100, 0);
    static Color myGold = new Color(200, 100, 0);
    static String GREEN_LED = "resources/icons/smallschematics/tracksegments/circuit-green.gif";
    static String YELLOW_LED = "resources/icons/smallschematics/tracksegments/circuit-occupied.gif";
    static String OFF_LED = "resources/icons/smallschematics/tracksegments/circuit-empty.gif";
    static String RED_LED = "resources/icons/smallschematics/tracksegments/circuit-error.gif";
    private String _lastProperty;
    private long _propertyTime;
    private static final Logger log = LoggerFactory.getLogger((String)WarrantTableModel.class.getName());

    public WarrantTableModel(WarrantTableFrame frame) {
        this._frame = frame;
        this._manager = InstanceManager.getDefault(WarrantManager.class);
        this._manager.addPropertyChangeListener(this);
        this._warList = new ArrayList();
        this._warNX = new ArrayList();
    }

    public void addHeaderListener(JTable table) {
        this.addMouseListenerToHeader(table);
    }

    @Override
    public Manager<Warrant> getManager() {
        this._manager = InstanceManager.getDefault(WarrantManager.class);
        return this._manager;
    }

    @Override
    public Warrant getBySystemName(@Nonnull String name) {
        return (Warrant)this._manager.getBySystemName(name);
    }

    @Override
    public String getValue(String name) {
        Warrant w = (Warrant)this._manager.getBySystemName(name);
        if (w == null) {
            return null;
        }
        return w.getDisplayName();
    }

    @Override
    public Warrant getByUserName(@Nonnull String name) {
        return (Warrant)this._manager.getByUserName(name);
    }

    @Override
    protected String getBeanType() {
        return "Warrant";
    }

    @Override
    public void clickOn(Warrant t) {
    }

    @Override
    protected String getMasterClassName() {
        return WarrantTableModel.class.getName();
    }

    public synchronized void init() {
        ArrayList<Warrant> tempList = new ArrayList<Warrant>();
        for (Warrant w : this._manager.getNamedBeanSet()) {
            if (!this._warList.contains(w)) {
                w.addPropertyChangeListener(this);
            } else {
                this._warList.remove(w);
            }
            this.cleanBlockOrderList(w);
            tempList.add(w);
        }
        int i = 0;
        while (i < this._warList.size()) {
            Warrant w = this._warList.get(i);
            if (!this._warNX.contains(w)) {
                w.removePropertyChangeListener(this);
            }
            ++i;
        }
        i = 0;
        while (i < this._warNX.size()) {
            tempList.add(this._warNX.get(i));
            ++i;
        }
        this._warList = tempList;
    }

    private void cleanBlockOrderList(Warrant warrant) {
        ArrayList<BlockOrder> valid = new ArrayList<BlockOrder>();
        for (BlockOrder bo : warrant.getBlockOrders()) {
            if (WarrantRoute.pathIsValid(bo.getBlock(), bo.getPathName()) != null) continue;
            valid.add(bo);
        }
        warrant.setBlockOrders(valid);
    }

    protected void haltAllTrains() {
        ArrayList<Warrant> abortList = new ArrayList<Warrant>();
        for (Warrant w : this._warList) {
            if (w.getState() < 0) continue;
            abortList.add(w);
        }
        Iterator<Warrant> iter = abortList.iterator();
        while (iter.hasNext()) {
            iter.next().controlRunTrain(0);
        }
        this.fireTableUpdate();
    }

    protected void addNXWarrant(Warrant w) {
        this._warList.add(w);
        this._warNX.add(w);
        w.addPropertyChangeListener(this);
        this.fireTableUpdate();
    }

    public void removeWarrant(Warrant w, boolean deregister) {
        log.debug("removeWarrant {}", (Object)w.getDisplayName());
        this._warList.remove(w);
        this._warNX.remove(w);
        if (deregister) {
            this._manager.deregister(w);
        }
        w.dispose();
    }

    public Warrant getWarrantAt(int index) {
        if (index >= this._warList.size()) {
            return null;
        }
        return this._warList.get(index);
    }

    protected Warrant getWarrant(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (Warrant w : this._warList) {
            if (!name.equals(w.getUserName()) && !name.equals(w.getSystemName())) continue;
            return w;
        }
        return null;
    }

    protected String checkAddressInUse(Warrant warrant) {
        DccLocoAddress address = warrant.getSpeedUtil().getDccAddress();
        if (address == null) {
            return Bundle.getMessage("NoLoco");
        }
        for (Warrant w : this._warList) {
            if (w._runMode == 0 || !address.equals(w.getSpeedUtil().getDccAddress())) continue;
            return Bundle.getMessage("AddressInUse", address, w.getDisplayName(), w.getTrainName());
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._warList.size();
    }

    protected int getRow(Warrant w) {
        int row = -1;
        Iterator<Warrant> iter = this._warList.iterator();
        while (iter.hasNext()) {
            ++row;
            Warrant war = iter.next();
            if (!war.equals(w)) continue;
            return row;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Warrant");
            }
            case 1: {
                return Bundle.getMessage("Route");
            }
            case 2: {
                return Bundle.getMessage("TrainName");
            }
            case 3: {
                return Bundle.getMessage("DccAddress");
            }
            case 4: {
                return Bundle.getMessage("Allocate");
            }
            case 5: {
                return Bundle.getMessage("Deallocate");
            }
            case 6: {
                return Bundle.getMessage("SetRoute");
            }
            case 7: {
                return Bundle.getMessage("ARun");
            }
            case 8: {
                return Bundle.getMessage("MRun");
            }
            case 9: {
                return Bundle.getMessage("Control");
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return JButton.class;
            }
            case 5: {
                return JButton.class;
            }
            case 6: {
                return JButton.class;
            }
            case 7: {
                return JButton.class;
            }
            case 8: {
                return JButton.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return JButton.class;
            }
            case 11: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 2: 
            case 3: {
                return new JTextField((int)13).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)25).getPreferredSize().width;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new JButton((String)"Xxxx").getPreferredSize().width;
            }
            case 9: {
                return new JTextField((int)60).getPreferredSize().width;
            }
            case 10: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width;
            }
            case 11: {
                return new JButton((String)Bundle.getMessage((String)"ButtonDelete")).getPreferredSize().width;
            }
        }
        return new JTextField((int)10).getPreferredSize().width;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Warrant w = this.getWarrantAt(row);
        if (w == null) {
            log.warn("getValueAt row= {}, Warrant is null!", (Object)row);
            return "";
        }
        JRadioButton allocButton = new JRadioButton();
        JRadioButton deallocButton = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(allocButton);
        group.add(deallocButton);
        switch (col) {
            case 0: {
                return w.getDisplayName();
            }
            case 1: {
                BlockOrder bo0 = w.getfirstOrder();
                BlockOrder bo1 = w.getLastOrder();
                return Bundle.getMessage("WarrantRoute", bo0 == null ? "?" : bo0.getBlock().getDisplayName(), bo1 == null ? "?" : bo1.getBlock().getDisplayName());
            }
            case 2: {
                return w.getTrainName();
            }
            case 3: {
                return w.getSpeedUtil().getRosterId();
            }
            case 4: {
                NamedIcon icon = w.isTotalAllocated() ? new NamedIcon(GREEN_LED, "green") : (w.isAllocated() ? new NamedIcon(YELLOW_LED, "yellow") : new NamedIcon(OFF_LED, "off"));
                return icon;
            }
            case 5: {
                NamedIcon icon = w.isAllocated() ? new NamedIcon(OFF_LED, "off") : new NamedIcon(YELLOW_LED, "occupied");
                return icon;
            }
            case 6: {
                NamedIcon icon = w.hasRouteSet() ? (w.isTotalAllocated() ? new NamedIcon(GREEN_LED, "green") : (w.isAllocated() ? new NamedIcon(YELLOW_LED, "yellow") : new NamedIcon(RED_LED, "error"))) : new NamedIcon(OFF_LED, "off");
                return icon;
            }
            case 7: {
                NamedIcon icon = w.getRunMode() == 2 ? new NamedIcon(RED_LED, "red") : new NamedIcon(OFF_LED, "off");
                return icon;
            }
            case 8: {
                if (w.getRunMode() == 3) {
                    return new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "red");
                }
                return new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-empty.gif", "off");
            }
            case 9: {
                String msg = w.getRunningMessage();
                return msg;
            }
            case 10: {
                if (w.isNXWarrant()) {
                    return Bundle.getMessage("ButtonSave");
                }
                return Bundle.getMessage("ButtonEdit");
            }
            case 11: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Warrant w = this.getWarrantAt(row);
        if (w == null) {
            log.warn("setValueAt row= {}, Warrant is null!", (Object)row);
            return;
        }
        String msg = null;
        switch (col) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                w.setTrainName((String)value);
                break;
            }
            case 3: {
                if (w.getRunMode() == 0) {
                    String addr = (String)value;
                    if (w.getSpeedUtil().setAddress(addr)) break;
                    msg = Bundle.getMessage("BadDccAddress", addr);
                    break;
                }
                msg = w.getRunModeMessage();
                msg = Bundle.getMessage("CannotChangeAddress", w.getDisplayName(), msg);
                break;
            }
            case 4: {
                if (w.getRunMode() != 0) break;
                msg = w.allocateRoute(true, null);
                if (msg == null) {
                    this.setFrameStatusText(Bundle.getMessage("completeAllocate", w.getDisplayName()), myGreen, false);
                } else {
                    this.setFrameStatusText(String.valueOf(Bundle.getMessage("UnableToAllocate", w.getDisplayName())) + msg, myGold, false);
                    msg = null;
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 5: {
                if (w.getRunMode() == 0) {
                    w.deAllocate();
                    this.setFrameStatusText("", myGreen, false);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                this.setFrameStatusText(w.getRunModeMessage(), myGold, false);
                break;
            }
            case 6: {
                if (w.getRunMode() != 0) break;
                msg = w.setRoute(false, null);
                if (msg == null) {
                    this.setFrameStatusText(Bundle.getMessage("pathsSet", w.getDisplayName()), myGreen, false);
                } else {
                    this.setFrameStatusText(String.valueOf(Bundle.getMessage("UnableToAllocate", w.getDisplayName())) + msg, myGold, false);
                    msg = null;
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 7: {
                msg = this.frameRunTrain(w, 2);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 8: {
                msg = this.frameRunTrain(w, 3);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 9: {
                int mode = w.getRunMode();
                if (log.isTraceEnabled()) {
                    log.debug("setValueAt({}) for warrant {}", value, (Object)w.getDisplayName());
                }
                if (mode == 1) {
                    msg = Bundle.getMessage("Learning", w.getCurrentBlockName());
                    break;
                }
                if (value == null) break;
                String setting = (String)value;
                if (mode != 2 && mode != 3) break;
                int s = -1;
                if (setting.equals(WarrantTableFrame.halt)) {
                    s = 1;
                } else if (setting.equals(WarrantTableFrame.ramp)) {
                    s = 6;
                } else if (setting.equals(WarrantTableFrame.resume)) {
                    s = 2;
                } else if (setting.equals(WarrantTableFrame.speedup)) {
                    s = 7;
                } else if (setting.equals(WarrantTableFrame.retry)) {
                    s = 4;
                } else if (setting.equals(WarrantTableFrame.stop)) {
                    s = 5;
                } else if (setting.equals(WarrantTableFrame.abort)) {
                    s = 3;
                } else if (setting.isEmpty()) {
                    s = 8;
                }
                if (s == -1) break;
                w.controlRunTrain(s);
                break;
            }
            case 10: {
                if (w.isNXWarrant()) {
                    this.saveNXWarrant(w);
                    break;
                }
                this.openWarrantFrame(w);
                break;
            }
            case 11: {
                if (w.getRunMode() == 0) {
                    this.fireTableRowsDeleted(row, row);
                    this.removeWarrant(w, true);
                    break;
                }
                w.controlRunTrain(3);
                if (!this._warNX.contains(w)) break;
                this.fireTableRowsDeleted(row, row);
                this.removeWarrant(w, false);
                break;
            }
            default: {
                log.error("Invalid Column {} requested.", (Object)col);
                throw new IllegalArgumentException("Invalid Column " + col + " requested.");
            }
        }
        if (msg != null) {
            this.showMessageDialog(msg);
        }
    }

    private void showMessageDialog(String msg) {
        ThreadingUtil.runOnGUIEventually(() -> JOptionPane.showMessageDialog(this._frame, msg, Bundle.getMessage("WarningTitle"), 2));
    }

    private void openWarrantFrame(Warrant warrant) {
        for (Warrant w : this._warList) {
            if (!warrant.equals(w)) continue;
            WarrantTableAction.getDefault().editWarrantFrame(warrant);
            break;
        }
    }

    private void saveNXWarrant(Warrant warrant) {
        for (Warrant w : this._warNX) {
            if (!warrant.equals(w)) continue;
            Warrant war = this.cloneWarrant(warrant);
            WarrantTableAction.getDefault().makeWarrantFrame(war, null);
            break;
        }
    }

    private Warrant cloneWarrant(Warrant warrant) {
        Warrant w = new Warrant(InstanceManager.getDefault(WarrantManager.class).getAutoSystemName(), null);
        w.setTrainName(warrant.getTrainName());
        w.setRunBlind(warrant.getRunBlind());
        w.setShareRoute(warrant.getShareRoute());
        w.setAddTracker(warrant.getAddTracker());
        w.setNoRamp(warrant.getNoRamp());
        for (BlockOrder bo : warrant.getBlockOrders()) {
            w.addBlockOrder(new BlockOrder(bo));
        }
        w.setViaOrder(warrant.getViaOrder());
        w.setAvoidOrder(warrant.getAvoidOrder());
        for (ThrottleSetting ts : warrant.getThrottleCommands()) {
            w.addThrottleCommand(ts);
        }
        SpeedUtil copySU = w.getSpeedUtil();
        SpeedUtil su = warrant.getSpeedUtil();
        copySU.setDccAddress(su.getDccAddress());
        copySU.setRosterId(su.getRosterId());
        return w;
    }

    private String frameRunTrain(Warrant w, int mode) {
        return ThreadingUtil.runOnGUIwithReturn(() -> {
            String m = this._frame.runTrain(w, mode);
            return m;
        });
    }

    private void setFrameStatusText(String m, Color c, boolean save) {
        ThreadingUtil.runOnGUIEventually(() -> this._frame.setStatusText(m, c, true));
    }

    private void fireCellUpdate(int row, int col) {
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableCellUpdated(row, col));
    }

    private void fireTableUpdate() {
        ThreadingUtil.runOnGUIEventually(() -> this.fireTableDataChanged());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        long time = this._propertyTime;
        this._propertyTime = System.currentTimeMillis();
        if (this._propertyTime - time < 20L && property.equals(this._lastProperty) && !property.equals("length")) {
            return;
        }
        this._lastProperty = property;
        if (property.equals("length")) {
            this.init();
            this.fireTableUpdate();
        } else if (e.getSource() instanceof Warrant) {
            Warrant bean = (Warrant)e.getSource();
            log.debug("source is warrant {}", (Object)bean.getDisplayName());
            int i = 0;
            while (i < this._warList.size()) {
                if (bean.equals(this._warList.get(i))) {
                    if (this._warNX.contains(bean) && (property.equals("runMode") && (Integer)e.getNewValue() == 0 || property.equals("controlChange") && (Integer)e.getNewValue() == 3)) {
                        this.removeWarrant(bean, false);
                        this.fireTableRowsDeleted(i, i);
                        break;
                    }
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
                ++i;
            }
            int row = this.getRow(bean);
            if (row < 0) {
                return;
            }
            if (property.equals("blockChange")) {
                OBlock oldBlock = (OBlock)e.getOldValue();
                OBlock newBlock = (OBlock)e.getNewValue();
                if (newBlock == null) {
                    this.setFrameStatusText(Bundle.getMessage("ChangedRoute", bean.getDisplayName(), oldBlock.getDisplayName(), bean.getTrainName()), Color.red, true);
                } else {
                    this.setFrameStatusText(Bundle.getMessage("TrackerBlockEnter", bean.getTrainName(), newBlock.getDisplayName()), myGreen, true);
                }
            } else if (property.equals("SpeedChange")) {
                this.fireCellUpdate(row, 9);
            } else if (property.equals("WaitForSync")) {
                this.fireCellUpdate(row, 9);
            } else if (property.equals("waiting")) {
                this.fireCellUpdate(row, 9);
                this.setFrameStatusText((String)e.getNewValue(), myGreen, true);
            } else if (property.equals("SignalOverrun")) {
                String name = (String)e.getOldValue();
                String speed = (String)e.getNewValue();
                this.setFrameStatusText(Bundle.getMessage("SignalOverrun", bean.getTrainName(), speed, name), Color.red, true);
            } else if (property.equals("OccupyOverrun")) {
                String name = (String)e.getOldValue();
                String train = (String)e.getNewValue();
                this.setFrameStatusText(Bundle.getMessage("OccupyOverrun", bean.getTrainName(), train, name), Color.red, true);
            } else if (property.equals("runMode")) {
                int oldMode = (Integer)e.getOldValue();
                int newMode = (Integer)e.getNewValue();
                if (newMode == 4) {
                    if (oldMode != 0) {
                        this.setFrameStatusText(Bundle.getMessage("warrantAbort", bean.getTrainName(), bean.getDisplayName()), myGreen, true);
                    } else {
                        this.setFrameStatusText(Bundle.getMessage("warrantAnnull", bean.getTrainName(), bean.getDisplayName()), myGreen, true);
                    }
                } else if (oldMode == 0 && newMode != 0) {
                    String msg1 = bean.checkStartBlock();
                    if (msg1 == null) {
                        msg1 = "";
                    } else if (msg1.equals("BlockDark")) {
                        msg1 = Bundle.getMessage("startDark");
                    } else if (msg1.equals("warnStart")) {
                        msg1 = Bundle.getMessage("startUnoccupied");
                    }
                    String msg2 = bean.checkRoute();
                    if (msg2 == null) {
                        msg2 = "";
                    }
                    this.setFrameStatusText(Bundle.getMessage("warrantStart", bean.getTrainName(), bean.getDisplayName(), bean.getCurrentBlockName(), Bundle.getMessage("startAppendage", msg1, msg2, Bundle.getMessage(Warrant.MODES[newMode]))), myGreen, true);
                } else if (oldMode != 0 && newMode == 0) {
                    OBlock curBlock = bean.getCurrentBlockOrder().getBlock();
                    OBlock lastBlock = bean.getLastOrder().getBlock();
                    if (lastBlock.equals(curBlock)) {
                        this.setFrameStatusText(Bundle.getMessage("warrantComplete", bean.getTrainName(), bean.getDisplayName(), lastBlock.getDisplayName()), myGold, true);
                    } else {
                        this.setFrameStatusText(Bundle.getMessage("warrantEnd", bean.getTrainName(), bean.getDisplayName(), lastBlock.getDisplayName()), myGold, true);
                    }
                }
            } else if (property.equals("RampDone")) {
                boolean halt = (Boolean)e.getOldValue();
                String speed = (String)e.getNewValue();
                if (halt || speed.equals(Warrant.EStop)) {
                    this.setFrameStatusText(Bundle.getMessage("RampHalt", bean.getTrainName(), bean.getCurrentBlockName()), myGreen, true);
                } else if (WarrantPreferences.getDefault().getTrace()) {
                    log.info(Bundle.getMessage("RampSpeed", bean.getTrainName(), speed, bean.getCurrentBlockName()));
                }
                this.fireCellUpdate(row, 9);
            } else if (property.equals("ReadyToRun")) {
                this.setFrameStatusText(Bundle.getMessage("TrainReady", bean.getTrainName(), bean.getCurrentBlockName()), myGreen, true);
            } else if (property.equals("controlChange")) {
                Color color;
                String stateStr;
                String blkName = bean.getCurrentBlockName();
                if (e.getOldValue() == null) {
                    stateStr = Bundle.getMessage("engineerGone", blkName);
                    color = Color.red;
                } else {
                    int runState = (Integer)e.getOldValue();
                    stateStr = Bundle.getMessage(Warrant.RUN_STATE[runState], blkName);
                    color = myGold;
                }
                int newCntrl = (Integer)e.getNewValue();
                this.setFrameStatusText(Bundle.getMessage("controlChange", bean.getTrainName(), stateStr, Bundle.getMessage(Warrant.CNTRL_CMDS[newCntrl])), color, true);
                this.fireCellUpdate(row, 9);
            } else if (property.equals("controlFailed")) {
                String stateStr;
                String blkName = bean.getCurrentBlockName();
                if (e.getOldValue() == null) {
                    stateStr = Bundle.getMessage("engineerGone", blkName);
                } else {
                    int runState = (Integer)e.getOldValue();
                    stateStr = Bundle.getMessage(Warrant.RUN_STATE[runState], blkName);
                }
                int newCntrl = (Integer)e.getNewValue();
                this.setFrameStatusText(Bundle.getMessage("controlFailed", bean.getTrainName(), stateStr, Bundle.getMessage(Warrant.CNTRL_CMDS[newCntrl])), Color.red, true);
                this.fireCellUpdate(row, 9);
            } else if (property.equals("SensorSetCommand")) {
                String action = (String)e.getOldValue();
                String sensorName = (String)e.getNewValue();
                this.setFrameStatusText(Bundle.getMessage("setSensor", bean.getTrainName(), sensorName, action), myGreen, true);
            } else if (property.equals("SensorWaitCommand")) {
                String action = (String)e.getOldValue();
                String sensorName = (String)e.getNewValue();
                if (action != null) {
                    this.setFrameStatusText(Bundle.getMessage("waitSensor", bean.getTrainName(), sensorName, action), myGreen, true);
                } else {
                    this.setFrameStatusText(Bundle.getMessage("waitSensorChange", bean.getTrainName(), sensorName), myGreen, true);
                }
                this.fireCellUpdate(row, 9);
            } else if (property.equals("throttleFail")) {
                this.setFrameStatusText(Bundle.getMessage("ThrottleFail", bean.getTrainName(), e.getNewValue()), Color.red, true);
            }
            if (log.isDebugEnabled()) {
                log.debug("propertyChange of \"{}\" done for warrant \"{}\"", (Object)property, (Object)bean.getDisplayName());
            }
        }
    }
}

