/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logix;

import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.logix.Bundle;
import jmri.jmrit.logix.MergePrompt;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarrantShutdownTask
extends AbstractShutDownTask {
    HashMap<String, Boolean> _mergeCandidates;
    HashMap<String, RosterSpeedProfile> _mergeProfiles;
    Map<String, Map<Integer, Boolean>> _anomalies;
    private static final Logger log = LoggerFactory.getLogger(WarrantShutdownTask.class);

    public WarrantShutdownTask(String name) {
        super(name);
    }

    @Override
    public Boolean call() {
        WarrantPreferences preferences = WarrantPreferences.getDefault();
        switch (preferences.getShutdown()) {
            case MERGE_ALL: {
                if (!this.makeMergeCandidates()) break;
                if (this._anomalies != null && this._anomalies.size() > 0) {
                    this.makeMergeWindow();
                }
                this.setDoRun(true);
                break;
            }
            case PROMPT: {
                if (!this.makeMergeCandidates()) break;
                this.makeMergeWindow();
                this.setDoRun(true);
                break;
            }
            case NO_MERGE: {
                break;
            }
            default: {
                log.warn("No choice made for warrant shutdown");
            }
        }
        return true;
    }

    @Override
    public void run() {
        if (this.isDoRun()) {
            this.merge();
        }
    }

    private boolean makeMergeCandidates() {
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);
        this._mergeProfiles = manager.getMergeProfiles();
        if (this._mergeProfiles == null || this._mergeProfiles.isEmpty()) {
            return false;
        }
        this._anomalies = new HashMap<String, Map<Integer, Boolean>>();
        this._mergeCandidates = new HashMap();
        for (Map.Entry<String, RosterSpeedProfile> entry : this._mergeProfiles.entrySet()) {
            Map<Integer, Boolean> anomaly = MergePrompt.validateSpeedProfile(entry.getValue());
            if (anomaly != null && anomaly.size() > 0) {
                this._anomalies.put(entry.getKey(), anomaly);
            }
            String rosterId = entry.getKey();
            if (Roster.getDefault().getEntryForId(rosterId) == null) continue;
            this._mergeCandidates.put(rosterId, true);
        }
        return !this._mergeCandidates.isEmpty();
    }

    private void makeMergeWindow() {
        new MergePrompt(Bundle.getMessage("MergeTitle"), this._mergeCandidates, this._anomalies);
    }

    private void merge() {
        this._mergeCandidates.forEach((id, merge) -> {
            if (merge.booleanValue()) {
                RosterEntry rosterEntry = Roster.getDefault().entryFromTitle((String)id);
                if (rosterEntry != null) {
                    rosterEntry.setSpeedProfile(this._mergeProfiles.get(id));
                    log.debug("Write SpeedProfile to Roster. id= {}", id);
                } else {
                    log.debug("Unable to Write SpeedProfile to Roster. No RosterEntry for {}", id);
                }
            } else {
                log.debug("SpeedProfile not merged to Roster. id= {}", id);
            }
        });
        Roster.getDefault().writeRoster();
    }
}

